// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerWaitLibpodReader is a Reader for the ContainerWaitLibpod structure.
type ContainerWaitLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerWaitLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewContainerWaitLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerWaitLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerWaitLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerWaitLibpodOK creates a ContainerWaitLibpodOK with default headers values
func NewContainerWaitLibpodOK() *ContainerWaitLibpodOK {
	return &ContainerWaitLibpodOK{}
}

/*
ContainerWaitLibpodOK describes a response with status code 200, with default header values.

Status code
*/
type ContainerWaitLibpodOK struct {
	Payload int32
}

// IsSuccess returns true when this container wait libpod o k response has a 2xx status code
func (o *ContainerWaitLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container wait libpod o k response has a 3xx status code
func (o *ContainerWaitLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container wait libpod o k response has a 4xx status code
func (o *ContainerWaitLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this container wait libpod o k response has a 5xx status code
func (o *ContainerWaitLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this container wait libpod o k response a status code equal to that given
func (o *ContainerWaitLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ContainerWaitLibpodOK) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/wait][%d] containerWaitLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainerWaitLibpodOK) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/wait][%d] containerWaitLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainerWaitLibpodOK) GetPayload() int32 {
	return o.Payload
}

func (o *ContainerWaitLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerWaitLibpodNotFound creates a ContainerWaitLibpodNotFound with default headers values
func NewContainerWaitLibpodNotFound() *ContainerWaitLibpodNotFound {
	return &ContainerWaitLibpodNotFound{}
}

/*
ContainerWaitLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerWaitLibpodNotFound struct {
	Payload *ContainerWaitLibpodNotFoundBody
}

// IsSuccess returns true when this container wait libpod not found response has a 2xx status code
func (o *ContainerWaitLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container wait libpod not found response has a 3xx status code
func (o *ContainerWaitLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container wait libpod not found response has a 4xx status code
func (o *ContainerWaitLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container wait libpod not found response has a 5xx status code
func (o *ContainerWaitLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container wait libpod not found response a status code equal to that given
func (o *ContainerWaitLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerWaitLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/wait][%d] containerWaitLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerWaitLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/wait][%d] containerWaitLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerWaitLibpodNotFound) GetPayload() *ContainerWaitLibpodNotFoundBody {
	return o.Payload
}

func (o *ContainerWaitLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerWaitLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerWaitLibpodInternalServerError creates a ContainerWaitLibpodInternalServerError with default headers values
func NewContainerWaitLibpodInternalServerError() *ContainerWaitLibpodInternalServerError {
	return &ContainerWaitLibpodInternalServerError{}
}

/*
ContainerWaitLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerWaitLibpodInternalServerError struct {
	Payload *ContainerWaitLibpodInternalServerErrorBody
}

// IsSuccess returns true when this container wait libpod internal server error response has a 2xx status code
func (o *ContainerWaitLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container wait libpod internal server error response has a 3xx status code
func (o *ContainerWaitLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container wait libpod internal server error response has a 4xx status code
func (o *ContainerWaitLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container wait libpod internal server error response has a 5xx status code
func (o *ContainerWaitLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container wait libpod internal server error response a status code equal to that given
func (o *ContainerWaitLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerWaitLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/wait][%d] containerWaitLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerWaitLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/wait][%d] containerWaitLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerWaitLibpodInternalServerError) GetPayload() *ContainerWaitLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerWaitLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerWaitLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerWaitLibpodInternalServerErrorBody container wait libpod internal server error body
swagger:model ContainerWaitLibpodInternalServerErrorBody
*/
type ContainerWaitLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container wait libpod internal server error body
func (o *ContainerWaitLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container wait libpod internal server error body based on context it is used
func (o *ContainerWaitLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerWaitLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerWaitLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerWaitLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerWaitLibpodNotFoundBody container wait libpod not found body
swagger:model ContainerWaitLibpodNotFoundBody
*/
type ContainerWaitLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container wait libpod not found body
func (o *ContainerWaitLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container wait libpod not found body based on context it is used
func (o *ContainerWaitLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerWaitLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerWaitLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerWaitLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
