// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new containers API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for containers API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ContainerAttachLibpod(params *ContainerAttachLibpodParams, opts ...ClientOption) error

	ContainerChangesLibpod(params *ContainerChangesLibpodParams, opts ...ClientOption) (*ContainerChangesLibpodOK, error)

	ContainerCheckpointLibpod(params *ContainerCheckpointLibpodParams, opts ...ClientOption) (*ContainerCheckpointLibpodOK, error)

	ContainerCreateLibpod(params *ContainerCreateLibpodParams, opts ...ClientOption) (*ContainerCreateLibpodCreated, error)

	ContainerDeleteLibpod(params *ContainerDeleteLibpodParams, opts ...ClientOption) (*ContainerDeleteLibpodOK, *ContainerDeleteLibpodNoContent, error)

	ContainerExistsLibpod(params *ContainerExistsLibpodParams, opts ...ClientOption) (*ContainerExistsLibpodNoContent, error)

	ContainerExportLibpod(params *ContainerExportLibpodParams, opts ...ClientOption) (*ContainerExportLibpodOK, error)

	ContainerHealthcheckLibpod(params *ContainerHealthcheckLibpodParams, opts ...ClientOption) (*ContainerHealthcheckLibpodOK, error)

	ContainerInitLibpod(params *ContainerInitLibpodParams, opts ...ClientOption) (*ContainerInitLibpodNoContent, error)

	ContainerInspectLibpod(params *ContainerInspectLibpodParams, opts ...ClientOption) (*ContainerInspectLibpodOK, error)

	ContainerKillLibpod(params *ContainerKillLibpodParams, opts ...ClientOption) (*ContainerKillLibpodNoContent, error)

	ContainerListLibpod(params *ContainerListLibpodParams, opts ...ClientOption) (*ContainerListLibpodOK, error)

	ContainerLogsLibpod(params *ContainerLogsLibpodParams, opts ...ClientOption) (*ContainerLogsLibpodOK, error)

	ContainerMountLibpod(params *ContainerMountLibpodParams, opts ...ClientOption) (*ContainerMountLibpodOK, error)

	ContainerPauseLibpod(params *ContainerPauseLibpodParams, opts ...ClientOption) (*ContainerPauseLibpodNoContent, error)

	ContainerPruneLibpod(params *ContainerPruneLibpodParams, opts ...ClientOption) (*ContainerPruneLibpodOK, error)

	ContainerRenameLibpod(params *ContainerRenameLibpodParams, opts ...ClientOption) (*ContainerRenameLibpodNoContent, error)

	ContainerResizeLibpod(params *ContainerResizeLibpodParams, opts ...ClientOption) (*ContainerResizeLibpodOK, error)

	ContainerRestartLibpod(params *ContainerRestartLibpodParams, opts ...ClientOption) (*ContainerRestartLibpodNoContent, error)

	ContainerRestoreLibpod(params *ContainerRestoreLibpodParams, opts ...ClientOption) (*ContainerRestoreLibpodOK, error)

	ContainerShowMountedLibpod(params *ContainerShowMountedLibpodParams, opts ...ClientOption) (*ContainerShowMountedLibpodOK, error)

	ContainerStartLibpod(params *ContainerStartLibpodParams, opts ...ClientOption) (*ContainerStartLibpodNoContent, error)

	ContainerStatsLibpod(params *ContainerStatsLibpodParams, opts ...ClientOption) (*ContainerStatsLibpodOK, error)

	ContainerStopLibpod(params *ContainerStopLibpodParams, opts ...ClientOption) (*ContainerStopLibpodNoContent, error)

	ContainerTopLibpod(params *ContainerTopLibpodParams, opts ...ClientOption) (*ContainerTopLibpodOK, error)

	ContainerUnmountLibpod(params *ContainerUnmountLibpodParams, opts ...ClientOption) (*ContainerUnmountLibpodNoContent, error)

	ContainerUnpauseLibpod(params *ContainerUnpauseLibpodParams, opts ...ClientOption) (*ContainerUnpauseLibpodNoContent, error)

	ContainerWaitLibpod(params *ContainerWaitLibpodParams, opts ...ClientOption) (*ContainerWaitLibpodOK, error)

	ContainersStatsAllLibpod(params *ContainersStatsAllLibpodParams, opts ...ClientOption) (*ContainersStatsAllLibpodOK, error)

	GenerateKubeLibpod(params *GenerateKubeLibpodParams, writer io.Writer, opts ...ClientOption) (*GenerateKubeLibpodOK, error)

	GenerateSystemdLibpod(params *GenerateSystemdLibpodParams, opts ...ClientOption) (*GenerateSystemdLibpodOK, error)

	ImageCommitLibpod(params *ImageCommitLibpodParams, opts ...ClientOption) (*ImageCommitLibpodCreated, error)

	PlayKubeDownLibpod(params *PlayKubeDownLibpodParams, opts ...ClientOption) (*PlayKubeDownLibpodOK, error)

	PlayKubeLibpod(params *PlayKubeLibpodParams, opts ...ClientOption) (*PlayKubeLibpodOK, error)

	PutContainerArchiveLibpod(params *PutContainerArchiveLibpodParams, opts ...ClientOption) (*PutContainerArchiveLibpodOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
ContainerAttachLibpod attaches to a container

Hijacks the connection to forward the container's standard streams to the client.
*/
func (a *Client) ContainerAttachLibpod(params *ContainerAttachLibpodParams, opts ...ClientOption) error {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerAttachLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerAttachLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/attach",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerAttachLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	_, err := a.transport.Submit(op)
	if err != nil {
		return err
	}
	return nil
}

/*
	ContainerChangesLibpod reports on changes to container s filesystem adds deletes or modifications

	Returns which files in a container's filesystem have been added, deleted, or modified. The Kind of modification can be one of:

0: Modified
1: Added
2: Deleted
*/
func (a *Client) ContainerChangesLibpod(params *ContainerChangesLibpodParams, opts ...ClientOption) (*ContainerChangesLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerChangesLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerChangesLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/containers/{name}/changes",
		ProducesMediaTypes: []string{"application/json", "application/octet-stream", "text/plain"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerChangesLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerChangesLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerChangesLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerCheckpointLibpod checkpoints a container
*/
func (a *Client) ContainerCheckpointLibpod(params *ContainerCheckpointLibpodParams, opts ...ClientOption) (*ContainerCheckpointLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerCheckpointLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerCheckpointLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/checkpoint",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerCheckpointLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerCheckpointLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerCheckpointLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerCreateLibpod creates a container
*/
func (a *Client) ContainerCreateLibpod(params *ContainerCreateLibpodParams, opts ...ClientOption) (*ContainerCreateLibpodCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerCreateLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerCreateLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/create",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerCreateLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerCreateLibpodCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerCreateLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerDeleteLibpod deletes container

Delete container
*/
func (a *Client) ContainerDeleteLibpod(params *ContainerDeleteLibpodParams, opts ...ClientOption) (*ContainerDeleteLibpodOK, *ContainerDeleteLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerDeleteLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerDeleteLibpod",
		Method:             "DELETE",
		PathPattern:        "/libpod/containers/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerDeleteLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ContainerDeleteLibpodOK:
		return value, nil, nil
	case *ContainerDeleteLibpodNoContent:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for containers: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerExistsLibpod checks if container exists

Quick way to determine if a container exists by name or ID
*/
func (a *Client) ContainerExistsLibpod(params *ContainerExistsLibpodParams, opts ...ClientOption) (*ContainerExistsLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerExistsLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerExistsLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/containers/{name}/exists",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerExistsLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerExistsLibpodNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerExistsLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerExportLibpod exports a container

Export the contents of a container as a tarball.
*/
func (a *Client) ContainerExportLibpod(params *ContainerExportLibpodParams, opts ...ClientOption) (*ContainerExportLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerExportLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerExportLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/containers/{name}/export",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerExportLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerExportLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerExportLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerHealthcheckLibpod runs a container s healthcheck

Execute the defined healthcheck and return information about the results
*/
func (a *Client) ContainerHealthcheckLibpod(params *ContainerHealthcheckLibpodParams, opts ...ClientOption) (*ContainerHealthcheckLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerHealthcheckLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerHealthcheckLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/containers/{name}/healthcheck",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerHealthcheckLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerHealthcheckLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerHealthcheckLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerInitLibpod initializes a container

Performs all tasks necessary for initializing the container but does not start the container.
*/
func (a *Client) ContainerInitLibpod(params *ContainerInitLibpodParams, opts ...ClientOption) (*ContainerInitLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerInitLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerInitLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/init",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerInitLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerInitLibpodNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerInitLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerInspectLibpod inspects container

Return low-level information about a container.
*/
func (a *Client) ContainerInspectLibpod(params *ContainerInspectLibpodParams, opts ...ClientOption) (*ContainerInspectLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerInspectLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerInspectLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/containers/{name}/json",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerInspectLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerInspectLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerInspectLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerKillLibpod kills container

send a signal to a container, defaults to killing the container
*/
func (a *Client) ContainerKillLibpod(params *ContainerKillLibpodParams, opts ...ClientOption) (*ContainerKillLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerKillLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerKillLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/kill",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerKillLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerKillLibpodNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerKillLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerListLibpod lists containers

Returns a list of containers
*/
func (a *Client) ContainerListLibpod(params *ContainerListLibpodParams, opts ...ClientOption) (*ContainerListLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerListLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerListLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/containers/json",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerListLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerListLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerListLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerLogsLibpod gets container logs

Get stdout and stderr logs from a container.
*/
func (a *Client) ContainerLogsLibpod(params *ContainerLogsLibpodParams, opts ...ClientOption) (*ContainerLogsLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerLogsLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerLogsLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/containers/{name}/logs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerLogsLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerLogsLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerLogsLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerMountLibpod mounts a container

Mount a container to the filesystem
*/
func (a *Client) ContainerMountLibpod(params *ContainerMountLibpodParams, opts ...ClientOption) (*ContainerMountLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerMountLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerMountLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/mount",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerMountLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerMountLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerMountLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerPauseLibpod pauses a container

Use the cgroups freezer to suspend all processes in a container.
*/
func (a *Client) ContainerPauseLibpod(params *ContainerPauseLibpodParams, opts ...ClientOption) (*ContainerPauseLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerPauseLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerPauseLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/pause",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerPauseLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerPauseLibpodNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerPauseLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerPruneLibpod deletes stopped containers

Remove containers not in use
*/
func (a *Client) ContainerPruneLibpod(params *ContainerPruneLibpodParams, opts ...ClientOption) (*ContainerPruneLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerPruneLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerPruneLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/prune",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerPruneLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerPruneLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerPruneLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerRenameLibpod renames an existing container

Change the name of an existing container.
*/
func (a *Client) ContainerRenameLibpod(params *ContainerRenameLibpodParams, opts ...ClientOption) (*ContainerRenameLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerRenameLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerRenameLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/rename",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerRenameLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerRenameLibpodNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerRenameLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerResizeLibpod resizes a container s t t y

Resize the terminal attached to a container (for use with Attach).
*/
func (a *Client) ContainerResizeLibpod(params *ContainerResizeLibpodParams, opts ...ClientOption) (*ContainerResizeLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerResizeLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerResizeLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/resize",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerResizeLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerResizeLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerResizeLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerRestartLibpod restarts a container
*/
func (a *Client) ContainerRestartLibpod(params *ContainerRestartLibpodParams, opts ...ClientOption) (*ContainerRestartLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerRestartLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerRestartLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/restart",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerRestartLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerRestartLibpodNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerRestartLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerRestoreLibpod restores a container

Restore a container from a checkpoint.
*/
func (a *Client) ContainerRestoreLibpod(params *ContainerRestoreLibpodParams, opts ...ClientOption) (*ContainerRestoreLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerRestoreLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerRestoreLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/restore",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerRestoreLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerRestoreLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerRestoreLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerShowMountedLibpod shows mounted containers

Lists all mounted containers mount points
*/
func (a *Client) ContainerShowMountedLibpod(params *ContainerShowMountedLibpodParams, opts ...ClientOption) (*ContainerShowMountedLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerShowMountedLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerShowMountedLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/containers/showmounted",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerShowMountedLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerShowMountedLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerShowMountedLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerStartLibpod starts a container
*/
func (a *Client) ContainerStartLibpod(params *ContainerStartLibpodParams, opts ...ClientOption) (*ContainerStartLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerStartLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerStartLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/start",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerStartLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerStartLibpodNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerStartLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerStatsLibpod gets stats for a container

DEPRECATED. This endpoint will be removed with the next major release. Please use /libpod/containers/stats instead.
*/
func (a *Client) ContainerStatsLibpod(params *ContainerStatsLibpodParams, opts ...ClientOption) (*ContainerStatsLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerStatsLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerStatsLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/containers/{name}/stats",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerStatsLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerStatsLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerStatsLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerStopLibpod stops a container
*/
func (a *Client) ContainerStopLibpod(params *ContainerStopLibpodParams, opts ...ClientOption) (*ContainerStopLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerStopLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerStopLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/stop",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerStopLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerStopLibpodNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerStopLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerTopLibpod lists processes

List processes running inside a container
*/
func (a *Client) ContainerTopLibpod(params *ContainerTopLibpodParams, opts ...ClientOption) (*ContainerTopLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerTopLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerTopLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/containers/{name}/top",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerTopLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerTopLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerTopLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerUnmountLibpod unmounts a container

Unmount a container from the filesystem
*/
func (a *Client) ContainerUnmountLibpod(params *ContainerUnmountLibpodParams, opts ...ClientOption) (*ContainerUnmountLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerUnmountLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerUnmountLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/unmount",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerUnmountLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerUnmountLibpodNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerUnmountLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerUnpauseLibpod unpauses container
*/
func (a *Client) ContainerUnpauseLibpod(params *ContainerUnpauseLibpodParams, opts ...ClientOption) (*ContainerUnpauseLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerUnpauseLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerUnpauseLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/unpause",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerUnpauseLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerUnpauseLibpodNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerUnpauseLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainerWaitLibpod waits on a container

Wait on a container to met a given condition
*/
func (a *Client) ContainerWaitLibpod(params *ContainerWaitLibpodParams, opts ...ClientOption) (*ContainerWaitLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerWaitLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerWaitLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/wait",
		ProducesMediaTypes: []string{"application/json", "text/plain"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerWaitLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerWaitLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerWaitLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ContainersStatsAllLibpod gets stats for one or more containers

Return a live stream of resource usage statistics of one or more container. If no container is specified, the statistics of all containers are returned.
*/
func (a *Client) ContainersStatsAllLibpod(params *ContainersStatsAllLibpodParams, opts ...ClientOption) (*ContainersStatsAllLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainersStatsAllLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainersStatsAllLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/containers/stats",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainersStatsAllLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainersStatsAllLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainersStatsAllLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GenerateKubeLibpod generates a kubernetes y a m l file

Generate Kubernetes YAML based on a pod or container.
*/
func (a *Client) GenerateKubeLibpod(params *GenerateKubeLibpodParams, writer io.Writer, opts ...ClientOption) (*GenerateKubeLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGenerateKubeLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GenerateKubeLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/generate/kube",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GenerateKubeLibpodReader{formats: a.formats, writer: writer},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GenerateKubeLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GenerateKubeLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GenerateSystemdLibpod generates systemd units

Generate Systemd Units based on a pod or container.
*/
func (a *Client) GenerateSystemdLibpod(params *GenerateSystemdLibpodParams, opts ...ClientOption) (*GenerateSystemdLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGenerateSystemdLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GenerateSystemdLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/generate/{name}/systemd",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GenerateSystemdLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GenerateSystemdLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GenerateSystemdLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageCommitLibpod commits

Create a new image from a container
*/
func (a *Client) ImageCommitLibpod(params *ImageCommitLibpodParams, opts ...ClientOption) (*ImageCommitLibpodCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageCommitLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageCommitLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/commit",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageCommitLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageCommitLibpodCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageCommitLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PlayKubeDownLibpod removes pods from play kube

Tears down pods defined in a YAML file
*/
func (a *Client) PlayKubeDownLibpod(params *PlayKubeDownLibpodParams, opts ...ClientOption) (*PlayKubeDownLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPlayKubeDownLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PlayKubeDownLibpod",
		Method:             "DELETE",
		PathPattern:        "/libpod/play/kube",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PlayKubeDownLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PlayKubeDownLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PlayKubeDownLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PlayKubeLibpod plays a kubernetes y a m l file

Create and run pods based on a Kubernetes YAML file (pod or service kind).
*/
func (a *Client) PlayKubeLibpod(params *PlayKubeLibpodParams, opts ...ClientOption) (*PlayKubeLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPlayKubeLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PlayKubeLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/play/kube",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PlayKubeLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PlayKubeLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PlayKubeLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PutContainerArchiveLibpod copies files into a container

Copy a tar archive of files into a container
*/
func (a *Client) PutContainerArchiveLibpod(params *PutContainerArchiveLibpodParams, opts ...ClientOption) (*PutContainerArchiveLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPutContainerArchiveLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PutContainerArchiveLibpod",
		Method:             "PUT",
		PathPattern:        "/libpod/containers/{name}/archive",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PutContainerArchiveLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PutContainerArchiveLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PutContainerArchiveLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
