// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// ContainersStatsAllLibpodReader is a Reader for the ContainersStatsAllLibpod structure.
type ContainersStatsAllLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainersStatsAllLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewContainersStatsAllLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainersStatsAllLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainersStatsAllLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainersStatsAllLibpodOK creates a ContainersStatsAllLibpodOK with default headers values
func NewContainersStatsAllLibpodOK() *ContainersStatsAllLibpodOK {
	return &ContainersStatsAllLibpodOK{}
}

/*
ContainersStatsAllLibpodOK describes a response with status code 200, with default header values.

Get stats for one or more containers
*/
type ContainersStatsAllLibpodOK struct {
	Payload *ContainersStatsAllLibpodOKBody
}

// IsSuccess returns true when this containers stats all libpod o k response has a 2xx status code
func (o *ContainersStatsAllLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this containers stats all libpod o k response has a 3xx status code
func (o *ContainersStatsAllLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this containers stats all libpod o k response has a 4xx status code
func (o *ContainersStatsAllLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this containers stats all libpod o k response has a 5xx status code
func (o *ContainersStatsAllLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this containers stats all libpod o k response a status code equal to that given
func (o *ContainersStatsAllLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ContainersStatsAllLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/stats][%d] containersStatsAllLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainersStatsAllLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/containers/stats][%d] containersStatsAllLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainersStatsAllLibpodOK) GetPayload() *ContainersStatsAllLibpodOKBody {
	return o.Payload
}

func (o *ContainersStatsAllLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainersStatsAllLibpodOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainersStatsAllLibpodNotFound creates a ContainersStatsAllLibpodNotFound with default headers values
func NewContainersStatsAllLibpodNotFound() *ContainersStatsAllLibpodNotFound {
	return &ContainersStatsAllLibpodNotFound{}
}

/*
ContainersStatsAllLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainersStatsAllLibpodNotFound struct {
	Payload *ContainersStatsAllLibpodNotFoundBody
}

// IsSuccess returns true when this containers stats all libpod not found response has a 2xx status code
func (o *ContainersStatsAllLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this containers stats all libpod not found response has a 3xx status code
func (o *ContainersStatsAllLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this containers stats all libpod not found response has a 4xx status code
func (o *ContainersStatsAllLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this containers stats all libpod not found response has a 5xx status code
func (o *ContainersStatsAllLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this containers stats all libpod not found response a status code equal to that given
func (o *ContainersStatsAllLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainersStatsAllLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/stats][%d] containersStatsAllLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainersStatsAllLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/containers/stats][%d] containersStatsAllLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainersStatsAllLibpodNotFound) GetPayload() *ContainersStatsAllLibpodNotFoundBody {
	return o.Payload
}

func (o *ContainersStatsAllLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainersStatsAllLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainersStatsAllLibpodInternalServerError creates a ContainersStatsAllLibpodInternalServerError with default headers values
func NewContainersStatsAllLibpodInternalServerError() *ContainersStatsAllLibpodInternalServerError {
	return &ContainersStatsAllLibpodInternalServerError{}
}

/*
ContainersStatsAllLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainersStatsAllLibpodInternalServerError struct {
	Payload *ContainersStatsAllLibpodInternalServerErrorBody
}

// IsSuccess returns true when this containers stats all libpod internal server error response has a 2xx status code
func (o *ContainersStatsAllLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this containers stats all libpod internal server error response has a 3xx status code
func (o *ContainersStatsAllLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this containers stats all libpod internal server error response has a 4xx status code
func (o *ContainersStatsAllLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this containers stats all libpod internal server error response has a 5xx status code
func (o *ContainersStatsAllLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this containers stats all libpod internal server error response a status code equal to that given
func (o *ContainersStatsAllLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainersStatsAllLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/stats][%d] containersStatsAllLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainersStatsAllLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/containers/stats][%d] containersStatsAllLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainersStatsAllLibpodInternalServerError) GetPayload() *ContainersStatsAllLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainersStatsAllLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainersStatsAllLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainersStatsAllLibpodInternalServerErrorBody containers stats all libpod internal server error body
swagger:model ContainersStatsAllLibpodInternalServerErrorBody
*/
type ContainersStatsAllLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this containers stats all libpod internal server error body
func (o *ContainersStatsAllLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this containers stats all libpod internal server error body based on context it is used
func (o *ContainersStatsAllLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainersStatsAllLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainersStatsAllLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainersStatsAllLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainersStatsAllLibpodNotFoundBody containers stats all libpod not found body
swagger:model ContainersStatsAllLibpodNotFoundBody
*/
type ContainersStatsAllLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this containers stats all libpod not found body
func (o *ContainersStatsAllLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this containers stats all libpod not found body based on context it is used
func (o *ContainersStatsAllLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainersStatsAllLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainersStatsAllLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainersStatsAllLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainersStatsAllLibpodOKBody containers stats all libpod o k body
swagger:model ContainersStatsAllLibpodOKBody
*/
type ContainersStatsAllLibpodOKBody struct {

	// avg CPU
	AvgCPU float64 `json:"AvgCPU,omitempty"`

	// block input
	BlockInput uint64 `json:"BlockInput,omitempty"`

	// block output
	BlockOutput uint64 `json:"BlockOutput,omitempty"`

	// CPU
	CPU float64 `json:"CPU,omitempty"`

	// CPU nano
	CPUNano uint64 `json:"CPUNano,omitempty"`

	// CPU system nano
	CPUSystemNano uint64 `json:"CPUSystemNano,omitempty"`

	// container ID
	ContainerID string `json:"ContainerID,omitempty"`

	// duration
	Duration uint64 `json:"Duration,omitempty"`

	// mem limit
	MemLimit uint64 `json:"MemLimit,omitempty"`

	// mem perc
	MemPerc float64 `json:"MemPerc,omitempty"`

	// mem usage
	MemUsage uint64 `json:"MemUsage,omitempty"`

	// name
	Name string `json:"Name,omitempty"`

	// net input
	NetInput uint64 `json:"NetInput,omitempty"`

	// net output
	NetOutput uint64 `json:"NetOutput,omitempty"`

	// p i ds
	PIDs uint64 `json:"PIDs,omitempty"`

	// per CPU
	PerCPU []uint64 `json:"PerCPU"`

	// system nano
	SystemNano uint64 `json:"SystemNano,omitempty"`

	// up time
	UpTime models.Duration `json:"UpTime,omitempty"`
}

// Validate validates this containers stats all libpod o k body
func (o *ContainersStatsAllLibpodOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validate this containers stats all libpod o k body based on the context it is used
func (o *ContainersStatsAllLibpodOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateUpTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ContainersStatsAllLibpodOKBody) contextValidateUpTime(ctx context.Context, formats strfmt.Registry) error {

	if err := o.UpTime.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("containersStatsAllLibpodOK" + "." + "UpTime")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("containersStatsAllLibpodOK" + "." + "UpTime")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ContainersStatsAllLibpodOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainersStatsAllLibpodOKBody) UnmarshalBinary(b []byte) error {
	var res ContainersStatsAllLibpodOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
