// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// PlayKubeDownLibpodReader is a Reader for the PlayKubeDownLibpod structure.
type PlayKubeDownLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PlayKubeDownLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPlayKubeDownLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewPlayKubeDownLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewPlayKubeDownLibpodOK creates a PlayKubeDownLibpodOK with default headers values
func NewPlayKubeDownLibpodOK() *PlayKubeDownLibpodOK {
	return &PlayKubeDownLibpodOK{}
}

/*
PlayKubeDownLibpodOK describes a response with status code 200, with default header values.

PlayKube response
*/
type PlayKubeDownLibpodOK struct {
	Payload *models.PlayKubeReport
}

// IsSuccess returns true when this play kube down libpod o k response has a 2xx status code
func (o *PlayKubeDownLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this play kube down libpod o k response has a 3xx status code
func (o *PlayKubeDownLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this play kube down libpod o k response has a 4xx status code
func (o *PlayKubeDownLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this play kube down libpod o k response has a 5xx status code
func (o *PlayKubeDownLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this play kube down libpod o k response a status code equal to that given
func (o *PlayKubeDownLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *PlayKubeDownLibpodOK) Error() string {
	return fmt.Sprintf("[DELETE /libpod/play/kube][%d] playKubeDownLibpodOK  %+v", 200, o.Payload)
}

func (o *PlayKubeDownLibpodOK) String() string {
	return fmt.Sprintf("[DELETE /libpod/play/kube][%d] playKubeDownLibpodOK  %+v", 200, o.Payload)
}

func (o *PlayKubeDownLibpodOK) GetPayload() *models.PlayKubeReport {
	return o.Payload
}

func (o *PlayKubeDownLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PlayKubeReport)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPlayKubeDownLibpodInternalServerError creates a PlayKubeDownLibpodInternalServerError with default headers values
func NewPlayKubeDownLibpodInternalServerError() *PlayKubeDownLibpodInternalServerError {
	return &PlayKubeDownLibpodInternalServerError{}
}

/*
PlayKubeDownLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type PlayKubeDownLibpodInternalServerError struct {
	Payload *PlayKubeDownLibpodInternalServerErrorBody
}

// IsSuccess returns true when this play kube down libpod internal server error response has a 2xx status code
func (o *PlayKubeDownLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this play kube down libpod internal server error response has a 3xx status code
func (o *PlayKubeDownLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this play kube down libpod internal server error response has a 4xx status code
func (o *PlayKubeDownLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this play kube down libpod internal server error response has a 5xx status code
func (o *PlayKubeDownLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this play kube down libpod internal server error response a status code equal to that given
func (o *PlayKubeDownLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *PlayKubeDownLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /libpod/play/kube][%d] playKubeDownLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PlayKubeDownLibpodInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /libpod/play/kube][%d] playKubeDownLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PlayKubeDownLibpodInternalServerError) GetPayload() *PlayKubeDownLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *PlayKubeDownLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PlayKubeDownLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PlayKubeDownLibpodInternalServerErrorBody play kube down libpod internal server error body
swagger:model PlayKubeDownLibpodInternalServerErrorBody
*/
type PlayKubeDownLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this play kube down libpod internal server error body
func (o *PlayKubeDownLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this play kube down libpod internal server error body based on context it is used
func (o *PlayKubeDownLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PlayKubeDownLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PlayKubeDownLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res PlayKubeDownLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
