// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerUnpauseReader is a Reader for the ContainerUnpause structure.
type ContainerUnpauseReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerUnpauseReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewContainerUnpauseNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerUnpauseNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerUnpauseInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerUnpauseNoContent creates a ContainerUnpauseNoContent with default headers values
func NewContainerUnpauseNoContent() *ContainerUnpauseNoContent {
	return &ContainerUnpauseNoContent{}
}

/*
ContainerUnpauseNoContent describes a response with status code 204, with default header values.

no error
*/
type ContainerUnpauseNoContent struct {
}

// IsSuccess returns true when this container unpause no content response has a 2xx status code
func (o *ContainerUnpauseNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container unpause no content response has a 3xx status code
func (o *ContainerUnpauseNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container unpause no content response has a 4xx status code
func (o *ContainerUnpauseNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this container unpause no content response has a 5xx status code
func (o *ContainerUnpauseNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this container unpause no content response a status code equal to that given
func (o *ContainerUnpauseNoContent) IsCode(code int) bool {
	return code == 204
}

func (o *ContainerUnpauseNoContent) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/unpause][%d] containerUnpauseNoContent ", 204)
}

func (o *ContainerUnpauseNoContent) String() string {
	return fmt.Sprintf("[POST /containers/{name}/unpause][%d] containerUnpauseNoContent ", 204)
}

func (o *ContainerUnpauseNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerUnpauseNotFound creates a ContainerUnpauseNotFound with default headers values
func NewContainerUnpauseNotFound() *ContainerUnpauseNotFound {
	return &ContainerUnpauseNotFound{}
}

/*
ContainerUnpauseNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerUnpauseNotFound struct {
	Payload *ContainerUnpauseNotFoundBody
}

// IsSuccess returns true when this container unpause not found response has a 2xx status code
func (o *ContainerUnpauseNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container unpause not found response has a 3xx status code
func (o *ContainerUnpauseNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container unpause not found response has a 4xx status code
func (o *ContainerUnpauseNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container unpause not found response has a 5xx status code
func (o *ContainerUnpauseNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container unpause not found response a status code equal to that given
func (o *ContainerUnpauseNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerUnpauseNotFound) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/unpause][%d] containerUnpauseNotFound  %+v", 404, o.Payload)
}

func (o *ContainerUnpauseNotFound) String() string {
	return fmt.Sprintf("[POST /containers/{name}/unpause][%d] containerUnpauseNotFound  %+v", 404, o.Payload)
}

func (o *ContainerUnpauseNotFound) GetPayload() *ContainerUnpauseNotFoundBody {
	return o.Payload
}

func (o *ContainerUnpauseNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerUnpauseNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerUnpauseInternalServerError creates a ContainerUnpauseInternalServerError with default headers values
func NewContainerUnpauseInternalServerError() *ContainerUnpauseInternalServerError {
	return &ContainerUnpauseInternalServerError{}
}

/*
ContainerUnpauseInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerUnpauseInternalServerError struct {
	Payload *ContainerUnpauseInternalServerErrorBody
}

// IsSuccess returns true when this container unpause internal server error response has a 2xx status code
func (o *ContainerUnpauseInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container unpause internal server error response has a 3xx status code
func (o *ContainerUnpauseInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container unpause internal server error response has a 4xx status code
func (o *ContainerUnpauseInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container unpause internal server error response has a 5xx status code
func (o *ContainerUnpauseInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container unpause internal server error response a status code equal to that given
func (o *ContainerUnpauseInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerUnpauseInternalServerError) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/unpause][%d] containerUnpauseInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerUnpauseInternalServerError) String() string {
	return fmt.Sprintf("[POST /containers/{name}/unpause][%d] containerUnpauseInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerUnpauseInternalServerError) GetPayload() *ContainerUnpauseInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerUnpauseInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerUnpauseInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerUnpauseInternalServerErrorBody container unpause internal server error body
swagger:model ContainerUnpauseInternalServerErrorBody
*/
type ContainerUnpauseInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container unpause internal server error body
func (o *ContainerUnpauseInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container unpause internal server error body based on context it is used
func (o *ContainerUnpauseInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerUnpauseInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerUnpauseInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerUnpauseInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerUnpauseNotFoundBody container unpause not found body
swagger:model ContainerUnpauseNotFoundBody
*/
type ContainerUnpauseNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container unpause not found body
func (o *ContainerUnpauseNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container unpause not found body based on context it is used
func (o *ContainerUnpauseNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerUnpauseNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerUnpauseNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerUnpauseNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
