// Code generated by go-swagger; DO NOT EDIT.

package exec

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerExecLibpodReader is a Reader for the ContainerExecLibpod structure.
type ContainerExecLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerExecLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewContainerExecLibpodCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerExecLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewContainerExecLibpodConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerExecLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerExecLibpodCreated creates a ContainerExecLibpodCreated with default headers values
func NewContainerExecLibpodCreated() *ContainerExecLibpodCreated {
	return &ContainerExecLibpodCreated{}
}

/*
ContainerExecLibpodCreated describes a response with status code 201, with default header values.

no error
*/
type ContainerExecLibpodCreated struct {
}

// IsSuccess returns true when this container exec libpod created response has a 2xx status code
func (o *ContainerExecLibpodCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container exec libpod created response has a 3xx status code
func (o *ContainerExecLibpodCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container exec libpod created response has a 4xx status code
func (o *ContainerExecLibpodCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this container exec libpod created response has a 5xx status code
func (o *ContainerExecLibpodCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this container exec libpod created response a status code equal to that given
func (o *ContainerExecLibpodCreated) IsCode(code int) bool {
	return code == 201
}

func (o *ContainerExecLibpodCreated) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/exec][%d] containerExecLibpodCreated ", 201)
}

func (o *ContainerExecLibpodCreated) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/exec][%d] containerExecLibpodCreated ", 201)
}

func (o *ContainerExecLibpodCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerExecLibpodNotFound creates a ContainerExecLibpodNotFound with default headers values
func NewContainerExecLibpodNotFound() *ContainerExecLibpodNotFound {
	return &ContainerExecLibpodNotFound{}
}

/*
ContainerExecLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerExecLibpodNotFound struct {
	Payload *ContainerExecLibpodNotFoundBody
}

// IsSuccess returns true when this container exec libpod not found response has a 2xx status code
func (o *ContainerExecLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container exec libpod not found response has a 3xx status code
func (o *ContainerExecLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container exec libpod not found response has a 4xx status code
func (o *ContainerExecLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container exec libpod not found response has a 5xx status code
func (o *ContainerExecLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container exec libpod not found response a status code equal to that given
func (o *ContainerExecLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerExecLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/exec][%d] containerExecLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerExecLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/exec][%d] containerExecLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerExecLibpodNotFound) GetPayload() *ContainerExecLibpodNotFoundBody {
	return o.Payload
}

func (o *ContainerExecLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerExecLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerExecLibpodConflict creates a ContainerExecLibpodConflict with default headers values
func NewContainerExecLibpodConflict() *ContainerExecLibpodConflict {
	return &ContainerExecLibpodConflict{}
}

/*
ContainerExecLibpodConflict describes a response with status code 409, with default header values.

container is paused
*/
type ContainerExecLibpodConflict struct {
}

// IsSuccess returns true when this container exec libpod conflict response has a 2xx status code
func (o *ContainerExecLibpodConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container exec libpod conflict response has a 3xx status code
func (o *ContainerExecLibpodConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container exec libpod conflict response has a 4xx status code
func (o *ContainerExecLibpodConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this container exec libpod conflict response has a 5xx status code
func (o *ContainerExecLibpodConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this container exec libpod conflict response a status code equal to that given
func (o *ContainerExecLibpodConflict) IsCode(code int) bool {
	return code == 409
}

func (o *ContainerExecLibpodConflict) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/exec][%d] containerExecLibpodConflict ", 409)
}

func (o *ContainerExecLibpodConflict) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/exec][%d] containerExecLibpodConflict ", 409)
}

func (o *ContainerExecLibpodConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerExecLibpodInternalServerError creates a ContainerExecLibpodInternalServerError with default headers values
func NewContainerExecLibpodInternalServerError() *ContainerExecLibpodInternalServerError {
	return &ContainerExecLibpodInternalServerError{}
}

/*
ContainerExecLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerExecLibpodInternalServerError struct {
	Payload *ContainerExecLibpodInternalServerErrorBody
}

// IsSuccess returns true when this container exec libpod internal server error response has a 2xx status code
func (o *ContainerExecLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container exec libpod internal server error response has a 3xx status code
func (o *ContainerExecLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container exec libpod internal server error response has a 4xx status code
func (o *ContainerExecLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container exec libpod internal server error response has a 5xx status code
func (o *ContainerExecLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container exec libpod internal server error response a status code equal to that given
func (o *ContainerExecLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerExecLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/exec][%d] containerExecLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerExecLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/exec][%d] containerExecLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerExecLibpodInternalServerError) GetPayload() *ContainerExecLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerExecLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerExecLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerExecLibpodBody container exec libpod body
swagger:model ContainerExecLibpodBody
*/
type ContainerExecLibpodBody struct {

	// Attach to stderr of the exec command
	AttachStderr bool `json:"AttachStderr,omitempty"`

	// Attach to stdin of the exec command
	AttachStdin bool `json:"AttachStdin,omitempty"`

	// Attach to stdout of the exec command
	AttachStdout bool `json:"AttachStdout,omitempty"`

	// Command to run, as a string or array of strings.
	Cmd []string `json:"Cmd"`

	// "Override the key sequence for detaching a container. Format is a single character [a-Z] or ctrl-<value> where <value> is one of: a-z, @, ^, [, , or _."
	//
	DetachKeys string `json:"DetachKeys,omitempty"`

	// A list of environment variables in the form ["VAR=value", ...]
	Env []string `json:"Env"`

	// Runs the exec process with extended privileges
	Privileged *bool `json:"Privileged,omitempty"`

	// Allocate a pseudo-TTY
	Tty bool `json:"Tty,omitempty"`

	// "The user, and optionally, group to run the exec process inside the container. Format is one of: user, user:group, uid, or uid:gid."
	//
	User string `json:"User,omitempty"`

	// The working directory for the exec process inside the container.
	WorkingDir string `json:"WorkingDir,omitempty"`
}

// Validate validates this container exec libpod body
func (o *ContainerExecLibpodBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container exec libpod body based on context it is used
func (o *ContainerExecLibpodBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerExecLibpodBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerExecLibpodBody) UnmarshalBinary(b []byte) error {
	var res ContainerExecLibpodBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerExecLibpodInternalServerErrorBody container exec libpod internal server error body
swagger:model ContainerExecLibpodInternalServerErrorBody
*/
type ContainerExecLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container exec libpod internal server error body
func (o *ContainerExecLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container exec libpod internal server error body based on context it is used
func (o *ContainerExecLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerExecLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerExecLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerExecLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerExecLibpodNotFoundBody container exec libpod not found body
swagger:model ContainerExecLibpodNotFoundBody
*/
type ContainerExecLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container exec libpod not found body
func (o *ContainerExecLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container exec libpod not found body based on context it is used
func (o *ContainerExecLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerExecLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerExecLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerExecLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
