// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// ImageDeleteAllLibpodReader is a Reader for the ImageDeleteAllLibpod structure.
type ImageDeleteAllLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ImageDeleteAllLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewImageDeleteAllLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewImageDeleteAllLibpodBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewImageDeleteAllLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageDeleteAllLibpodOK creates a ImageDeleteAllLibpodOK with default headers values
func NewImageDeleteAllLibpodOK() *ImageDeleteAllLibpodOK {
	return &ImageDeleteAllLibpodOK{}
}

/*
ImageDeleteAllLibpodOK describes a response with status code 200, with default header values.

Remove response
*/
type ImageDeleteAllLibpodOK struct {
	Payload *models.LibpodImagesRemoveReport
}

// IsSuccess returns true when this image delete all libpod o k response has a 2xx status code
func (o *ImageDeleteAllLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image delete all libpod o k response has a 3xx status code
func (o *ImageDeleteAllLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image delete all libpod o k response has a 4xx status code
func (o *ImageDeleteAllLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this image delete all libpod o k response has a 5xx status code
func (o *ImageDeleteAllLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this image delete all libpod o k response a status code equal to that given
func (o *ImageDeleteAllLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ImageDeleteAllLibpodOK) Error() string {
	return fmt.Sprintf("[DELETE /libpod/images/remove][%d] imageDeleteAllLibpodOK  %+v", 200, o.Payload)
}

func (o *ImageDeleteAllLibpodOK) String() string {
	return fmt.Sprintf("[DELETE /libpod/images/remove][%d] imageDeleteAllLibpodOK  %+v", 200, o.Payload)
}

func (o *ImageDeleteAllLibpodOK) GetPayload() *models.LibpodImagesRemoveReport {
	return o.Payload
}

func (o *ImageDeleteAllLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LibpodImagesRemoveReport)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageDeleteAllLibpodBadRequest creates a ImageDeleteAllLibpodBadRequest with default headers values
func NewImageDeleteAllLibpodBadRequest() *ImageDeleteAllLibpodBadRequest {
	return &ImageDeleteAllLibpodBadRequest{}
}

/*
ImageDeleteAllLibpodBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type ImageDeleteAllLibpodBadRequest struct {
	Payload *ImageDeleteAllLibpodBadRequestBody
}

// IsSuccess returns true when this image delete all libpod bad request response has a 2xx status code
func (o *ImageDeleteAllLibpodBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image delete all libpod bad request response has a 3xx status code
func (o *ImageDeleteAllLibpodBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image delete all libpod bad request response has a 4xx status code
func (o *ImageDeleteAllLibpodBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this image delete all libpod bad request response has a 5xx status code
func (o *ImageDeleteAllLibpodBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this image delete all libpod bad request response a status code equal to that given
func (o *ImageDeleteAllLibpodBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *ImageDeleteAllLibpodBadRequest) Error() string {
	return fmt.Sprintf("[DELETE /libpod/images/remove][%d] imageDeleteAllLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *ImageDeleteAllLibpodBadRequest) String() string {
	return fmt.Sprintf("[DELETE /libpod/images/remove][%d] imageDeleteAllLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *ImageDeleteAllLibpodBadRequest) GetPayload() *ImageDeleteAllLibpodBadRequestBody {
	return o.Payload
}

func (o *ImageDeleteAllLibpodBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageDeleteAllLibpodBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageDeleteAllLibpodInternalServerError creates a ImageDeleteAllLibpodInternalServerError with default headers values
func NewImageDeleteAllLibpodInternalServerError() *ImageDeleteAllLibpodInternalServerError {
	return &ImageDeleteAllLibpodInternalServerError{}
}

/*
ImageDeleteAllLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageDeleteAllLibpodInternalServerError struct {
	Payload *ImageDeleteAllLibpodInternalServerErrorBody
}

// IsSuccess returns true when this image delete all libpod internal server error response has a 2xx status code
func (o *ImageDeleteAllLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image delete all libpod internal server error response has a 3xx status code
func (o *ImageDeleteAllLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image delete all libpod internal server error response has a 4xx status code
func (o *ImageDeleteAllLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image delete all libpod internal server error response has a 5xx status code
func (o *ImageDeleteAllLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image delete all libpod internal server error response a status code equal to that given
func (o *ImageDeleteAllLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageDeleteAllLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /libpod/images/remove][%d] imageDeleteAllLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageDeleteAllLibpodInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /libpod/images/remove][%d] imageDeleteAllLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageDeleteAllLibpodInternalServerError) GetPayload() *ImageDeleteAllLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ImageDeleteAllLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageDeleteAllLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageDeleteAllLibpodBadRequestBody image delete all libpod bad request body
swagger:model ImageDeleteAllLibpodBadRequestBody
*/
type ImageDeleteAllLibpodBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image delete all libpod bad request body
func (o *ImageDeleteAllLibpodBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image delete all libpod bad request body based on context it is used
func (o *ImageDeleteAllLibpodBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageDeleteAllLibpodBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageDeleteAllLibpodBadRequestBody) UnmarshalBinary(b []byte) error {
	var res ImageDeleteAllLibpodBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageDeleteAllLibpodInternalServerErrorBody image delete all libpod internal server error body
swagger:model ImageDeleteAllLibpodInternalServerErrorBody
*/
type ImageDeleteAllLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image delete all libpod internal server error body
func (o *ImageDeleteAllLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image delete all libpod internal server error body based on context it is used
func (o *ImageDeleteAllLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageDeleteAllLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageDeleteAllLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageDeleteAllLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
