// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ImageExportLibpodReader is a Reader for the ImageExportLibpod structure.
type ImageExportLibpodReader struct {
	formats strfmt.Registry
	writer  io.Writer
}

// ReadResponse reads a server response into the received o.
func (o *ImageExportLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewImageExportLibpodOK(o.writer)
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewImageExportLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewImageExportLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageExportLibpodOK creates a ImageExportLibpodOK with default headers values
func NewImageExportLibpodOK(writer io.Writer) *ImageExportLibpodOK {
	return &ImageExportLibpodOK{

		Payload: writer,
	}
}

/*
ImageExportLibpodOK describes a response with status code 200, with default header values.

no error
*/
type ImageExportLibpodOK struct {
	Payload io.Writer
}

// IsSuccess returns true when this image export libpod o k response has a 2xx status code
func (o *ImageExportLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image export libpod o k response has a 3xx status code
func (o *ImageExportLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image export libpod o k response has a 4xx status code
func (o *ImageExportLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this image export libpod o k response has a 5xx status code
func (o *ImageExportLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this image export libpod o k response a status code equal to that given
func (o *ImageExportLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ImageExportLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/images/export][%d] imageExportLibpodOK  %+v", 200, o.Payload)
}

func (o *ImageExportLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/images/export][%d] imageExportLibpodOK  %+v", 200, o.Payload)
}

func (o *ImageExportLibpodOK) GetPayload() io.Writer {
	return o.Payload
}

func (o *ImageExportLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageExportLibpodNotFound creates a ImageExportLibpodNotFound with default headers values
func NewImageExportLibpodNotFound() *ImageExportLibpodNotFound {
	return &ImageExportLibpodNotFound{}
}

/*
ImageExportLibpodNotFound describes a response with status code 404, with default header values.

No such image
*/
type ImageExportLibpodNotFound struct {
	Payload *ImageExportLibpodNotFoundBody
}

// IsSuccess returns true when this image export libpod not found response has a 2xx status code
func (o *ImageExportLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image export libpod not found response has a 3xx status code
func (o *ImageExportLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image export libpod not found response has a 4xx status code
func (o *ImageExportLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this image export libpod not found response has a 5xx status code
func (o *ImageExportLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this image export libpod not found response a status code equal to that given
func (o *ImageExportLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ImageExportLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/images/export][%d] imageExportLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ImageExportLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/images/export][%d] imageExportLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ImageExportLibpodNotFound) GetPayload() *ImageExportLibpodNotFoundBody {
	return o.Payload
}

func (o *ImageExportLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageExportLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageExportLibpodInternalServerError creates a ImageExportLibpodInternalServerError with default headers values
func NewImageExportLibpodInternalServerError() *ImageExportLibpodInternalServerError {
	return &ImageExportLibpodInternalServerError{}
}

/*
ImageExportLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageExportLibpodInternalServerError struct {
	Payload *ImageExportLibpodInternalServerErrorBody
}

// IsSuccess returns true when this image export libpod internal server error response has a 2xx status code
func (o *ImageExportLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image export libpod internal server error response has a 3xx status code
func (o *ImageExportLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image export libpod internal server error response has a 4xx status code
func (o *ImageExportLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image export libpod internal server error response has a 5xx status code
func (o *ImageExportLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image export libpod internal server error response a status code equal to that given
func (o *ImageExportLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageExportLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/images/export][%d] imageExportLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageExportLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/images/export][%d] imageExportLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageExportLibpodInternalServerError) GetPayload() *ImageExportLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ImageExportLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageExportLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageExportLibpodInternalServerErrorBody image export libpod internal server error body
swagger:model ImageExportLibpodInternalServerErrorBody
*/
type ImageExportLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image export libpod internal server error body
func (o *ImageExportLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image export libpod internal server error body based on context it is used
func (o *ImageExportLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageExportLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageExportLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageExportLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageExportLibpodNotFoundBody image export libpod not found body
swagger:model ImageExportLibpodNotFoundBody
*/
type ImageExportLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image export libpod not found body
func (o *ImageExportLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image export libpod not found body based on context it is used
func (o *ImageExportLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageExportLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageExportLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ImageExportLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
