// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// ImageInspectLibpodReader is a Reader for the ImageInspectLibpod structure.
type ImageInspectLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ImageInspectLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewImageInspectLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewImageInspectLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewImageInspectLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageInspectLibpodOK creates a ImageInspectLibpodOK with default headers values
func NewImageInspectLibpodOK() *ImageInspectLibpodOK {
	return &ImageInspectLibpodOK{}
}

/*
ImageInspectLibpodOK describes a response with status code 200, with default header values.

Inspect image
*/
type ImageInspectLibpodOK struct {
	Payload *ImageInspectLibpodOKBody
}

// IsSuccess returns true when this image inspect libpod o k response has a 2xx status code
func (o *ImageInspectLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image inspect libpod o k response has a 3xx status code
func (o *ImageInspectLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image inspect libpod o k response has a 4xx status code
func (o *ImageInspectLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this image inspect libpod o k response has a 5xx status code
func (o *ImageInspectLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this image inspect libpod o k response a status code equal to that given
func (o *ImageInspectLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ImageInspectLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/json][%d] imageInspectLibpodOK  %+v", 200, o.Payload)
}

func (o *ImageInspectLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/json][%d] imageInspectLibpodOK  %+v", 200, o.Payload)
}

func (o *ImageInspectLibpodOK) GetPayload() *ImageInspectLibpodOKBody {
	return o.Payload
}

func (o *ImageInspectLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageInspectLibpodOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageInspectLibpodNotFound creates a ImageInspectLibpodNotFound with default headers values
func NewImageInspectLibpodNotFound() *ImageInspectLibpodNotFound {
	return &ImageInspectLibpodNotFound{}
}

/*
ImageInspectLibpodNotFound describes a response with status code 404, with default header values.

No such image
*/
type ImageInspectLibpodNotFound struct {
	Payload *ImageInspectLibpodNotFoundBody
}

// IsSuccess returns true when this image inspect libpod not found response has a 2xx status code
func (o *ImageInspectLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image inspect libpod not found response has a 3xx status code
func (o *ImageInspectLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image inspect libpod not found response has a 4xx status code
func (o *ImageInspectLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this image inspect libpod not found response has a 5xx status code
func (o *ImageInspectLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this image inspect libpod not found response a status code equal to that given
func (o *ImageInspectLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ImageInspectLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/json][%d] imageInspectLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ImageInspectLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/json][%d] imageInspectLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ImageInspectLibpodNotFound) GetPayload() *ImageInspectLibpodNotFoundBody {
	return o.Payload
}

func (o *ImageInspectLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageInspectLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageInspectLibpodInternalServerError creates a ImageInspectLibpodInternalServerError with default headers values
func NewImageInspectLibpodInternalServerError() *ImageInspectLibpodInternalServerError {
	return &ImageInspectLibpodInternalServerError{}
}

/*
ImageInspectLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageInspectLibpodInternalServerError struct {
	Payload *ImageInspectLibpodInternalServerErrorBody
}

// IsSuccess returns true when this image inspect libpod internal server error response has a 2xx status code
func (o *ImageInspectLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image inspect libpod internal server error response has a 3xx status code
func (o *ImageInspectLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image inspect libpod internal server error response has a 4xx status code
func (o *ImageInspectLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image inspect libpod internal server error response has a 5xx status code
func (o *ImageInspectLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image inspect libpod internal server error response a status code equal to that given
func (o *ImageInspectLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageInspectLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/json][%d] imageInspectLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageInspectLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/json][%d] imageInspectLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageInspectLibpodInternalServerError) GetPayload() *ImageInspectLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ImageInspectLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageInspectLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageInspectLibpodInternalServerErrorBody image inspect libpod internal server error body
swagger:model ImageInspectLibpodInternalServerErrorBody
*/
type ImageInspectLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image inspect libpod internal server error body
func (o *ImageInspectLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image inspect libpod internal server error body based on context it is used
func (o *ImageInspectLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageInspectLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageInspectLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageInspectLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageInspectLibpodNotFoundBody image inspect libpod not found body
swagger:model ImageInspectLibpodNotFoundBody
*/
type ImageInspectLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image inspect libpod not found body
func (o *ImageInspectLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image inspect libpod not found body based on context it is used
func (o *ImageInspectLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageInspectLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageInspectLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ImageInspectLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageInspectLibpodOKBody image inspect libpod o k body
swagger:model ImageInspectLibpodOKBody
*/
type ImageInspectLibpodOKBody struct {

	// annotations
	Annotations map[string]string `json:"Annotations,omitempty"`

	// architecture
	Architecture string `json:"Architecture,omitempty"`

	// author
	Author string `json:"Author,omitempty"`

	// comment
	Comment string `json:"Comment,omitempty"`

	// config
	Config *models.ImageConfig `json:"Config,omitempty"`

	// created
	// Format: date-time
	Created strfmt.DateTime `json:"Created,omitempty"`

	// digest
	Digest models.Digest `json:"Digest,omitempty"`

	// graph driver
	GraphDriver *models.DriverData `json:"GraphDriver,omitempty"`

	// healthcheck
	Healthcheck *models.Schema2HealthConfig `json:"Healthcheck,omitempty"`

	// history
	History []*models.History `json:"History"`

	// ID
	ID string `json:"Id,omitempty"`

	// labels
	Labels map[string]string `json:"Labels,omitempty"`

	// manifest type
	ManifestType string `json:"ManifestType,omitempty"`

	// names history
	NamesHistory []string `json:"NamesHistory"`

	// os
	Os string `json:"Os,omitempty"`

	// parent
	Parent string `json:"Parent,omitempty"`

	// repo digests
	RepoDigests []string `json:"RepoDigests"`

	// repo tags
	RepoTags []string `json:"RepoTags"`

	// root f s
	RootFS *models.RootFS `json:"RootFS,omitempty"`

	// size
	Size int64 `json:"Size,omitempty"`

	// user
	User string `json:"User,omitempty"`

	// version
	Version string `json:"Version,omitempty"`

	// virtual size
	VirtualSize int64 `json:"VirtualSize,omitempty"`
}

// Validate validates this image inspect libpod o k body
func (o *ImageInspectLibpodOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreated(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDigest(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGraphDriver(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHealthcheck(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHistory(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRootFS(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ImageInspectLibpodOKBody) validateConfig(formats strfmt.Registry) error {
	if swag.IsZero(o.Config) { // not required
		return nil
	}

	if o.Config != nil {
		if err := o.Config.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("imageInspectLibpodOK" + "." + "Config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("imageInspectLibpodOK" + "." + "Config")
			}
			return err
		}
	}

	return nil
}

func (o *ImageInspectLibpodOKBody) validateCreated(formats strfmt.Registry) error {
	if swag.IsZero(o.Created) { // not required
		return nil
	}

	if err := validate.FormatOf("imageInspectLibpodOK"+"."+"Created", "body", "date-time", o.Created.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *ImageInspectLibpodOKBody) validateDigest(formats strfmt.Registry) error {
	if swag.IsZero(o.Digest) { // not required
		return nil
	}

	if err := o.Digest.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("imageInspectLibpodOK" + "." + "Digest")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("imageInspectLibpodOK" + "." + "Digest")
		}
		return err
	}

	return nil
}

func (o *ImageInspectLibpodOKBody) validateGraphDriver(formats strfmt.Registry) error {
	if swag.IsZero(o.GraphDriver) { // not required
		return nil
	}

	if o.GraphDriver != nil {
		if err := o.GraphDriver.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("imageInspectLibpodOK" + "." + "GraphDriver")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("imageInspectLibpodOK" + "." + "GraphDriver")
			}
			return err
		}
	}

	return nil
}

func (o *ImageInspectLibpodOKBody) validateHealthcheck(formats strfmt.Registry) error {
	if swag.IsZero(o.Healthcheck) { // not required
		return nil
	}

	if o.Healthcheck != nil {
		if err := o.Healthcheck.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("imageInspectLibpodOK" + "." + "Healthcheck")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("imageInspectLibpodOK" + "." + "Healthcheck")
			}
			return err
		}
	}

	return nil
}

func (o *ImageInspectLibpodOKBody) validateHistory(formats strfmt.Registry) error {
	if swag.IsZero(o.History) { // not required
		return nil
	}

	for i := 0; i < len(o.History); i++ {
		if swag.IsZero(o.History[i]) { // not required
			continue
		}

		if o.History[i] != nil {
			if err := o.History[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("imageInspectLibpodOK" + "." + "History" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("imageInspectLibpodOK" + "." + "History" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ImageInspectLibpodOKBody) validateRootFS(formats strfmt.Registry) error {
	if swag.IsZero(o.RootFS) { // not required
		return nil
	}

	if o.RootFS != nil {
		if err := o.RootFS.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("imageInspectLibpodOK" + "." + "RootFS")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("imageInspectLibpodOK" + "." + "RootFS")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this image inspect libpod o k body based on the context it is used
func (o *ImageInspectLibpodOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDigest(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGraphDriver(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHealthcheck(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHistory(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRootFS(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ImageInspectLibpodOKBody) contextValidateConfig(ctx context.Context, formats strfmt.Registry) error {

	if o.Config != nil {
		if err := o.Config.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("imageInspectLibpodOK" + "." + "Config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("imageInspectLibpodOK" + "." + "Config")
			}
			return err
		}
	}

	return nil
}

func (o *ImageInspectLibpodOKBody) contextValidateDigest(ctx context.Context, formats strfmt.Registry) error {

	if err := o.Digest.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("imageInspectLibpodOK" + "." + "Digest")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("imageInspectLibpodOK" + "." + "Digest")
		}
		return err
	}

	return nil
}

func (o *ImageInspectLibpodOKBody) contextValidateGraphDriver(ctx context.Context, formats strfmt.Registry) error {

	if o.GraphDriver != nil {
		if err := o.GraphDriver.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("imageInspectLibpodOK" + "." + "GraphDriver")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("imageInspectLibpodOK" + "." + "GraphDriver")
			}
			return err
		}
	}

	return nil
}

func (o *ImageInspectLibpodOKBody) contextValidateHealthcheck(ctx context.Context, formats strfmt.Registry) error {

	if o.Healthcheck != nil {
		if err := o.Healthcheck.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("imageInspectLibpodOK" + "." + "Healthcheck")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("imageInspectLibpodOK" + "." + "Healthcheck")
			}
			return err
		}
	}

	return nil
}

func (o *ImageInspectLibpodOKBody) contextValidateHistory(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.History); i++ {

		if o.History[i] != nil {
			if err := o.History[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("imageInspectLibpodOK" + "." + "History" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("imageInspectLibpodOK" + "." + "History" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ImageInspectLibpodOKBody) contextValidateRootFS(ctx context.Context, formats strfmt.Registry) error {

	if o.RootFS != nil {
		if err := o.RootFS.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("imageInspectLibpodOK" + "." + "RootFS")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("imageInspectLibpodOK" + "." + "RootFS")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ImageInspectLibpodOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageInspectLibpodOKBody) UnmarshalBinary(b []byte) error {
	var res ImageInspectLibpodOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
