// Code generated by go-swagger; DO NOT EDIT.

package images_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewImageListParams creates a new ImageListParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewImageListParams() *ImageListParams {
	return &ImageListParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewImageListParamsWithTimeout creates a new ImageListParams object
// with the ability to set a timeout on a request.
func NewImageListParamsWithTimeout(timeout time.Duration) *ImageListParams {
	return &ImageListParams{
		timeout: timeout,
	}
}

// NewImageListParamsWithContext creates a new ImageListParams object
// with the ability to set a context for a request.
func NewImageListParamsWithContext(ctx context.Context) *ImageListParams {
	return &ImageListParams{
		Context: ctx,
	}
}

// NewImageListParamsWithHTTPClient creates a new ImageListParams object
// with the ability to set a custom HTTPClient for a request.
func NewImageListParamsWithHTTPClient(client *http.Client) *ImageListParams {
	return &ImageListParams{
		HTTPClient: client,
	}
}

/*
ImageListParams contains all the parameters to send to the API endpoint

	for the image list operation.

	Typically these are written to a http.Request.
*/
type ImageListParams struct {

	/* All.

	   Show all images. Only images from a final layer (no children) are shown by default.
	*/
	All *bool

	/* Digests.

	   Not supported
	*/
	Digests *bool

	/* Filters.

	     A JSON encoded value of the filters (a `map[string][]string`) to process on the images list. Available filters:
	- `before`=(`<image-name>[:<tag>]`,  `<image id>` or `<image@digest>`)
	- `dangling=true`
	- `label=key` or `label="key=value"` of an image label
	- `reference`=(`<image-name>[:<tag>]`)
	- `since`=(`<image-name>[:<tag>]`,  `<image id>` or `<image@digest>`)

	*/
	Filters *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the image list params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageListParams) WithDefaults() *ImageListParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the image list params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageListParams) SetDefaults() {
	var (
		allDefault = bool(false)

		digestsDefault = bool(false)
	)

	val := ImageListParams{
		All:     &allDefault,
		Digests: &digestsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the image list params
func (o *ImageListParams) WithTimeout(timeout time.Duration) *ImageListParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the image list params
func (o *ImageListParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the image list params
func (o *ImageListParams) WithContext(ctx context.Context) *ImageListParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the image list params
func (o *ImageListParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the image list params
func (o *ImageListParams) WithHTTPClient(client *http.Client) *ImageListParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the image list params
func (o *ImageListParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAll adds the all to the image list params
func (o *ImageListParams) WithAll(all *bool) *ImageListParams {
	o.SetAll(all)
	return o
}

// SetAll adds the all to the image list params
func (o *ImageListParams) SetAll(all *bool) {
	o.All = all
}

// WithDigests adds the digests to the image list params
func (o *ImageListParams) WithDigests(digests *bool) *ImageListParams {
	o.SetDigests(digests)
	return o
}

// SetDigests adds the digests to the image list params
func (o *ImageListParams) SetDigests(digests *bool) {
	o.Digests = digests
}

// WithFilters adds the filters to the image list params
func (o *ImageListParams) WithFilters(filters *string) *ImageListParams {
	o.SetFilters(filters)
	return o
}

// SetFilters adds the filters to the image list params
func (o *ImageListParams) SetFilters(filters *string) {
	o.Filters = filters
}

// WriteToRequest writes these params to a swagger request
func (o *ImageListParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.All != nil {

		// query param all
		var qrAll bool

		if o.All != nil {
			qrAll = *o.All
		}
		qAll := swag.FormatBool(qrAll)
		if qAll != "" {

			if err := r.SetQueryParam("all", qAll); err != nil {
				return err
			}
		}
	}

	if o.Digests != nil {

		// query param digests
		var qrDigests bool

		if o.Digests != nil {
			qrDigests = *o.Digests
		}
		qDigests := swag.FormatBool(qrDigests)
		if qDigests != "" {

			if err := r.SetQueryParam("digests", qDigests); err != nil {
				return err
			}
		}
	}

	if o.Filters != nil {

		// query param filters
		var qrFilters string

		if o.Filters != nil {
			qrFilters = *o.Filters
		}
		qFilters := qrFilters
		if qFilters != "" {

			if err := r.SetQueryParam("filters", qFilters); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
