// Code generated by go-swagger; DO NOT EDIT.

package images_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ImageLoadReader is a Reader for the ImageLoad structure.
type ImageLoadReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ImageLoadReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewImageLoadOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewImageLoadInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageLoadOK creates a ImageLoadOK with default headers values
func NewImageLoadOK() *ImageLoadOK {
	return &ImageLoadOK{}
}

/*
ImageLoadOK describes a response with status code 200, with default header values.

no error
*/
type ImageLoadOK struct {
}

// IsSuccess returns true when this image load o k response has a 2xx status code
func (o *ImageLoadOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image load o k response has a 3xx status code
func (o *ImageLoadOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image load o k response has a 4xx status code
func (o *ImageLoadOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this image load o k response has a 5xx status code
func (o *ImageLoadOK) IsServerError() bool {
	return false
}

// IsCode returns true when this image load o k response a status code equal to that given
func (o *ImageLoadOK) IsCode(code int) bool {
	return code == 200
}

func (o *ImageLoadOK) Error() string {
	return fmt.Sprintf("[POST /images/load][%d] imageLoadOK ", 200)
}

func (o *ImageLoadOK) String() string {
	return fmt.Sprintf("[POST /images/load][%d] imageLoadOK ", 200)
}

func (o *ImageLoadOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewImageLoadInternalServerError creates a ImageLoadInternalServerError with default headers values
func NewImageLoadInternalServerError() *ImageLoadInternalServerError {
	return &ImageLoadInternalServerError{}
}

/*
ImageLoadInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageLoadInternalServerError struct {
	Payload *ImageLoadInternalServerErrorBody
}

// IsSuccess returns true when this image load internal server error response has a 2xx status code
func (o *ImageLoadInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image load internal server error response has a 3xx status code
func (o *ImageLoadInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image load internal server error response has a 4xx status code
func (o *ImageLoadInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image load internal server error response has a 5xx status code
func (o *ImageLoadInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image load internal server error response a status code equal to that given
func (o *ImageLoadInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageLoadInternalServerError) Error() string {
	return fmt.Sprintf("[POST /images/load][%d] imageLoadInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageLoadInternalServerError) String() string {
	return fmt.Sprintf("[POST /images/load][%d] imageLoadInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageLoadInternalServerError) GetPayload() *ImageLoadInternalServerErrorBody {
	return o.Payload
}

func (o *ImageLoadInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageLoadInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageLoadInternalServerErrorBody image load internal server error body
swagger:model ImageLoadInternalServerErrorBody
*/
type ImageLoadInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image load internal server error body
func (o *ImageLoadInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image load internal server error body based on context it is used
func (o *ImageLoadInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageLoadInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageLoadInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageLoadInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
