// Code generated by go-swagger; DO NOT EDIT.

package manifests

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewManifestPushLibpodParams creates a new ManifestPushLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewManifestPushLibpodParams() *ManifestPushLibpodParams {
	return &ManifestPushLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewManifestPushLibpodParamsWithTimeout creates a new ManifestPushLibpodParams object
// with the ability to set a timeout on a request.
func NewManifestPushLibpodParamsWithTimeout(timeout time.Duration) *ManifestPushLibpodParams {
	return &ManifestPushLibpodParams{
		timeout: timeout,
	}
}

// NewManifestPushLibpodParamsWithContext creates a new ManifestPushLibpodParams object
// with the ability to set a context for a request.
func NewManifestPushLibpodParamsWithContext(ctx context.Context) *ManifestPushLibpodParams {
	return &ManifestPushLibpodParams{
		Context: ctx,
	}
}

// NewManifestPushLibpodParamsWithHTTPClient creates a new ManifestPushLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewManifestPushLibpodParamsWithHTTPClient(client *http.Client) *ManifestPushLibpodParams {
	return &ManifestPushLibpodParams{
		HTTPClient: client,
	}
}

/*
ManifestPushLibpodParams contains all the parameters to send to the API endpoint

	for the manifest push libpod operation.

	Typically these are written to a http.Request.
*/
type ManifestPushLibpodParams struct {

	/* All.

	   push all images
	*/
	All *bool

	/* Destination.

	   the registry for the manifest list
	*/
	Destination string

	/* Name.

	   the name or ID of the manifest list
	*/
	Name string

	/* TLSVerify.

	   skip TLS verification for registries
	*/
	TLSVerify *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the manifest push libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ManifestPushLibpodParams) WithDefaults() *ManifestPushLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the manifest push libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ManifestPushLibpodParams) SetDefaults() {
	var (
		allDefault = bool(false)

		tLSVerifyDefault = bool(false)
	)

	val := ManifestPushLibpodParams{
		All:       &allDefault,
		TLSVerify: &tLSVerifyDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the manifest push libpod params
func (o *ManifestPushLibpodParams) WithTimeout(timeout time.Duration) *ManifestPushLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the manifest push libpod params
func (o *ManifestPushLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the manifest push libpod params
func (o *ManifestPushLibpodParams) WithContext(ctx context.Context) *ManifestPushLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the manifest push libpod params
func (o *ManifestPushLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the manifest push libpod params
func (o *ManifestPushLibpodParams) WithHTTPClient(client *http.Client) *ManifestPushLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the manifest push libpod params
func (o *ManifestPushLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAll adds the all to the manifest push libpod params
func (o *ManifestPushLibpodParams) WithAll(all *bool) *ManifestPushLibpodParams {
	o.SetAll(all)
	return o
}

// SetAll adds the all to the manifest push libpod params
func (o *ManifestPushLibpodParams) SetAll(all *bool) {
	o.All = all
}

// WithDestination adds the destination to the manifest push libpod params
func (o *ManifestPushLibpodParams) WithDestination(destination string) *ManifestPushLibpodParams {
	o.SetDestination(destination)
	return o
}

// SetDestination adds the destination to the manifest push libpod params
func (o *ManifestPushLibpodParams) SetDestination(destination string) {
	o.Destination = destination
}

// WithName adds the name to the manifest push libpod params
func (o *ManifestPushLibpodParams) WithName(name string) *ManifestPushLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the manifest push libpod params
func (o *ManifestPushLibpodParams) SetName(name string) {
	o.Name = name
}

// WithTLSVerify adds the tLSVerify to the manifest push libpod params
func (o *ManifestPushLibpodParams) WithTLSVerify(tLSVerify *bool) *ManifestPushLibpodParams {
	o.SetTLSVerify(tLSVerify)
	return o
}

// SetTLSVerify adds the tlsVerify to the manifest push libpod params
func (o *ManifestPushLibpodParams) SetTLSVerify(tLSVerify *bool) {
	o.TLSVerify = tLSVerify
}

// WriteToRequest writes these params to a swagger request
func (o *ManifestPushLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.All != nil {

		// query param all
		var qrAll bool

		if o.All != nil {
			qrAll = *o.All
		}
		qAll := swag.FormatBool(qrAll)
		if qAll != "" {

			if err := r.SetQueryParam("all", qAll); err != nil {
				return err
			}
		}
	}

	// path param destination
	if err := r.SetPathParam("destination", o.Destination); err != nil {
		return err
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.TLSVerify != nil {

		// query param tlsVerify
		var qrTLSVerify bool

		if o.TLSVerify != nil {
			qrTLSVerify = *o.TLSVerify
		}
		qTLSVerify := swag.FormatBool(qrTLSVerify)
		if qTLSVerify != "" {

			if err := r.SetQueryParam("tlsVerify", qTLSVerify); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
