// Code generated by go-swagger; DO NOT EDIT.

package manifests

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new manifests API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for manifests API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ManifestAddLibpod(params *ManifestAddLibpodParams, opts ...ClientOption) (*ManifestAddLibpodOK, error)

	ManifestCreateLibpod(params *ManifestCreateLibpodParams, opts ...ClientOption) (*ManifestCreateLibpodCreated, error)

	ManifestDeleteLibpod(params *ManifestDeleteLibpodParams, opts ...ClientOption) (*ManifestDeleteLibpodOK, error)

	ManifestExistsLibpod(params *ManifestExistsLibpodParams, opts ...ClientOption) (*ManifestExistsLibpodNoContent, error)

	ManifestInspectLibpod(params *ManifestInspectLibpodParams, opts ...ClientOption) (*ManifestInspectLibpodOK, error)

	ManifestModifyLibpod(params *ManifestModifyLibpodParams, opts ...ClientOption) (*ManifestModifyLibpodOK, error)

	ManifestPushLibpod(params *ManifestPushLibpodParams, opts ...ClientOption) (*ManifestPushLibpodOK, error)

	ManifestPushV3Libpod(params *ManifestPushV3LibpodParams, opts ...ClientOption) (*ManifestPushV3LibpodOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	ManifestAddLibpod adds image

	Add an image to a manifest list

Deprecated: As of 4.0.0 use ManifestModifyLibpod instead
*/
func (a *Client) ManifestAddLibpod(params *ManifestAddLibpodParams, opts ...ClientOption) (*ManifestAddLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewManifestAddLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ManifestAddLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/manifests/{name}/add",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ManifestAddLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ManifestAddLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ManifestAddLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ManifestCreateLibpod creates

Create a manifest list
*/
func (a *Client) ManifestCreateLibpod(params *ManifestCreateLibpodParams, opts ...ClientOption) (*ManifestCreateLibpodCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewManifestCreateLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ManifestCreateLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/manifests",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ManifestCreateLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ManifestCreateLibpodCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ManifestCreateLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
	ManifestDeleteLibpod deletes manifest list

	Delete named manifest list

As of v4.0.0
*/
func (a *Client) ManifestDeleteLibpod(params *ManifestDeleteLibpodParams, opts ...ClientOption) (*ManifestDeleteLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewManifestDeleteLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ManifestDeleteLibpod",
		Method:             "DELETE",
		PathPattern:        "/libpod/manifests/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ManifestDeleteLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ManifestDeleteLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ManifestDeleteLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
	ManifestExistsLibpod exists

	Check if manifest list exists

Note: There is no contract that the manifest list will exist for a follow-on operation
*/
func (a *Client) ManifestExistsLibpod(params *ManifestExistsLibpodParams, opts ...ClientOption) (*ManifestExistsLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewManifestExistsLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ManifestExistsLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/manifests/{name}/exists",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ManifestExistsLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ManifestExistsLibpodNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ManifestExistsLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ManifestInspectLibpod inspects

Display attributes of given manifest list
*/
func (a *Client) ManifestInspectLibpod(params *ManifestInspectLibpodParams, opts ...ClientOption) (*ManifestInspectLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewManifestInspectLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ManifestInspectLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/manifests/{name}/json",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ManifestInspectLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ManifestInspectLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ManifestInspectLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
	ManifestModifyLibpod modifies manifest list

	Add/Remove an image(s) to a manifest list

Note: operations are not atomic when multiple Images are provided.

As of v4.0.0
*/
func (a *Client) ManifestModifyLibpod(params *ManifestModifyLibpodParams, opts ...ClientOption) (*ManifestModifyLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewManifestModifyLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ManifestModifyLibpod",
		Method:             "PUT",
		PathPattern:        "/libpod/manifests/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ManifestModifyLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ManifestModifyLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ManifestModifyLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
	ManifestPushLibpod pushes manifest list to registry

	Push a manifest list or image index to the named registry

As of v4.0.0
*/
func (a *Client) ManifestPushLibpod(params *ManifestPushLibpodParams, opts ...ClientOption) (*ManifestPushLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewManifestPushLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ManifestPushLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/manifests/{name}/registry/{destination}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ManifestPushLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ManifestPushLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ManifestPushLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
	ManifestPushV3Libpod pushes manifest to registry

	Push a manifest list or image index to a registry

Deprecated: As of 4.0.0 use ManifestPushLibpod instead
*/
func (a *Client) ManifestPushV3Libpod(params *ManifestPushV3LibpodParams, opts ...ClientOption) (*ManifestPushV3LibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewManifestPushV3LibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ManifestPushV3Libpod",
		Method:             "POST",
		PathPattern:        "/libpod/manifests/{name}/push",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ManifestPushV3LibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ManifestPushV3LibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ManifestPushV3Libpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
