// Code generated by go-swagger; DO NOT EDIT.

package networks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNetworkDeleteLibpodParams creates a new NetworkDeleteLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetworkDeleteLibpodParams() *NetworkDeleteLibpodParams {
	return &NetworkDeleteLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetworkDeleteLibpodParamsWithTimeout creates a new NetworkDeleteLibpodParams object
// with the ability to set a timeout on a request.
func NewNetworkDeleteLibpodParamsWithTimeout(timeout time.Duration) *NetworkDeleteLibpodParams {
	return &NetworkDeleteLibpodParams{
		timeout: timeout,
	}
}

// NewNetworkDeleteLibpodParamsWithContext creates a new NetworkDeleteLibpodParams object
// with the ability to set a context for a request.
func NewNetworkDeleteLibpodParamsWithContext(ctx context.Context) *NetworkDeleteLibpodParams {
	return &NetworkDeleteLibpodParams{
		Context: ctx,
	}
}

// NewNetworkDeleteLibpodParamsWithHTTPClient creates a new NetworkDeleteLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetworkDeleteLibpodParamsWithHTTPClient(client *http.Client) *NetworkDeleteLibpodParams {
	return &NetworkDeleteLibpodParams{
		HTTPClient: client,
	}
}

/*
NetworkDeleteLibpodParams contains all the parameters to send to the API endpoint

	for the network delete libpod operation.

	Typically these are written to a http.Request.
*/
type NetworkDeleteLibpodParams struct {

	/* Force.

	   remove containers associated with network
	*/
	Force *bool

	/* Name.

	   the name of the network
	*/
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the network delete libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkDeleteLibpodParams) WithDefaults() *NetworkDeleteLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the network delete libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkDeleteLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the network delete libpod params
func (o *NetworkDeleteLibpodParams) WithTimeout(timeout time.Duration) *NetworkDeleteLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the network delete libpod params
func (o *NetworkDeleteLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the network delete libpod params
func (o *NetworkDeleteLibpodParams) WithContext(ctx context.Context) *NetworkDeleteLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the network delete libpod params
func (o *NetworkDeleteLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the network delete libpod params
func (o *NetworkDeleteLibpodParams) WithHTTPClient(client *http.Client) *NetworkDeleteLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the network delete libpod params
func (o *NetworkDeleteLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithForce adds the force to the network delete libpod params
func (o *NetworkDeleteLibpodParams) WithForce(force *bool) *NetworkDeleteLibpodParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the network delete libpod params
func (o *NetworkDeleteLibpodParams) SetForce(force *bool) {
	o.Force = force
}

// WithName adds the name to the network delete libpod params
func (o *NetworkDeleteLibpodParams) WithName(name string) *NetworkDeleteLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the network delete libpod params
func (o *NetworkDeleteLibpodParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *NetworkDeleteLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Force != nil {

		// query param force
		var qrForce bool

		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {

			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
