// Code generated by go-swagger; DO NOT EDIT.

package networks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// NewNetworkDisconnectLibpodParams creates a new NetworkDisconnectLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetworkDisconnectLibpodParams() *NetworkDisconnectLibpodParams {
	return &NetworkDisconnectLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetworkDisconnectLibpodParamsWithTimeout creates a new NetworkDisconnectLibpodParams object
// with the ability to set a timeout on a request.
func NewNetworkDisconnectLibpodParamsWithTimeout(timeout time.Duration) *NetworkDisconnectLibpodParams {
	return &NetworkDisconnectLibpodParams{
		timeout: timeout,
	}
}

// NewNetworkDisconnectLibpodParamsWithContext creates a new NetworkDisconnectLibpodParams object
// with the ability to set a context for a request.
func NewNetworkDisconnectLibpodParamsWithContext(ctx context.Context) *NetworkDisconnectLibpodParams {
	return &NetworkDisconnectLibpodParams{
		Context: ctx,
	}
}

// NewNetworkDisconnectLibpodParamsWithHTTPClient creates a new NetworkDisconnectLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetworkDisconnectLibpodParamsWithHTTPClient(client *http.Client) *NetworkDisconnectLibpodParams {
	return &NetworkDisconnectLibpodParams{
		HTTPClient: client,
	}
}

/*
NetworkDisconnectLibpodParams contains all the parameters to send to the API endpoint

	for the network disconnect libpod operation.

	Typically these are written to a http.Request.
*/
type NetworkDisconnectLibpodParams struct {

	/* Create.

	   attributes for disconnecting a container from a network
	*/
	Create *models.SwagCompatNetworkDisconnectRequest

	/* Name.

	   the name of the network
	*/
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the network disconnect libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkDisconnectLibpodParams) WithDefaults() *NetworkDisconnectLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the network disconnect libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkDisconnectLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the network disconnect libpod params
func (o *NetworkDisconnectLibpodParams) WithTimeout(timeout time.Duration) *NetworkDisconnectLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the network disconnect libpod params
func (o *NetworkDisconnectLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the network disconnect libpod params
func (o *NetworkDisconnectLibpodParams) WithContext(ctx context.Context) *NetworkDisconnectLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the network disconnect libpod params
func (o *NetworkDisconnectLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the network disconnect libpod params
func (o *NetworkDisconnectLibpodParams) WithHTTPClient(client *http.Client) *NetworkDisconnectLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the network disconnect libpod params
func (o *NetworkDisconnectLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCreate adds the create to the network disconnect libpod params
func (o *NetworkDisconnectLibpodParams) WithCreate(create *models.SwagCompatNetworkDisconnectRequest) *NetworkDisconnectLibpodParams {
	o.SetCreate(create)
	return o
}

// SetCreate adds the create to the network disconnect libpod params
func (o *NetworkDisconnectLibpodParams) SetCreate(create *models.SwagCompatNetworkDisconnectRequest) {
	o.Create = create
}

// WithName adds the name to the network disconnect libpod params
func (o *NetworkDisconnectLibpodParams) WithName(name string) *NetworkDisconnectLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the network disconnect libpod params
func (o *NetworkDisconnectLibpodParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *NetworkDisconnectLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Create != nil {
		if err := r.SetBodyParam(o.Create); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
