// Code generated by go-swagger; DO NOT EDIT.

package networks_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// NewNetworkCreateParams creates a new NetworkCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetworkCreateParams() *NetworkCreateParams {
	return &NetworkCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetworkCreateParamsWithTimeout creates a new NetworkCreateParams object
// with the ability to set a timeout on a request.
func NewNetworkCreateParamsWithTimeout(timeout time.Duration) *NetworkCreateParams {
	return &NetworkCreateParams{
		timeout: timeout,
	}
}

// NewNetworkCreateParamsWithContext creates a new NetworkCreateParams object
// with the ability to set a context for a request.
func NewNetworkCreateParamsWithContext(ctx context.Context) *NetworkCreateParams {
	return &NetworkCreateParams{
		Context: ctx,
	}
}

// NewNetworkCreateParamsWithHTTPClient creates a new NetworkCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetworkCreateParamsWithHTTPClient(client *http.Client) *NetworkCreateParams {
	return &NetworkCreateParams{
		HTTPClient: client,
	}
}

/*
NetworkCreateParams contains all the parameters to send to the API endpoint

	for the network create operation.

	Typically these are written to a http.Request.
*/
type NetworkCreateParams struct {

	/* Create.

	   attributes for creating a network
	*/
	Create *models.NetworkCreateRequest

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the network create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkCreateParams) WithDefaults() *NetworkCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the network create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkCreateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the network create params
func (o *NetworkCreateParams) WithTimeout(timeout time.Duration) *NetworkCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the network create params
func (o *NetworkCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the network create params
func (o *NetworkCreateParams) WithContext(ctx context.Context) *NetworkCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the network create params
func (o *NetworkCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the network create params
func (o *NetworkCreateParams) WithHTTPClient(client *http.Client) *NetworkCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the network create params
func (o *NetworkCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCreate adds the create to the network create params
func (o *NetworkCreateParams) WithCreate(create *models.NetworkCreateRequest) *NetworkCreateParams {
	o.SetCreate(create)
	return o
}

// SetCreate adds the create to the network create params
func (o *NetworkCreateParams) SetCreate(create *models.NetworkCreateRequest) {
	o.Create = create
}

// WriteToRequest writes these params to a swagger request
func (o *NetworkCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Create != nil {
		if err := r.SetBodyParam(o.Create); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
