// Code generated by go-swagger; DO NOT EDIT.

package networks_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new networks compat API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for networks compat API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	NetworkConnect(params *NetworkConnectParams, opts ...ClientOption) (*NetworkConnectOK, error)

	NetworkCreate(params *NetworkCreateParams, opts ...ClientOption) (*NetworkCreateOK, error)

	NetworkDelete(params *NetworkDeleteParams, opts ...ClientOption) (*NetworkDeleteNoContent, error)

	NetworkDisconnect(params *NetworkDisconnectParams, opts ...ClientOption) (*NetworkDisconnectOK, error)

	NetworkInspect(params *NetworkInspectParams, opts ...ClientOption) (*NetworkInspectOK, error)

	NetworkList(params *NetworkListParams, opts ...ClientOption) (*NetworkListOK, error)

	NetworkPrune(params *NetworkPruneParams, opts ...ClientOption) (*NetworkPruneOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
NetworkConnect connects container to network

Connect a container to a network.  This endpoint is current a no-op
*/
func (a *Client) NetworkConnect(params *NetworkConnectParams, opts ...ClientOption) (*NetworkConnectOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkConnectParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkConnect",
		Method:             "POST",
		PathPattern:        "/networks/{name}/connect",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkConnectReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkConnectOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkConnect: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
NetworkCreate creates network

Create a network configuration
*/
func (a *Client) NetworkCreate(params *NetworkCreateParams, opts ...ClientOption) (*NetworkCreateOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkCreate",
		Method:             "POST",
		PathPattern:        "/networks/create",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkCreateReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkCreateOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkCreate: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
NetworkDelete removes a network

Remove a network
*/
func (a *Client) NetworkDelete(params *NetworkDeleteParams, opts ...ClientOption) (*NetworkDeleteNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkDelete",
		Method:             "DELETE",
		PathPattern:        "/networks/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkDeleteReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkDeleteNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkDelete: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
NetworkDisconnect disconnects container from network

Disconnect a container from a network.  This endpoint is current a no-op
*/
func (a *Client) NetworkDisconnect(params *NetworkDisconnectParams, opts ...ClientOption) (*NetworkDisconnectOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkDisconnectParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkDisconnect",
		Method:             "POST",
		PathPattern:        "/networks/{name}/disconnect",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkDisconnectReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkDisconnectOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkDisconnect: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
NetworkInspect inspects a network

Display low level configuration network
*/
func (a *Client) NetworkInspect(params *NetworkInspectParams, opts ...ClientOption) (*NetworkInspectOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkInspectParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkInspect",
		Method:             "GET",
		PathPattern:        "/networks/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkInspectReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkInspectOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkInspect: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
NetworkList lists networks

Display summary of network configurations
*/
func (a *Client) NetworkList(params *NetworkListParams, opts ...ClientOption) (*NetworkListOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkListParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkList",
		Method:             "GET",
		PathPattern:        "/networks",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkListReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkListOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkList: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
NetworkPrune deletes unused networks

Remove CNI networks that do not have containers
*/
func (a *Client) NetworkPrune(params *NetworkPruneParams, opts ...ClientOption) (*NetworkPruneOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkPruneParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkPrune",
		Method:             "POST",
		PathPattern:        "/networks/prune",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkPruneReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkPruneOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkPrune: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
