// Code generated by go-swagger; DO NOT EDIT.

package pods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewPodListLibpodParams creates a new PodListLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPodListLibpodParams() *PodListLibpodParams {
	return &PodListLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPodListLibpodParamsWithTimeout creates a new PodListLibpodParams object
// with the ability to set a timeout on a request.
func NewPodListLibpodParamsWithTimeout(timeout time.Duration) *PodListLibpodParams {
	return &PodListLibpodParams{
		timeout: timeout,
	}
}

// NewPodListLibpodParamsWithContext creates a new PodListLibpodParams object
// with the ability to set a context for a request.
func NewPodListLibpodParamsWithContext(ctx context.Context) *PodListLibpodParams {
	return &PodListLibpodParams{
		Context: ctx,
	}
}

// NewPodListLibpodParamsWithHTTPClient creates a new PodListLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewPodListLibpodParamsWithHTTPClient(client *http.Client) *PodListLibpodParams {
	return &PodListLibpodParams{
		HTTPClient: client,
	}
}

/*
PodListLibpodParams contains all the parameters to send to the API endpoint

	for the pod list libpod operation.

	Typically these are written to a http.Request.
*/
type PodListLibpodParams struct {

	/* Filters.

	   JSON encoded value of the filters (a map[string][]string) to process on the pods list. Available filters:
	- `id=<pod-id>` Matches all of pod id.
	- `label=<key>` or `label=<key>:<value>` Matches pods based on the presence of a label alone or a label and a value.
	- `name=<pod-name>` Matches all of pod name.
	- `until=<timestamp>` List pods created before this timestamp. The `<timestamp>` can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. `10m`, `1h30m`) computed relative to the daemon machine’s time.
	- `status=<pod-status>` Pod's status: `stopped`, `running`, `paused`, `exited`, `dead`, `created`, `degraded`.
	- `network=<pod-network>` Name or full ID of network.
	- `ctr-names=<pod-ctr-names>` Container name within the pod.
	- `ctr-ids=<pod-ctr-ids>` Container ID within the pod.
	- `ctr-status=<pod-ctr-status>` Container status within the pod.
	- `ctr-number=<pod-ctr-number>` Number of containers in the pod.

	*/
	Filters *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the pod list libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PodListLibpodParams) WithDefaults() *PodListLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the pod list libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PodListLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the pod list libpod params
func (o *PodListLibpodParams) WithTimeout(timeout time.Duration) *PodListLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the pod list libpod params
func (o *PodListLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the pod list libpod params
func (o *PodListLibpodParams) WithContext(ctx context.Context) *PodListLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the pod list libpod params
func (o *PodListLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the pod list libpod params
func (o *PodListLibpodParams) WithHTTPClient(client *http.Client) *PodListLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the pod list libpod params
func (o *PodListLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilters adds the filters to the pod list libpod params
func (o *PodListLibpodParams) WithFilters(filters *string) *PodListLibpodParams {
	o.SetFilters(filters)
	return o
}

// SetFilters adds the filters to the pod list libpod params
func (o *PodListLibpodParams) SetFilters(filters *string) {
	o.Filters = filters
}

// WriteToRequest writes these params to a swagger request
func (o *PodListLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filters != nil {

		// query param filters
		var qrFilters string

		if o.Filters != nil {
			qrFilters = *o.Filters
		}
		qFilters := qrFilters
		if qFilters != "" {

			if err := r.SetQueryParam("filters", qFilters); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
