// Code generated by go-swagger; DO NOT EDIT.

package pods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// PodPauseLibpodReader is a Reader for the PodPauseLibpod structure.
type PodPauseLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PodPauseLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPodPauseLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewPodPauseLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewPodPauseLibpodConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPodPauseLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewPodPauseLibpodOK creates a PodPauseLibpodOK with default headers values
func NewPodPauseLibpodOK() *PodPauseLibpodOK {
	return &PodPauseLibpodOK{}
}

/*
PodPauseLibpodOK describes a response with status code 200, with default header values.

Pause pod
*/
type PodPauseLibpodOK struct {
	Payload *models.PodPauseReport
}

// IsSuccess returns true when this pod pause libpod o k response has a 2xx status code
func (o *PodPauseLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this pod pause libpod o k response has a 3xx status code
func (o *PodPauseLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod pause libpod o k response has a 4xx status code
func (o *PodPauseLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod pause libpod o k response has a 5xx status code
func (o *PodPauseLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this pod pause libpod o k response a status code equal to that given
func (o *PodPauseLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *PodPauseLibpodOK) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/pause][%d] podPauseLibpodOK  %+v", 200, o.Payload)
}

func (o *PodPauseLibpodOK) String() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/pause][%d] podPauseLibpodOK  %+v", 200, o.Payload)
}

func (o *PodPauseLibpodOK) GetPayload() *models.PodPauseReport {
	return o.Payload
}

func (o *PodPauseLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PodPauseReport)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodPauseLibpodNotFound creates a PodPauseLibpodNotFound with default headers values
func NewPodPauseLibpodNotFound() *PodPauseLibpodNotFound {
	return &PodPauseLibpodNotFound{}
}

/*
PodPauseLibpodNotFound describes a response with status code 404, with default header values.

No such pod
*/
type PodPauseLibpodNotFound struct {
	Payload *PodPauseLibpodNotFoundBody
}

// IsSuccess returns true when this pod pause libpod not found response has a 2xx status code
func (o *PodPauseLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod pause libpod not found response has a 3xx status code
func (o *PodPauseLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod pause libpod not found response has a 4xx status code
func (o *PodPauseLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this pod pause libpod not found response has a 5xx status code
func (o *PodPauseLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this pod pause libpod not found response a status code equal to that given
func (o *PodPauseLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *PodPauseLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/pause][%d] podPauseLibpodNotFound  %+v", 404, o.Payload)
}

func (o *PodPauseLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/pause][%d] podPauseLibpodNotFound  %+v", 404, o.Payload)
}

func (o *PodPauseLibpodNotFound) GetPayload() *PodPauseLibpodNotFoundBody {
	return o.Payload
}

func (o *PodPauseLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodPauseLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodPauseLibpodConflict creates a PodPauseLibpodConflict with default headers values
func NewPodPauseLibpodConflict() *PodPauseLibpodConflict {
	return &PodPauseLibpodConflict{}
}

/*
PodPauseLibpodConflict describes a response with status code 409, with default header values.

Pause pod
*/
type PodPauseLibpodConflict struct {
	Payload *models.PodPauseReport
}

// IsSuccess returns true when this pod pause libpod conflict response has a 2xx status code
func (o *PodPauseLibpodConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod pause libpod conflict response has a 3xx status code
func (o *PodPauseLibpodConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod pause libpod conflict response has a 4xx status code
func (o *PodPauseLibpodConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this pod pause libpod conflict response has a 5xx status code
func (o *PodPauseLibpodConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this pod pause libpod conflict response a status code equal to that given
func (o *PodPauseLibpodConflict) IsCode(code int) bool {
	return code == 409
}

func (o *PodPauseLibpodConflict) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/pause][%d] podPauseLibpodConflict  %+v", 409, o.Payload)
}

func (o *PodPauseLibpodConflict) String() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/pause][%d] podPauseLibpodConflict  %+v", 409, o.Payload)
}

func (o *PodPauseLibpodConflict) GetPayload() *models.PodPauseReport {
	return o.Payload
}

func (o *PodPauseLibpodConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PodPauseReport)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodPauseLibpodInternalServerError creates a PodPauseLibpodInternalServerError with default headers values
func NewPodPauseLibpodInternalServerError() *PodPauseLibpodInternalServerError {
	return &PodPauseLibpodInternalServerError{}
}

/*
PodPauseLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type PodPauseLibpodInternalServerError struct {
	Payload *PodPauseLibpodInternalServerErrorBody
}

// IsSuccess returns true when this pod pause libpod internal server error response has a 2xx status code
func (o *PodPauseLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod pause libpod internal server error response has a 3xx status code
func (o *PodPauseLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod pause libpod internal server error response has a 4xx status code
func (o *PodPauseLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod pause libpod internal server error response has a 5xx status code
func (o *PodPauseLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this pod pause libpod internal server error response a status code equal to that given
func (o *PodPauseLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *PodPauseLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/pause][%d] podPauseLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodPauseLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/pause][%d] podPauseLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodPauseLibpodInternalServerError) GetPayload() *PodPauseLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *PodPauseLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodPauseLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PodPauseLibpodInternalServerErrorBody pod pause libpod internal server error body
swagger:model PodPauseLibpodInternalServerErrorBody
*/
type PodPauseLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod pause libpod internal server error body
func (o *PodPauseLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod pause libpod internal server error body based on context it is used
func (o *PodPauseLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodPauseLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodPauseLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res PodPauseLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PodPauseLibpodNotFoundBody pod pause libpod not found body
swagger:model PodPauseLibpodNotFoundBody
*/
type PodPauseLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod pause libpod not found body
func (o *PodPauseLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod pause libpod not found body based on context it is used
func (o *PodPauseLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodPauseLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodPauseLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res PodPauseLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
