// Code generated by go-swagger; DO NOT EDIT.

package client

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/skupperproject/skupper/client/generated/libpod/client/containers"
	"github.com/skupperproject/skupper/client/generated/libpod/client/containers_compat"
	"github.com/skupperproject/skupper/client/generated/libpod/client/exec"
	"github.com/skupperproject/skupper/client/generated/libpod/client/exec_compat"
	"github.com/skupperproject/skupper/client/generated/libpod/client/images"
	"github.com/skupperproject/skupper/client/generated/libpod/client/images_compat"
	"github.com/skupperproject/skupper/client/generated/libpod/client/manifests"
	"github.com/skupperproject/skupper/client/generated/libpod/client/networks"
	"github.com/skupperproject/skupper/client/generated/libpod/client/networks_compat"
	"github.com/skupperproject/skupper/client/generated/libpod/client/pods"
	"github.com/skupperproject/skupper/client/generated/libpod/client/secrets"
	"github.com/skupperproject/skupper/client/generated/libpod/client/secrets_compat"
	"github.com/skupperproject/skupper/client/generated/libpod/client/system"
	"github.com/skupperproject/skupper/client/generated/libpod/client/system_compat"
	"github.com/skupperproject/skupper/client/generated/libpod/client/volumes"
	"github.com/skupperproject/skupper/client/generated/libpod/client/volumes_compat"
)

// Default provides an API for the libpod library HTTP client.
var Default = NewHTTPClient(nil)

const (
	// DefaultHost is the default Host
	// found in Meta (info) section of spec file
	DefaultHost string = "podman.io"
	// DefaultBasePath is the default BasePath
	// found in Meta (info) section of spec file
	DefaultBasePath string = "/"
)

// DefaultSchemes are the default schemes found in Meta (info) section of spec file
var DefaultSchemes = []string{"http", "https"}

// NewHTTPClient creates a new provides an API for the libpod library HTTP client.
func NewHTTPClient(formats strfmt.Registry) *ProvidesAnAPIForTheLibpodLibrary {
	return NewHTTPClientWithConfig(formats, nil)
}

// NewHTTPClientWithConfig creates a new provides an API for the libpod library HTTP client,
// using a customizable transport config.
func NewHTTPClientWithConfig(formats strfmt.Registry, cfg *TransportConfig) *ProvidesAnAPIForTheLibpodLibrary {
	// ensure nullable parameters have default
	if cfg == nil {
		cfg = DefaultTransportConfig()
	}

	// create transport and client
	transport := httptransport.New(cfg.Host, cfg.BasePath, cfg.Schemes)
	return New(transport, formats)
}

// New creates a new provides an API for the libpod library client
func New(transport runtime.ClientTransport, formats strfmt.Registry) *ProvidesAnAPIForTheLibpodLibrary {
	// ensure nullable parameters have default
	if formats == nil {
		formats = strfmt.Default
	}

	cli := new(ProvidesAnAPIForTheLibpodLibrary)
	cli.Transport = transport
	cli.Containers = containers.New(transport, formats)
	cli.ContainersCompat = containers_compat.New(transport, formats)
	cli.Exec = exec.New(transport, formats)
	cli.ExecCompat = exec_compat.New(transport, formats)
	cli.Images = images.New(transport, formats)
	cli.ImagesCompat = images_compat.New(transport, formats)
	cli.Manifests = manifests.New(transport, formats)
	cli.Networks = networks.New(transport, formats)
	cli.NetworksCompat = networks_compat.New(transport, formats)
	cli.Pods = pods.New(transport, formats)
	cli.Secrets = secrets.New(transport, formats)
	cli.SecretsCompat = secrets_compat.New(transport, formats)
	cli.System = system.New(transport, formats)
	cli.SystemCompat = system_compat.New(transport, formats)
	cli.Volumes = volumes.New(transport, formats)
	cli.VolumesCompat = volumes_compat.New(transport, formats)
	return cli
}

// DefaultTransportConfig creates a TransportConfig with the
// default settings taken from the meta section of the spec file.
func DefaultTransportConfig() *TransportConfig {
	return &TransportConfig{
		Host:     DefaultHost,
		BasePath: DefaultBasePath,
		Schemes:  DefaultSchemes,
	}
}

// TransportConfig contains the transport related info,
// found in the meta section of the spec file.
type TransportConfig struct {
	Host     string
	BasePath string
	Schemes  []string
}

// WithHost overrides the default host,
// provided by the meta section of the spec file.
func (cfg *TransportConfig) WithHost(host string) *TransportConfig {
	cfg.Host = host
	return cfg
}

// WithBasePath overrides the default basePath,
// provided by the meta section of the spec file.
func (cfg *TransportConfig) WithBasePath(basePath string) *TransportConfig {
	cfg.BasePath = basePath
	return cfg
}

// WithSchemes overrides the default schemes,
// provided by the meta section of the spec file.
func (cfg *TransportConfig) WithSchemes(schemes []string) *TransportConfig {
	cfg.Schemes = schemes
	return cfg
}

// ProvidesAnAPIForTheLibpodLibrary is a client for provides an API for the libpod library
type ProvidesAnAPIForTheLibpodLibrary struct {
	Containers containers.ClientService

	ContainersCompat containers_compat.ClientService

	Exec exec.ClientService

	ExecCompat exec_compat.ClientService

	Images images.ClientService

	ImagesCompat images_compat.ClientService

	Manifests manifests.ClientService

	Networks networks.ClientService

	NetworksCompat networks_compat.ClientService

	Pods pods.ClientService

	Secrets secrets.ClientService

	SecretsCompat secrets_compat.ClientService

	System system.ClientService

	SystemCompat system_compat.ClientService

	Volumes volumes.ClientService

	VolumesCompat volumes_compat.ClientService

	Transport runtime.ClientTransport
}

// SetTransport changes the transport on the client and all its subresources
func (c *ProvidesAnAPIForTheLibpodLibrary) SetTransport(transport runtime.ClientTransport) {
	c.Transport = transport
	c.Containers.SetTransport(transport)
	c.ContainersCompat.SetTransport(transport)
	c.Exec.SetTransport(transport)
	c.ExecCompat.SetTransport(transport)
	c.Images.SetTransport(transport)
	c.ImagesCompat.SetTransport(transport)
	c.Manifests.SetTransport(transport)
	c.Networks.SetTransport(transport)
	c.NetworksCompat.SetTransport(transport)
	c.Pods.SetTransport(transport)
	c.Secrets.SetTransport(transport)
	c.SecretsCompat.SetTransport(transport)
	c.System.SetTransport(transport)
	c.SystemCompat.SetTransport(transport)
	c.Volumes.SetTransport(transport)
	c.VolumesCompat.SetTransport(transport)
}
