// Code generated by go-swagger; DO NOT EDIT.

package secrets

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewSecretCreateLibpodParams creates a new SecretCreateLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecretCreateLibpodParams() *SecretCreateLibpodParams {
	return &SecretCreateLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecretCreateLibpodParamsWithTimeout creates a new SecretCreateLibpodParams object
// with the ability to set a timeout on a request.
func NewSecretCreateLibpodParamsWithTimeout(timeout time.Duration) *SecretCreateLibpodParams {
	return &SecretCreateLibpodParams{
		timeout: timeout,
	}
}

// NewSecretCreateLibpodParamsWithContext creates a new SecretCreateLibpodParams object
// with the ability to set a context for a request.
func NewSecretCreateLibpodParamsWithContext(ctx context.Context) *SecretCreateLibpodParams {
	return &SecretCreateLibpodParams{
		Context: ctx,
	}
}

// NewSecretCreateLibpodParamsWithHTTPClient creates a new SecretCreateLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecretCreateLibpodParamsWithHTTPClient(client *http.Client) *SecretCreateLibpodParams {
	return &SecretCreateLibpodParams{
		HTTPClient: client,
	}
}

/*
SecretCreateLibpodParams contains all the parameters to send to the API endpoint

	for the secret create libpod operation.

	Typically these are written to a http.Request.
*/
type SecretCreateLibpodParams struct {

	/* Driver.

	   Secret driver

	   Default: "file"
	*/
	Driver *string

	/* Name.

	   User-defined name of the secret.
	*/
	Name string

	/* Request.

	   Secret
	*/
	Request string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the secret create libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecretCreateLibpodParams) WithDefaults() *SecretCreateLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the secret create libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecretCreateLibpodParams) SetDefaults() {
	var (
		driverDefault = string("file")
	)

	val := SecretCreateLibpodParams{
		Driver: &driverDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the secret create libpod params
func (o *SecretCreateLibpodParams) WithTimeout(timeout time.Duration) *SecretCreateLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the secret create libpod params
func (o *SecretCreateLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the secret create libpod params
func (o *SecretCreateLibpodParams) WithContext(ctx context.Context) *SecretCreateLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the secret create libpod params
func (o *SecretCreateLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the secret create libpod params
func (o *SecretCreateLibpodParams) WithHTTPClient(client *http.Client) *SecretCreateLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the secret create libpod params
func (o *SecretCreateLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDriver adds the driver to the secret create libpod params
func (o *SecretCreateLibpodParams) WithDriver(driver *string) *SecretCreateLibpodParams {
	o.SetDriver(driver)
	return o
}

// SetDriver adds the driver to the secret create libpod params
func (o *SecretCreateLibpodParams) SetDriver(driver *string) {
	o.Driver = driver
}

// WithName adds the name to the secret create libpod params
func (o *SecretCreateLibpodParams) WithName(name string) *SecretCreateLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the secret create libpod params
func (o *SecretCreateLibpodParams) SetName(name string) {
	o.Name = name
}

// WithRequest adds the request to the secret create libpod params
func (o *SecretCreateLibpodParams) WithRequest(request string) *SecretCreateLibpodParams {
	o.SetRequest(request)
	return o
}

// SetRequest adds the request to the secret create libpod params
func (o *SecretCreateLibpodParams) SetRequest(request string) {
	o.Request = request
}

// WriteToRequest writes these params to a swagger request
func (o *SecretCreateLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Driver != nil {

		// query param driver
		var qrDriver string

		if o.Driver != nil {
			qrDriver = *o.Driver
		}
		qDriver := qrDriver
		if qDriver != "" {

			if err := r.SetQueryParam("driver", qDriver); err != nil {
				return err
			}
		}
	}

	// query param name
	qrName := o.Name
	qName := qrName
	if qName != "" {

		if err := r.SetQueryParam("name", qName); err != nil {
			return err
		}
	}
	if err := r.SetBodyParam(o.Request); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
