// Code generated by go-swagger; DO NOT EDIT.

package secrets

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new secrets API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for secrets API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	SecretCreateLibpod(params *SecretCreateLibpodParams, opts ...ClientOption) (*SecretCreateLibpodCreated, error)

	SecretDeleteLibpod(params *SecretDeleteLibpodParams, opts ...ClientOption) (*SecretDeleteLibpodNoContent, error)

	SecretInspectLibpod(params *SecretInspectLibpodParams, opts ...ClientOption) (*SecretInspectLibpodOK, error)

	SecretListLibpod(params *SecretListLibpodParams, opts ...ClientOption) (*SecretListLibpodOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
SecretCreateLibpod creates a secret
*/
func (a *Client) SecretCreateLibpod(params *SecretCreateLibpodParams, opts ...ClientOption) (*SecretCreateLibpodCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecretCreateLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SecretCreateLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/secrets/create",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SecretCreateLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecretCreateLibpodCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for SecretCreateLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SecretDeleteLibpod removes secret
*/
func (a *Client) SecretDeleteLibpod(params *SecretDeleteLibpodParams, opts ...ClientOption) (*SecretDeleteLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecretDeleteLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SecretDeleteLibpod",
		Method:             "DELETE",
		PathPattern:        "/libpod/secrets/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SecretDeleteLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecretDeleteLibpodNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for SecretDeleteLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SecretInspectLibpod inspects secret
*/
func (a *Client) SecretInspectLibpod(params *SecretInspectLibpodParams, opts ...ClientOption) (*SecretInspectLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecretInspectLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SecretInspectLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/secrets/{name}/json",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SecretInspectLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecretInspectLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for SecretInspectLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SecretListLibpod lists secrets

Returns a list of secrets
*/
func (a *Client) SecretListLibpod(params *SecretListLibpodParams, opts ...ClientOption) (*SecretListLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecretListLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SecretListLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/secrets/json",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SecretListLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecretListLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for SecretListLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
