// Code generated by go-swagger; DO NOT EDIT.

package system

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSystemEventsLibpodParams creates a new SystemEventsLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSystemEventsLibpodParams() *SystemEventsLibpodParams {
	return &SystemEventsLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSystemEventsLibpodParamsWithTimeout creates a new SystemEventsLibpodParams object
// with the ability to set a timeout on a request.
func NewSystemEventsLibpodParamsWithTimeout(timeout time.Duration) *SystemEventsLibpodParams {
	return &SystemEventsLibpodParams{
		timeout: timeout,
	}
}

// NewSystemEventsLibpodParamsWithContext creates a new SystemEventsLibpodParams object
// with the ability to set a context for a request.
func NewSystemEventsLibpodParamsWithContext(ctx context.Context) *SystemEventsLibpodParams {
	return &SystemEventsLibpodParams{
		Context: ctx,
	}
}

// NewSystemEventsLibpodParamsWithHTTPClient creates a new SystemEventsLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewSystemEventsLibpodParamsWithHTTPClient(client *http.Client) *SystemEventsLibpodParams {
	return &SystemEventsLibpodParams{
		HTTPClient: client,
	}
}

/*
SystemEventsLibpodParams contains all the parameters to send to the API endpoint

	for the system events libpod operation.

	Typically these are written to a http.Request.
*/
type SystemEventsLibpodParams struct {

	/* Filters.

	   JSON encoded map[string][]string of constraints
	*/
	Filters *string

	/* Since.

	   start streaming events from this time
	*/
	Since *string

	/* Stream.

	   when false, do not follow events

	   Default: true
	*/
	Stream *bool

	/* Until.

	   stop streaming events later than this
	*/
	Until *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the system events libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SystemEventsLibpodParams) WithDefaults() *SystemEventsLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the system events libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SystemEventsLibpodParams) SetDefaults() {
	var (
		streamDefault = bool(true)
	)

	val := SystemEventsLibpodParams{
		Stream: &streamDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the system events libpod params
func (o *SystemEventsLibpodParams) WithTimeout(timeout time.Duration) *SystemEventsLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the system events libpod params
func (o *SystemEventsLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the system events libpod params
func (o *SystemEventsLibpodParams) WithContext(ctx context.Context) *SystemEventsLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the system events libpod params
func (o *SystemEventsLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the system events libpod params
func (o *SystemEventsLibpodParams) WithHTTPClient(client *http.Client) *SystemEventsLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the system events libpod params
func (o *SystemEventsLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilters adds the filters to the system events libpod params
func (o *SystemEventsLibpodParams) WithFilters(filters *string) *SystemEventsLibpodParams {
	o.SetFilters(filters)
	return o
}

// SetFilters adds the filters to the system events libpod params
func (o *SystemEventsLibpodParams) SetFilters(filters *string) {
	o.Filters = filters
}

// WithSince adds the since to the system events libpod params
func (o *SystemEventsLibpodParams) WithSince(since *string) *SystemEventsLibpodParams {
	o.SetSince(since)
	return o
}

// SetSince adds the since to the system events libpod params
func (o *SystemEventsLibpodParams) SetSince(since *string) {
	o.Since = since
}

// WithStream adds the stream to the system events libpod params
func (o *SystemEventsLibpodParams) WithStream(stream *bool) *SystemEventsLibpodParams {
	o.SetStream(stream)
	return o
}

// SetStream adds the stream to the system events libpod params
func (o *SystemEventsLibpodParams) SetStream(stream *bool) {
	o.Stream = stream
}

// WithUntil adds the until to the system events libpod params
func (o *SystemEventsLibpodParams) WithUntil(until *string) *SystemEventsLibpodParams {
	o.SetUntil(until)
	return o
}

// SetUntil adds the until to the system events libpod params
func (o *SystemEventsLibpodParams) SetUntil(until *string) {
	o.Until = until
}

// WriteToRequest writes these params to a swagger request
func (o *SystemEventsLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filters != nil {

		// query param filters
		var qrFilters string

		if o.Filters != nil {
			qrFilters = *o.Filters
		}
		qFilters := qrFilters
		if qFilters != "" {

			if err := r.SetQueryParam("filters", qFilters); err != nil {
				return err
			}
		}
	}

	if o.Since != nil {

		// query param since
		var qrSince string

		if o.Since != nil {
			qrSince = *o.Since
		}
		qSince := qrSince
		if qSince != "" {

			if err := r.SetQueryParam("since", qSince); err != nil {
				return err
			}
		}
	}

	if o.Stream != nil {

		// query param stream
		var qrStream bool

		if o.Stream != nil {
			qrStream = *o.Stream
		}
		qStream := swag.FormatBool(qrStream)
		if qStream != "" {

			if err := r.SetQueryParam("stream", qStream); err != nil {
				return err
			}
		}
	}

	if o.Until != nil {

		// query param until
		var qrUntil string

		if o.Until != nil {
			qrUntil = *o.Until
		}
		qUntil := qrUntil
		if qUntil != "" {

			if err := r.SetQueryParam("until", qUntil); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
