// Code generated by go-swagger; DO NOT EDIT.

package system

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// SystemPruneLibpodReader is a Reader for the SystemPruneLibpod structure.
type SystemPruneLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SystemPruneLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSystemPruneLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewSystemPruneLibpodBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSystemPruneLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewSystemPruneLibpodOK creates a SystemPruneLibpodOK with default headers values
func NewSystemPruneLibpodOK() *SystemPruneLibpodOK {
	return &SystemPruneLibpodOK{}
}

/*
SystemPruneLibpodOK describes a response with status code 200, with default header values.

Prune report
*/
type SystemPruneLibpodOK struct {
	Payload *SystemPruneLibpodOKBody
}

// IsSuccess returns true when this system prune libpod o k response has a 2xx status code
func (o *SystemPruneLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this system prune libpod o k response has a 3xx status code
func (o *SystemPruneLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this system prune libpod o k response has a 4xx status code
func (o *SystemPruneLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this system prune libpod o k response has a 5xx status code
func (o *SystemPruneLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this system prune libpod o k response a status code equal to that given
func (o *SystemPruneLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *SystemPruneLibpodOK) Error() string {
	return fmt.Sprintf("[POST /libpod/system/prune][%d] systemPruneLibpodOK  %+v", 200, o.Payload)
}

func (o *SystemPruneLibpodOK) String() string {
	return fmt.Sprintf("[POST /libpod/system/prune][%d] systemPruneLibpodOK  %+v", 200, o.Payload)
}

func (o *SystemPruneLibpodOK) GetPayload() *SystemPruneLibpodOKBody {
	return o.Payload
}

func (o *SystemPruneLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SystemPruneLibpodOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSystemPruneLibpodBadRequest creates a SystemPruneLibpodBadRequest with default headers values
func NewSystemPruneLibpodBadRequest() *SystemPruneLibpodBadRequest {
	return &SystemPruneLibpodBadRequest{}
}

/*
SystemPruneLibpodBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type SystemPruneLibpodBadRequest struct {
	Payload *SystemPruneLibpodBadRequestBody
}

// IsSuccess returns true when this system prune libpod bad request response has a 2xx status code
func (o *SystemPruneLibpodBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this system prune libpod bad request response has a 3xx status code
func (o *SystemPruneLibpodBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this system prune libpod bad request response has a 4xx status code
func (o *SystemPruneLibpodBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this system prune libpod bad request response has a 5xx status code
func (o *SystemPruneLibpodBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this system prune libpod bad request response a status code equal to that given
func (o *SystemPruneLibpodBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *SystemPruneLibpodBadRequest) Error() string {
	return fmt.Sprintf("[POST /libpod/system/prune][%d] systemPruneLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *SystemPruneLibpodBadRequest) String() string {
	return fmt.Sprintf("[POST /libpod/system/prune][%d] systemPruneLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *SystemPruneLibpodBadRequest) GetPayload() *SystemPruneLibpodBadRequestBody {
	return o.Payload
}

func (o *SystemPruneLibpodBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SystemPruneLibpodBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSystemPruneLibpodInternalServerError creates a SystemPruneLibpodInternalServerError with default headers values
func NewSystemPruneLibpodInternalServerError() *SystemPruneLibpodInternalServerError {
	return &SystemPruneLibpodInternalServerError{}
}

/*
SystemPruneLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type SystemPruneLibpodInternalServerError struct {
	Payload *SystemPruneLibpodInternalServerErrorBody
}

// IsSuccess returns true when this system prune libpod internal server error response has a 2xx status code
func (o *SystemPruneLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this system prune libpod internal server error response has a 3xx status code
func (o *SystemPruneLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this system prune libpod internal server error response has a 4xx status code
func (o *SystemPruneLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this system prune libpod internal server error response has a 5xx status code
func (o *SystemPruneLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this system prune libpod internal server error response a status code equal to that given
func (o *SystemPruneLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *SystemPruneLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/system/prune][%d] systemPruneLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *SystemPruneLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/system/prune][%d] systemPruneLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *SystemPruneLibpodInternalServerError) GetPayload() *SystemPruneLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *SystemPruneLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SystemPruneLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SystemPruneLibpodBadRequestBody system prune libpod bad request body
swagger:model SystemPruneLibpodBadRequestBody
*/
type SystemPruneLibpodBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this system prune libpod bad request body
func (o *SystemPruneLibpodBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this system prune libpod bad request body based on context it is used
func (o *SystemPruneLibpodBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SystemPruneLibpodBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SystemPruneLibpodBadRequestBody) UnmarshalBinary(b []byte) error {
	var res SystemPruneLibpodBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SystemPruneLibpodInternalServerErrorBody system prune libpod internal server error body
swagger:model SystemPruneLibpodInternalServerErrorBody
*/
type SystemPruneLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this system prune libpod internal server error body
func (o *SystemPruneLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this system prune libpod internal server error body based on context it is used
func (o *SystemPruneLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SystemPruneLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SystemPruneLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res SystemPruneLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SystemPruneLibpodOKBody system prune libpod o k body
swagger:model SystemPruneLibpodOKBody
*/
type SystemPruneLibpodOKBody struct {

	// container prune reports
	ContainerPruneReports []*models.PruneReport `json:"ContainerPruneReports"`

	// image prune reports
	ImagePruneReports []*models.PruneReport `json:"ImagePruneReports"`

	// pod prune report
	PodPruneReport []*models.PodPruneReport `json:"PodPruneReport"`

	// reclaimed space
	ReclaimedSpace uint64 `json:"ReclaimedSpace,omitempty"`

	// volume prune reports
	VolumePruneReports []*models.PruneReport `json:"VolumePruneReports"`
}

// Validate validates this system prune libpod o k body
func (o *SystemPruneLibpodOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateContainerPruneReports(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateImagePruneReports(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePodPruneReport(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumePruneReports(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SystemPruneLibpodOKBody) validateContainerPruneReports(formats strfmt.Registry) error {
	if swag.IsZero(o.ContainerPruneReports) { // not required
		return nil
	}

	for i := 0; i < len(o.ContainerPruneReports); i++ {
		if swag.IsZero(o.ContainerPruneReports[i]) { // not required
			continue
		}

		if o.ContainerPruneReports[i] != nil {
			if err := o.ContainerPruneReports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemPruneLibpodOK" + "." + "ContainerPruneReports" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemPruneLibpodOK" + "." + "ContainerPruneReports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SystemPruneLibpodOKBody) validateImagePruneReports(formats strfmt.Registry) error {
	if swag.IsZero(o.ImagePruneReports) { // not required
		return nil
	}

	for i := 0; i < len(o.ImagePruneReports); i++ {
		if swag.IsZero(o.ImagePruneReports[i]) { // not required
			continue
		}

		if o.ImagePruneReports[i] != nil {
			if err := o.ImagePruneReports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemPruneLibpodOK" + "." + "ImagePruneReports" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemPruneLibpodOK" + "." + "ImagePruneReports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SystemPruneLibpodOKBody) validatePodPruneReport(formats strfmt.Registry) error {
	if swag.IsZero(o.PodPruneReport) { // not required
		return nil
	}

	for i := 0; i < len(o.PodPruneReport); i++ {
		if swag.IsZero(o.PodPruneReport[i]) { // not required
			continue
		}

		if o.PodPruneReport[i] != nil {
			if err := o.PodPruneReport[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemPruneLibpodOK" + "." + "PodPruneReport" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemPruneLibpodOK" + "." + "PodPruneReport" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SystemPruneLibpodOKBody) validateVolumePruneReports(formats strfmt.Registry) error {
	if swag.IsZero(o.VolumePruneReports) { // not required
		return nil
	}

	for i := 0; i < len(o.VolumePruneReports); i++ {
		if swag.IsZero(o.VolumePruneReports[i]) { // not required
			continue
		}

		if o.VolumePruneReports[i] != nil {
			if err := o.VolumePruneReports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemPruneLibpodOK" + "." + "VolumePruneReports" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemPruneLibpodOK" + "." + "VolumePruneReports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this system prune libpod o k body based on the context it is used
func (o *SystemPruneLibpodOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateContainerPruneReports(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateImagePruneReports(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePodPruneReport(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumePruneReports(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SystemPruneLibpodOKBody) contextValidateContainerPruneReports(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ContainerPruneReports); i++ {

		if o.ContainerPruneReports[i] != nil {
			if err := o.ContainerPruneReports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemPruneLibpodOK" + "." + "ContainerPruneReports" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemPruneLibpodOK" + "." + "ContainerPruneReports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SystemPruneLibpodOKBody) contextValidateImagePruneReports(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ImagePruneReports); i++ {

		if o.ImagePruneReports[i] != nil {
			if err := o.ImagePruneReports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemPruneLibpodOK" + "." + "ImagePruneReports" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemPruneLibpodOK" + "." + "ImagePruneReports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SystemPruneLibpodOKBody) contextValidatePodPruneReport(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.PodPruneReport); i++ {

		if o.PodPruneReport[i] != nil {
			if err := o.PodPruneReport[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemPruneLibpodOK" + "." + "PodPruneReport" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemPruneLibpodOK" + "." + "PodPruneReport" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SystemPruneLibpodOKBody) contextValidateVolumePruneReports(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumePruneReports); i++ {

		if o.VolumePruneReports[i] != nil {
			if err := o.VolumePruneReports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemPruneLibpodOK" + "." + "VolumePruneReports" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemPruneLibpodOK" + "." + "VolumePruneReports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SystemPruneLibpodOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SystemPruneLibpodOKBody) UnmarshalBinary(b []byte) error {
	var res SystemPruneLibpodOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
