// Code generated by go-swagger; DO NOT EDIT.

package system_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// SystemAuthReader is a Reader for the SystemAuth structure.
type SystemAuthReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SystemAuthReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSystemAuthOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewSystemAuthInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewSystemAuthOK creates a SystemAuthOK with default headers values
func NewSystemAuthOK() *SystemAuthOK {
	return &SystemAuthOK{}
}

/*
SystemAuthOK describes a response with status code 200, with default header values.

Auth response
*/
type SystemAuthOK struct {
	Payload *SystemAuthOKBody
}

// IsSuccess returns true when this system auth o k response has a 2xx status code
func (o *SystemAuthOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this system auth o k response has a 3xx status code
func (o *SystemAuthOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this system auth o k response has a 4xx status code
func (o *SystemAuthOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this system auth o k response has a 5xx status code
func (o *SystemAuthOK) IsServerError() bool {
	return false
}

// IsCode returns true when this system auth o k response a status code equal to that given
func (o *SystemAuthOK) IsCode(code int) bool {
	return code == 200
}

func (o *SystemAuthOK) Error() string {
	return fmt.Sprintf("[POST /auth][%d] systemAuthOK  %+v", 200, o.Payload)
}

func (o *SystemAuthOK) String() string {
	return fmt.Sprintf("[POST /auth][%d] systemAuthOK  %+v", 200, o.Payload)
}

func (o *SystemAuthOK) GetPayload() *SystemAuthOKBody {
	return o.Payload
}

func (o *SystemAuthOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SystemAuthOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSystemAuthInternalServerError creates a SystemAuthInternalServerError with default headers values
func NewSystemAuthInternalServerError() *SystemAuthInternalServerError {
	return &SystemAuthInternalServerError{}
}

/*
SystemAuthInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type SystemAuthInternalServerError struct {
	Payload *SystemAuthInternalServerErrorBody
}

// IsSuccess returns true when this system auth internal server error response has a 2xx status code
func (o *SystemAuthInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this system auth internal server error response has a 3xx status code
func (o *SystemAuthInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this system auth internal server error response has a 4xx status code
func (o *SystemAuthInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this system auth internal server error response has a 5xx status code
func (o *SystemAuthInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this system auth internal server error response a status code equal to that given
func (o *SystemAuthInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *SystemAuthInternalServerError) Error() string {
	return fmt.Sprintf("[POST /auth][%d] systemAuthInternalServerError  %+v", 500, o.Payload)
}

func (o *SystemAuthInternalServerError) String() string {
	return fmt.Sprintf("[POST /auth][%d] systemAuthInternalServerError  %+v", 500, o.Payload)
}

func (o *SystemAuthInternalServerError) GetPayload() *SystemAuthInternalServerErrorBody {
	return o.Payload
}

func (o *SystemAuthInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SystemAuthInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SystemAuthInternalServerErrorBody system auth internal server error body
swagger:model SystemAuthInternalServerErrorBody
*/
type SystemAuthInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this system auth internal server error body
func (o *SystemAuthInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this system auth internal server error body based on context it is used
func (o *SystemAuthInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SystemAuthInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SystemAuthInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res SystemAuthInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SystemAuthOKBody system auth o k body
swagger:model SystemAuthOKBody
*/
type SystemAuthOKBody struct {

	// identity token
	IdentityToken string `json:"IdentityToken,omitempty"`

	// status
	Status string `json:"Status,omitempty"`
}

// Validate validates this system auth o k body
func (o *SystemAuthOKBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this system auth o k body based on context it is used
func (o *SystemAuthOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SystemAuthOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SystemAuthOKBody) UnmarshalBinary(b []byte) error {
	var res SystemAuthOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
