// Code generated by go-swagger; DO NOT EDIT.

package volumes

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// VolumeExistsLibpodReader is a Reader for the VolumeExistsLibpod structure.
type VolumeExistsLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VolumeExistsLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewVolumeExistsLibpodNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewVolumeExistsLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewVolumeExistsLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewVolumeExistsLibpodNoContent creates a VolumeExistsLibpodNoContent with default headers values
func NewVolumeExistsLibpodNoContent() *VolumeExistsLibpodNoContent {
	return &VolumeExistsLibpodNoContent{}
}

/*
VolumeExistsLibpodNoContent describes a response with status code 204, with default header values.

volume exists
*/
type VolumeExistsLibpodNoContent struct {
}

// IsSuccess returns true when this volume exists libpod no content response has a 2xx status code
func (o *VolumeExistsLibpodNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume exists libpod no content response has a 3xx status code
func (o *VolumeExistsLibpodNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume exists libpod no content response has a 4xx status code
func (o *VolumeExistsLibpodNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume exists libpod no content response has a 5xx status code
func (o *VolumeExistsLibpodNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this volume exists libpod no content response a status code equal to that given
func (o *VolumeExistsLibpodNoContent) IsCode(code int) bool {
	return code == 204
}

func (o *VolumeExistsLibpodNoContent) Error() string {
	return fmt.Sprintf("[GET /libpod/volumes/{name}/exists][%d] volumeExistsLibpodNoContent ", 204)
}

func (o *VolumeExistsLibpodNoContent) String() string {
	return fmt.Sprintf("[GET /libpod/volumes/{name}/exists][%d] volumeExistsLibpodNoContent ", 204)
}

func (o *VolumeExistsLibpodNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewVolumeExistsLibpodNotFound creates a VolumeExistsLibpodNotFound with default headers values
func NewVolumeExistsLibpodNotFound() *VolumeExistsLibpodNotFound {
	return &VolumeExistsLibpodNotFound{}
}

/*
VolumeExistsLibpodNotFound describes a response with status code 404, with default header values.

No such volume
*/
type VolumeExistsLibpodNotFound struct {
	Payload *VolumeExistsLibpodNotFoundBody
}

// IsSuccess returns true when this volume exists libpod not found response has a 2xx status code
func (o *VolumeExistsLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this volume exists libpod not found response has a 3xx status code
func (o *VolumeExistsLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume exists libpod not found response has a 4xx status code
func (o *VolumeExistsLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this volume exists libpod not found response has a 5xx status code
func (o *VolumeExistsLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this volume exists libpod not found response a status code equal to that given
func (o *VolumeExistsLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *VolumeExistsLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/volumes/{name}/exists][%d] volumeExistsLibpodNotFound  %+v", 404, o.Payload)
}

func (o *VolumeExistsLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/volumes/{name}/exists][%d] volumeExistsLibpodNotFound  %+v", 404, o.Payload)
}

func (o *VolumeExistsLibpodNotFound) GetPayload() *VolumeExistsLibpodNotFoundBody {
	return o.Payload
}

func (o *VolumeExistsLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(VolumeExistsLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVolumeExistsLibpodInternalServerError creates a VolumeExistsLibpodInternalServerError with default headers values
func NewVolumeExistsLibpodInternalServerError() *VolumeExistsLibpodInternalServerError {
	return &VolumeExistsLibpodInternalServerError{}
}

/*
VolumeExistsLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type VolumeExistsLibpodInternalServerError struct {
	Payload *VolumeExistsLibpodInternalServerErrorBody
}

// IsSuccess returns true when this volume exists libpod internal server error response has a 2xx status code
func (o *VolumeExistsLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this volume exists libpod internal server error response has a 3xx status code
func (o *VolumeExistsLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume exists libpod internal server error response has a 4xx status code
func (o *VolumeExistsLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume exists libpod internal server error response has a 5xx status code
func (o *VolumeExistsLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this volume exists libpod internal server error response a status code equal to that given
func (o *VolumeExistsLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *VolumeExistsLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/volumes/{name}/exists][%d] volumeExistsLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *VolumeExistsLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/volumes/{name}/exists][%d] volumeExistsLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *VolumeExistsLibpodInternalServerError) GetPayload() *VolumeExistsLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *VolumeExistsLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(VolumeExistsLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
VolumeExistsLibpodInternalServerErrorBody volume exists libpod internal server error body
swagger:model VolumeExistsLibpodInternalServerErrorBody
*/
type VolumeExistsLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this volume exists libpod internal server error body
func (o *VolumeExistsLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume exists libpod internal server error body based on context it is used
func (o *VolumeExistsLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeExistsLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeExistsLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res VolumeExistsLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeExistsLibpodNotFoundBody volume exists libpod not found body
swagger:model VolumeExistsLibpodNotFoundBody
*/
type VolumeExistsLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this volume exists libpod not found body
func (o *VolumeExistsLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume exists libpod not found body based on context it is used
func (o *VolumeExistsLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeExistsLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeExistsLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res VolumeExistsLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
