// Code generated by go-swagger; DO NOT EDIT.

package volumes

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// VolumePruneLibpodReader is a Reader for the VolumePruneLibpod structure.
type VolumePruneLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VolumePruneLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVolumePruneLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewVolumePruneLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewVolumePruneLibpodOK creates a VolumePruneLibpodOK with default headers values
func NewVolumePruneLibpodOK() *VolumePruneLibpodOK {
	return &VolumePruneLibpodOK{}
}

/*
VolumePruneLibpodOK describes a response with status code 200, with default header values.

Volume prune response
*/
type VolumePruneLibpodOK struct {
	Payload []*models.PruneReport
}

// IsSuccess returns true when this volume prune libpod o k response has a 2xx status code
func (o *VolumePruneLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume prune libpod o k response has a 3xx status code
func (o *VolumePruneLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume prune libpod o k response has a 4xx status code
func (o *VolumePruneLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume prune libpod o k response has a 5xx status code
func (o *VolumePruneLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this volume prune libpod o k response a status code equal to that given
func (o *VolumePruneLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *VolumePruneLibpodOK) Error() string {
	return fmt.Sprintf("[POST /libpod/volumes/prune][%d] volumePruneLibpodOK  %+v", 200, o.Payload)
}

func (o *VolumePruneLibpodOK) String() string {
	return fmt.Sprintf("[POST /libpod/volumes/prune][%d] volumePruneLibpodOK  %+v", 200, o.Payload)
}

func (o *VolumePruneLibpodOK) GetPayload() []*models.PruneReport {
	return o.Payload
}

func (o *VolumePruneLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVolumePruneLibpodInternalServerError creates a VolumePruneLibpodInternalServerError with default headers values
func NewVolumePruneLibpodInternalServerError() *VolumePruneLibpodInternalServerError {
	return &VolumePruneLibpodInternalServerError{}
}

/*
VolumePruneLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type VolumePruneLibpodInternalServerError struct {
	Payload *VolumePruneLibpodInternalServerErrorBody
}

// IsSuccess returns true when this volume prune libpod internal server error response has a 2xx status code
func (o *VolumePruneLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this volume prune libpod internal server error response has a 3xx status code
func (o *VolumePruneLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume prune libpod internal server error response has a 4xx status code
func (o *VolumePruneLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume prune libpod internal server error response has a 5xx status code
func (o *VolumePruneLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this volume prune libpod internal server error response a status code equal to that given
func (o *VolumePruneLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *VolumePruneLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/volumes/prune][%d] volumePruneLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *VolumePruneLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/volumes/prune][%d] volumePruneLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *VolumePruneLibpodInternalServerError) GetPayload() *VolumePruneLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *VolumePruneLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(VolumePruneLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
VolumePruneLibpodInternalServerErrorBody volume prune libpod internal server error body
swagger:model VolumePruneLibpodInternalServerErrorBody
*/
type VolumePruneLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this volume prune libpod internal server error body
func (o *VolumePruneLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume prune libpod internal server error body based on context it is used
func (o *VolumePruneLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumePruneLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumePruneLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res VolumePruneLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
