// Code generated by go-swagger; DO NOT EDIT.

package volumes_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// VolumePruneReader is a Reader for the VolumePrune structure.
type VolumePruneReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VolumePruneReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVolumePruneOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewVolumePruneInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewVolumePruneOK creates a VolumePruneOK with default headers values
func NewVolumePruneOK() *VolumePruneOK {
	return &VolumePruneOK{}
}

/*
VolumePruneOK describes a response with status code 200, with default header values.

Volume prune response
*/
type VolumePruneOK struct {
	Payload *VolumePruneOKBody
}

// IsSuccess returns true when this volume prune o k response has a 2xx status code
func (o *VolumePruneOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume prune o k response has a 3xx status code
func (o *VolumePruneOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume prune o k response has a 4xx status code
func (o *VolumePruneOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume prune o k response has a 5xx status code
func (o *VolumePruneOK) IsServerError() bool {
	return false
}

// IsCode returns true when this volume prune o k response a status code equal to that given
func (o *VolumePruneOK) IsCode(code int) bool {
	return code == 200
}

func (o *VolumePruneOK) Error() string {
	return fmt.Sprintf("[POST /volumes/prune][%d] volumePruneOK  %+v", 200, o.Payload)
}

func (o *VolumePruneOK) String() string {
	return fmt.Sprintf("[POST /volumes/prune][%d] volumePruneOK  %+v", 200, o.Payload)
}

func (o *VolumePruneOK) GetPayload() *VolumePruneOKBody {
	return o.Payload
}

func (o *VolumePruneOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(VolumePruneOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVolumePruneInternalServerError creates a VolumePruneInternalServerError with default headers values
func NewVolumePruneInternalServerError() *VolumePruneInternalServerError {
	return &VolumePruneInternalServerError{}
}

/*
VolumePruneInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type VolumePruneInternalServerError struct {
	Payload *VolumePruneInternalServerErrorBody
}

// IsSuccess returns true when this volume prune internal server error response has a 2xx status code
func (o *VolumePruneInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this volume prune internal server error response has a 3xx status code
func (o *VolumePruneInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume prune internal server error response has a 4xx status code
func (o *VolumePruneInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume prune internal server error response has a 5xx status code
func (o *VolumePruneInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this volume prune internal server error response a status code equal to that given
func (o *VolumePruneInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *VolumePruneInternalServerError) Error() string {
	return fmt.Sprintf("[POST /volumes/prune][%d] volumePruneInternalServerError  %+v", 500, o.Payload)
}

func (o *VolumePruneInternalServerError) String() string {
	return fmt.Sprintf("[POST /volumes/prune][%d] volumePruneInternalServerError  %+v", 500, o.Payload)
}

func (o *VolumePruneInternalServerError) GetPayload() *VolumePruneInternalServerErrorBody {
	return o.Payload
}

func (o *VolumePruneInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(VolumePruneInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
VolumePruneInternalServerErrorBody volume prune internal server error body
swagger:model VolumePruneInternalServerErrorBody
*/
type VolumePruneInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this volume prune internal server error body
func (o *VolumePruneInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume prune internal server error body based on context it is used
func (o *VolumePruneInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumePruneInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumePruneInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res VolumePruneInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumePruneOKBody volume prune o k body
swagger:model VolumePruneOKBody
*/
type VolumePruneOKBody struct {

	// space reclaimed
	SpaceReclaimed uint64 `json:"SpaceReclaimed,omitempty"`

	// volumes deleted
	VolumesDeleted []string `json:"VolumesDeleted"`
}

// Validate validates this volume prune o k body
func (o *VolumePruneOKBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume prune o k body based on context it is used
func (o *VolumePruneOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumePruneOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumePruneOKBody) UnmarshalBinary(b []byte) error {
	var res VolumePruneOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
