// Code generated by go-swagger; DO NOT EDIT.

package secrets_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// NewSecretCreateParams creates a new SecretCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecretCreateParams() *SecretCreateParams {
	return &SecretCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecretCreateParamsWithTimeout creates a new SecretCreateParams object
// with the ability to set a timeout on a request.
func NewSecretCreateParamsWithTimeout(timeout time.Duration) *SecretCreateParams {
	return &SecretCreateParams{
		timeout: timeout,
	}
}

// NewSecretCreateParamsWithContext creates a new SecretCreateParams object
// with the ability to set a context for a request.
func NewSecretCreateParamsWithContext(ctx context.Context) *SecretCreateParams {
	return &SecretCreateParams{
		Context: ctx,
	}
}

// NewSecretCreateParamsWithHTTPClient creates a new SecretCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecretCreateParamsWithHTTPClient(client *http.Client) *SecretCreateParams {
	return &SecretCreateParams{
		HTTPClient: client,
	}
}

/*
SecretCreateParams contains all the parameters to send to the API endpoint

	for the secret create operation.

	Typically these are written to a http.Request.
*/
type SecretCreateParams struct {

	/* Create.

	   attributes for creating a secret

	*/
	Create *models.SecretCreateRequest

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the secret create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecretCreateParams) WithDefaults() *SecretCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the secret create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecretCreateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the secret create params
func (o *SecretCreateParams) WithTimeout(timeout time.Duration) *SecretCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the secret create params
func (o *SecretCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the secret create params
func (o *SecretCreateParams) WithContext(ctx context.Context) *SecretCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the secret create params
func (o *SecretCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the secret create params
func (o *SecretCreateParams) WithHTTPClient(client *http.Client) *SecretCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the secret create params
func (o *SecretCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCreate adds the create to the secret create params
func (o *SecretCreateParams) WithCreate(create *models.SecretCreateRequest) *SecretCreateParams {
	o.SetCreate(create)
	return o
}

// SetCreate adds the create to the secret create params
func (o *SecretCreateParams) SetCreate(create *models.SecretCreateRequest) {
	o.Create = create
}

// WriteToRequest writes these params to a swagger request
func (o *SecretCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Create != nil {
		if err := r.SetBodyParam(o.Create); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
