// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"io"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewImageImportLibpodParams creates a new ImageImportLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewImageImportLibpodParams() *ImageImportLibpodParams {
	return &ImageImportLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewImageImportLibpodParamsWithTimeout creates a new ImageImportLibpodParams object
// with the ability to set a timeout on a request.
func NewImageImportLibpodParamsWithTimeout(timeout time.Duration) *ImageImportLibpodParams {
	return &ImageImportLibpodParams{
		timeout: timeout,
	}
}

// NewImageImportLibpodParamsWithContext creates a new ImageImportLibpodParams object
// with the ability to set a context for a request.
func NewImageImportLibpodParamsWithContext(ctx context.Context) *ImageImportLibpodParams {
	return &ImageImportLibpodParams{
		Context: ctx,
	}
}

// NewImageImportLibpodParamsWithHTTPClient creates a new ImageImportLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewImageImportLibpodParamsWithHTTPClient(client *http.Client) *ImageImportLibpodParams {
	return &ImageImportLibpodParams{
		HTTPClient: client,
	}
}

/*
ImageImportLibpodParams contains all the parameters to send to the API endpoint

	for the image import libpod operation.

	Typically these are written to a http.Request.
*/
type ImageImportLibpodParams struct {

	// ContentType.
	//
	// Default: "application/x-tar"
	ContentType *string

	/* Changes.

	   Apply the following possible instructions to the created image: CMD | ENTRYPOINT | ENV | EXPOSE | LABEL | STOPSIGNAL | USER | VOLUME | WORKDIR.  JSON encoded string
	*/
	Changes []string

	/* Message.

	   Set commit message for imported image
	*/
	Message *string

	/* Reference.

	   Optional Name[:TAG] for the image
	*/
	Reference *string

	/* Upload.

	   tarball for imported image

	   Format: binary
	*/
	Upload io.ReadCloser

	/* URL.

	   Load image from the specified URL
	*/
	URL *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the image import libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageImportLibpodParams) WithDefaults() *ImageImportLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the image import libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageImportLibpodParams) SetDefaults() {
	var (
		contentTypeDefault = string("application/x-tar")
	)

	val := ImageImportLibpodParams{
		ContentType: &contentTypeDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the image import libpod params
func (o *ImageImportLibpodParams) WithTimeout(timeout time.Duration) *ImageImportLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the image import libpod params
func (o *ImageImportLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the image import libpod params
func (o *ImageImportLibpodParams) WithContext(ctx context.Context) *ImageImportLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the image import libpod params
func (o *ImageImportLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the image import libpod params
func (o *ImageImportLibpodParams) WithHTTPClient(client *http.Client) *ImageImportLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the image import libpod params
func (o *ImageImportLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContentType adds the contentType to the image import libpod params
func (o *ImageImportLibpodParams) WithContentType(contentType *string) *ImageImportLibpodParams {
	o.SetContentType(contentType)
	return o
}

// SetContentType adds the contentType to the image import libpod params
func (o *ImageImportLibpodParams) SetContentType(contentType *string) {
	o.ContentType = contentType
}

// WithChanges adds the changes to the image import libpod params
func (o *ImageImportLibpodParams) WithChanges(changes []string) *ImageImportLibpodParams {
	o.SetChanges(changes)
	return o
}

// SetChanges adds the changes to the image import libpod params
func (o *ImageImportLibpodParams) SetChanges(changes []string) {
	o.Changes = changes
}

// WithMessage adds the message to the image import libpod params
func (o *ImageImportLibpodParams) WithMessage(message *string) *ImageImportLibpodParams {
	o.SetMessage(message)
	return o
}

// SetMessage adds the message to the image import libpod params
func (o *ImageImportLibpodParams) SetMessage(message *string) {
	o.Message = message
}

// WithReference adds the reference to the image import libpod params
func (o *ImageImportLibpodParams) WithReference(reference *string) *ImageImportLibpodParams {
	o.SetReference(reference)
	return o
}

// SetReference adds the reference to the image import libpod params
func (o *ImageImportLibpodParams) SetReference(reference *string) {
	o.Reference = reference
}

// WithUpload adds the upload to the image import libpod params
func (o *ImageImportLibpodParams) WithUpload(upload io.ReadCloser) *ImageImportLibpodParams {
	o.SetUpload(upload)
	return o
}

// SetUpload adds the upload to the image import libpod params
func (o *ImageImportLibpodParams) SetUpload(upload io.ReadCloser) {
	o.Upload = upload
}

// WithURL adds the url to the image import libpod params
func (o *ImageImportLibpodParams) WithURL(url *string) *ImageImportLibpodParams {
	o.SetURL(url)
	return o
}

// SetURL adds the url to the image import libpod params
func (o *ImageImportLibpodParams) SetURL(url *string) {
	o.URL = url
}

// WriteToRequest writes these params to a swagger request
func (o *ImageImportLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContentType != nil {

		// header param Content-Type
		if err := r.SetHeaderParam("Content-Type", *o.ContentType); err != nil {
			return err
		}
	}

	if o.Changes != nil {

		// binding items for changes
		joinedChanges := o.bindParamChanges(reg)

		// query array param changes
		if err := r.SetQueryParam("changes", joinedChanges...); err != nil {
			return err
		}
	}

	if o.Message != nil {

		// query param message
		var qrMessage string

		if o.Message != nil {
			qrMessage = *o.Message
		}
		qMessage := qrMessage
		if qMessage != "" {

			if err := r.SetQueryParam("message", qMessage); err != nil {
				return err
			}
		}
	}

	if o.Reference != nil {

		// query param reference
		var qrReference string

		if o.Reference != nil {
			qrReference = *o.Reference
		}
		qReference := qrReference
		if qReference != "" {

			if err := r.SetQueryParam("reference", qReference); err != nil {
				return err
			}
		}
	}
	if o.Upload != nil {
		if err := r.SetBodyParam(o.Upload); err != nil {
			return err
		}
	}

	if o.URL != nil {

		// query param url
		var qrURL string

		if o.URL != nil {
			qrURL = *o.URL
		}
		qURL := qrURL
		if qURL != "" {

			if err := r.SetQueryParam("url", qURL); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamImageImportLibpod binds the parameter changes
func (o *ImageImportLibpodParams) bindParamChanges(formats strfmt.Registry) []string {
	changesIR := o.Changes

	var changesIC []string
	for _, changesIIR := range changesIR { // explode []string

		changesIIV := changesIIR // string as string
		changesIC = append(changesIC, changesIIV)
	}

	// items.CollectionFormat: ""
	changesIS := swag.JoinByFormat(changesIC, "")

	return changesIS
}
