// Code generated by go-swagger; DO NOT EDIT.

package pods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// PodExistsLibpodReader is a Reader for the PodExistsLibpod structure.
type PodExistsLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PodExistsLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewPodExistsLibpodNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewPodExistsLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPodExistsLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewPodExistsLibpodNoContent creates a PodExistsLibpodNoContent with default headers values
func NewPodExistsLibpodNoContent() *PodExistsLibpodNoContent {
	return &PodExistsLibpodNoContent{}
}

/*
PodExistsLibpodNoContent describes a response with status code 204, with default header values.

pod exists
*/
type PodExistsLibpodNoContent struct {
}

// IsSuccess returns true when this pod exists libpod no content response has a 2xx status code
func (o *PodExistsLibpodNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this pod exists libpod no content response has a 3xx status code
func (o *PodExistsLibpodNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod exists libpod no content response has a 4xx status code
func (o *PodExistsLibpodNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod exists libpod no content response has a 5xx status code
func (o *PodExistsLibpodNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this pod exists libpod no content response a status code equal to that given
func (o *PodExistsLibpodNoContent) IsCode(code int) bool {
	return code == 204
}

func (o *PodExistsLibpodNoContent) Error() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/exists][%d] podExistsLibpodNoContent ", 204)
}

func (o *PodExistsLibpodNoContent) String() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/exists][%d] podExistsLibpodNoContent ", 204)
}

func (o *PodExistsLibpodNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPodExistsLibpodNotFound creates a PodExistsLibpodNotFound with default headers values
func NewPodExistsLibpodNotFound() *PodExistsLibpodNotFound {
	return &PodExistsLibpodNotFound{}
}

/*
PodExistsLibpodNotFound describes a response with status code 404, with default header values.

No such pod
*/
type PodExistsLibpodNotFound struct {
	Payload *PodExistsLibpodNotFoundBody
}

// IsSuccess returns true when this pod exists libpod not found response has a 2xx status code
func (o *PodExistsLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod exists libpod not found response has a 3xx status code
func (o *PodExistsLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod exists libpod not found response has a 4xx status code
func (o *PodExistsLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this pod exists libpod not found response has a 5xx status code
func (o *PodExistsLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this pod exists libpod not found response a status code equal to that given
func (o *PodExistsLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *PodExistsLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/exists][%d] podExistsLibpodNotFound  %+v", 404, o.Payload)
}

func (o *PodExistsLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/exists][%d] podExistsLibpodNotFound  %+v", 404, o.Payload)
}

func (o *PodExistsLibpodNotFound) GetPayload() *PodExistsLibpodNotFoundBody {
	return o.Payload
}

func (o *PodExistsLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodExistsLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodExistsLibpodInternalServerError creates a PodExistsLibpodInternalServerError with default headers values
func NewPodExistsLibpodInternalServerError() *PodExistsLibpodInternalServerError {
	return &PodExistsLibpodInternalServerError{}
}

/*
PodExistsLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type PodExistsLibpodInternalServerError struct {
	Payload *PodExistsLibpodInternalServerErrorBody
}

// IsSuccess returns true when this pod exists libpod internal server error response has a 2xx status code
func (o *PodExistsLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod exists libpod internal server error response has a 3xx status code
func (o *PodExistsLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod exists libpod internal server error response has a 4xx status code
func (o *PodExistsLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod exists libpod internal server error response has a 5xx status code
func (o *PodExistsLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this pod exists libpod internal server error response a status code equal to that given
func (o *PodExistsLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *PodExistsLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/exists][%d] podExistsLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodExistsLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/exists][%d] podExistsLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodExistsLibpodInternalServerError) GetPayload() *PodExistsLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *PodExistsLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodExistsLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PodExistsLibpodInternalServerErrorBody pod exists libpod internal server error body
swagger:model PodExistsLibpodInternalServerErrorBody
*/
type PodExistsLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod exists libpod internal server error body
func (o *PodExistsLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod exists libpod internal server error body based on context it is used
func (o *PodExistsLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodExistsLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodExistsLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res PodExistsLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PodExistsLibpodNotFoundBody pod exists libpod not found body
swagger:model PodExistsLibpodNotFoundBody
*/
type PodExistsLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod exists libpod not found body
func (o *PodExistsLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod exists libpod not found body based on context it is used
func (o *PodExistsLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodExistsLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodExistsLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res PodExistsLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
