// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerBasicConfig ContainerBasicConfig contains the basic parts of a container.
//
// swagger:model ContainerBasicConfig
type ContainerBasicConfig struct {

	// Annotations are key-value options passed into the container runtime
	// that can be used to trigger special behavior.
	// Optional.
	Annotations map[string]string `json:"annotations,omitempty"`

	// Command is the container's command.
	// If not given and Image is specified, this will be populated by the
	// image's configuration.
	// Optional.
	Command []string `json:"command"`

	// ConmonPidFile is a path at which a PID file for Conmon will be
	// placed.
	// If not given, a default location will be used.
	// Optional.
	ConmonPidFile string `json:"conmon_pid_file,omitempty"`

	// ContainerCreateCommand is the command that was used to create this
	// container.
	// This will be shown in the output of Inspect() on the container, and
	// may also be used by some tools that wish to recreate the container
	// (e.g. `podman generate systemd --new`).
	// Optional.
	ContainerCreateCommand []string `json:"containerCreateCommand"`

	// DependencyContainers is an array of containers this container
	// depends on. Dependency containers must be started before this
	// container. Dependencies can be specified by name or full/partial ID.
	// Optional.
	DependencyContainers []string `json:"dependencyContainers"`

	// Entrypoint is the container's entrypoint.
	// If not given and Image is specified, this will be populated by the
	// image's configuration.
	// Optional.
	Entrypoint []string `json:"entrypoint"`

	// Env is a set of environment variables that will be set in the
	// container.
	// Optional.
	Env map[string]string `json:"env,omitempty"`

	// EnvHost indicates that the host environment should be added to container
	// Optional.
	EnvHost bool `json:"env_host,omitempty"`

	// EnvSecrets are secrets that will be set as environment variables
	// Optional.
	EnvSecrets map[string]string `json:"secret_env,omitempty"`

	// EnvHTTPProxy indicates that the http host proxy environment variables
	// should be added to container
	// Optional.
	HTTPProxy bool `json:"httpproxy,omitempty"`

	// HostUses is a list of host usernames or UIDs to add to the container
	// etc/passwd file
	HostUsers []string `json:"hostusers"`

	// Hostname is the container's hostname. If not set, the hostname will
	// not be modified (if UtsNS is not private) or will be set to the
	// container ID (if UtsNS is private).
	// Conflicts with UtsNS if UtsNS is not set to private.
	// Optional.
	Hostname string `json:"hostname,omitempty"`

	// InitContainerType describes if this container is an init container
	// and if so, what type: always or once
	InitContainerType string `json:"init_container_type,omitempty"`

	// Labels are key-value pairs that are used to add metadata to
	// containers.
	// Optional.
	Labels map[string]string `json:"labels,omitempty"`

	// Name is the name the container will be given.
	// If no name is provided, one will be randomly generated.
	// Optional.
	Name string `json:"name,omitempty"`

	// Namespace is the libpod namespace the container will be placed in.
	// Optional.
	Namespace string `json:"namespace,omitempty"`

	// OCIRuntime is the name of the OCI runtime that will be used to create
	// the container.
	// If not specified, the default will be used.
	// Optional.
	OCIRuntime string `json:"oci_runtime,omitempty"`

	// Passwd is a container run option that determines if we are validating users/groups before running the container
	Passwd bool `json:"manage_password,omitempty"`

	// Pod is the ID of the pod the container will join.
	// Optional.
	Pod string `json:"pod,omitempty"`

	// RawImageName is the user-specified and unprocessed input referring
	// to a local or a remote image.
	RawImageName string `json:"raw_image_name,omitempty"`

	// Remove indicates if the container should be removed once it has been started
	// and exits
	Remove bool `json:"remove,omitempty"`

	// RestartPolicy is the container's restart policy - an action which
	// will be taken when the container exits.
	// If not given, the default policy, which does nothing, will be used.
	// Optional.
	RestartPolicy string `json:"restart_policy,omitempty"`

	// RestartRetries is the number of attempts that will be made to restart
	// the container.
	// Only available when RestartPolicy is set to "on-failure".
	// Optional.
	RestartRetries uint64 `json:"restart_tries,omitempty"`

	// Determine how to handle the NOTIFY_SOCKET - do we participate or pass it through
	// "container" - let the OCI runtime deal with it, advertise conmon's MAINPID
	// "conmon-only" - advertise conmon's MAINPID, send READY when started, don't pass to OCI
	// "ignore" - unset NOTIFY_SOCKET
	SdNotifyMode string `json:"sdnotifyMode,omitempty"`

	// Stdin is whether the container will keep its STDIN open.
	Stdin bool `json:"stdin,omitempty"`

	// StopTimeout is a timeout between the container's stop signal being
	// sent and SIGKILL being sent.
	// If not provided, the default will be used.
	// If 0 is used, stop signal will not be sent, and SIGKILL will be sent
	// instead.
	// Optional.
	StopTimeout uint64 `json:"stop_timeout,omitempty"`

	// Sysctl sets kernel parameters for the container
	Sysctl map[string]string `json:"sysctl,omitempty"`

	// Systemd is whether the container will be started in systemd mode.
	// Valid options are "true", "false", and "always".
	// "true" enables this mode only if the binary run in the container is
	// sbin/init or systemd. "always" unconditionally enables systemd mode.
	// "false" unconditionally disables systemd mode.
	// If enabled, mounts and stop signal will be modified.
	// If set to "always" or set to "true" and conditionally triggered,
	// conflicts with StopSignal.
	// If not specified, "false" will be assumed.
	// Optional.
	Systemd string `json:"systemd,omitempty"`

	// Terminal is whether the container will create a PTY.
	// Optional.
	Terminal bool `json:"terminal,omitempty"`

	// Timeout is a maximum time in seconds the container will run before
	// main process is sent SIGKILL.
	// If 0 is used, signal will not be sent. Container can run indefinitely
	// Optional.
	Timeout uint64 `json:"timeout,omitempty"`

	// Timezone is the timezone inside the container.
	// Local means it has the same timezone as the host machine
	// Optional.
	Timezone string `json:"timezone,omitempty"`

	// UnsetEnv unsets the specified default environment variables from the image or from buildin or containers.conf
	// Optional.
	UnsetEnv []string `json:"unsetenv"`

	// UnsetEnvAll unsetall default environment variables from the image or from buildin or containers.conf
	// UnsetEnvAll unsets all default environment variables from the image or from buildin
	// Optional.
	UnsetEnvAll bool `json:"unsetenvall,omitempty"`

	// log configuration
	LogConfiguration *LogConfig `json:"log_configuration,omitempty"`

	// personality
	Personality *LinuxPersonality `json:"personality,omitempty"`

	// pidns
	Pidns *Namespace `json:"pidns,omitempty"`

	// stop signal
	StopSignal Signal `json:"stop_signal,omitempty"`

	// utsns
	Utsns *Namespace `json:"utsns,omitempty"`
}

// Validate validates this container basic config
func (m *ContainerBasicConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLogConfiguration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePersonality(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePidns(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStopSignal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUtsns(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerBasicConfig) validateLogConfiguration(formats strfmt.Registry) error {
	if swag.IsZero(m.LogConfiguration) { // not required
		return nil
	}

	if m.LogConfiguration != nil {
		if err := m.LogConfiguration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("log_configuration")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("log_configuration")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerBasicConfig) validatePersonality(formats strfmt.Registry) error {
	if swag.IsZero(m.Personality) { // not required
		return nil
	}

	if m.Personality != nil {
		if err := m.Personality.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("personality")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("personality")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerBasicConfig) validatePidns(formats strfmt.Registry) error {
	if swag.IsZero(m.Pidns) { // not required
		return nil
	}

	if m.Pidns != nil {
		if err := m.Pidns.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pidns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pidns")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerBasicConfig) validateStopSignal(formats strfmt.Registry) error {
	if swag.IsZero(m.StopSignal) { // not required
		return nil
	}

	if err := m.StopSignal.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("stop_signal")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("stop_signal")
		}
		return err
	}

	return nil
}

func (m *ContainerBasicConfig) validateUtsns(formats strfmt.Registry) error {
	if swag.IsZero(m.Utsns) { // not required
		return nil
	}

	if m.Utsns != nil {
		if err := m.Utsns.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("utsns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("utsns")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container basic config based on the context it is used
func (m *ContainerBasicConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLogConfiguration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePersonality(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePidns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStopSignal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUtsns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerBasicConfig) contextValidateLogConfiguration(ctx context.Context, formats strfmt.Registry) error {

	if m.LogConfiguration != nil {
		if err := m.LogConfiguration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("log_configuration")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("log_configuration")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerBasicConfig) contextValidatePersonality(ctx context.Context, formats strfmt.Registry) error {

	if m.Personality != nil {
		if err := m.Personality.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("personality")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("personality")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerBasicConfig) contextValidatePidns(ctx context.Context, formats strfmt.Registry) error {

	if m.Pidns != nil {
		if err := m.Pidns.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pidns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pidns")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerBasicConfig) contextValidateStopSignal(ctx context.Context, formats strfmt.Registry) error {

	if err := m.StopSignal.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("stop_signal")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("stop_signal")
		}
		return err
	}

	return nil
}

func (m *ContainerBasicConfig) contextValidateUtsns(ctx context.Context, formats strfmt.Registry) error {

	if m.Utsns != nil {
		if err := m.Utsns.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("utsns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("utsns")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerBasicConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerBasicConfig) UnmarshalBinary(b []byte) error {
	var res ContainerBasicConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
