// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ContainerResourceConfig ContainerResourceConfig contains information on container resource limits.
//
// swagger:model ContainerResourceConfig
type ContainerResourceConfig struct {

	// CPU period of the cpuset, determined by --cpus
	CPUPeriod uint64 `json:"cpu_period,omitempty"`

	// CPU quota of the cpuset, determined by --cpus
	CPUQuota int64 `json:"cpu_quota,omitempty"`

	// CgroupConf are key-value options passed into the container runtime
	// that are used to configure cgroup v2.
	// Optional.
	CgroupConf map[string]string `json:"unified,omitempty"`

	// OOMScoreAdj adjusts the score used by the OOM killer to determine
	// processes to kill for the container's process.
	// Optional.
	OOMScoreAdj int64 `json:"oom_score_adj,omitempty"`

	// Rlimits are POSIX rlimits to apply to the container.
	// Optional.
	Rlimits []*POSIXRlimit `json:"r_limits"`

	// IO read rate limit per cgroup per device, bytes per second
	ThrottleReadBpsDevice map[string]LinuxThrottleDevice `json:"throttleReadBpsDevice,omitempty"`

	// IO read rate limit per cgroup per device, IO per second
	ThrottleReadIOPSDevice map[string]LinuxThrottleDevice `json:"throttleReadIOPSDevice,omitempty"`

	// IO write rate limit per cgroup per device, bytes per second
	ThrottleWriteBpsDevice map[string]LinuxThrottleDevice `json:"throttleWriteBpsDevice,omitempty"`

	// IO write rate limit per cgroup per device, IO per second
	ThrottleWriteIOPSDevice map[string]LinuxThrottleDevice `json:"throttleWriteIOPSDevice,omitempty"`

	// Weight per cgroup per device, can override BlkioWeight
	WeightDevice map[string]LinuxWeightDevice `json:"weightDevice,omitempty"`

	// resource limits
	ResourceLimits *LinuxResources `json:"resource_limits,omitempty"`
}

// Validate validates this container resource config
func (m *ContainerResourceConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRlimits(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThrottleReadBpsDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThrottleReadIOPSDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThrottleWriteBpsDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThrottleWriteIOPSDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWeightDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResourceLimits(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResourceConfig) validateRlimits(formats strfmt.Registry) error {
	if swag.IsZero(m.Rlimits) { // not required
		return nil
	}

	for i := 0; i < len(m.Rlimits); i++ {
		if swag.IsZero(m.Rlimits[i]) { // not required
			continue
		}

		if m.Rlimits[i] != nil {
			if err := m.Rlimits[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("r_limits" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("r_limits" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResourceConfig) validateThrottleReadBpsDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.ThrottleReadBpsDevice) { // not required
		return nil
	}

	for k := range m.ThrottleReadBpsDevice {

		if err := validate.Required("throttleReadBpsDevice"+"."+k, "body", m.ThrottleReadBpsDevice[k]); err != nil {
			return err
		}
		if val, ok := m.ThrottleReadBpsDevice[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("throttleReadBpsDevice" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("throttleReadBpsDevice" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResourceConfig) validateThrottleReadIOPSDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.ThrottleReadIOPSDevice) { // not required
		return nil
	}

	for k := range m.ThrottleReadIOPSDevice {

		if err := validate.Required("throttleReadIOPSDevice"+"."+k, "body", m.ThrottleReadIOPSDevice[k]); err != nil {
			return err
		}
		if val, ok := m.ThrottleReadIOPSDevice[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("throttleReadIOPSDevice" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("throttleReadIOPSDevice" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResourceConfig) validateThrottleWriteBpsDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.ThrottleWriteBpsDevice) { // not required
		return nil
	}

	for k := range m.ThrottleWriteBpsDevice {

		if err := validate.Required("throttleWriteBpsDevice"+"."+k, "body", m.ThrottleWriteBpsDevice[k]); err != nil {
			return err
		}
		if val, ok := m.ThrottleWriteBpsDevice[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("throttleWriteBpsDevice" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("throttleWriteBpsDevice" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResourceConfig) validateThrottleWriteIOPSDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.ThrottleWriteIOPSDevice) { // not required
		return nil
	}

	for k := range m.ThrottleWriteIOPSDevice {

		if err := validate.Required("throttleWriteIOPSDevice"+"."+k, "body", m.ThrottleWriteIOPSDevice[k]); err != nil {
			return err
		}
		if val, ok := m.ThrottleWriteIOPSDevice[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("throttleWriteIOPSDevice" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("throttleWriteIOPSDevice" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResourceConfig) validateWeightDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.WeightDevice) { // not required
		return nil
	}

	for k := range m.WeightDevice {

		if err := validate.Required("weightDevice"+"."+k, "body", m.WeightDevice[k]); err != nil {
			return err
		}
		if val, ok := m.WeightDevice[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("weightDevice" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("weightDevice" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResourceConfig) validateResourceLimits(formats strfmt.Registry) error {
	if swag.IsZero(m.ResourceLimits) { // not required
		return nil
	}

	if m.ResourceLimits != nil {
		if err := m.ResourceLimits.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource_limits")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource_limits")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container resource config based on the context it is used
func (m *ContainerResourceConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRlimits(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThrottleReadBpsDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThrottleReadIOPSDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThrottleWriteBpsDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThrottleWriteIOPSDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWeightDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResourceLimits(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResourceConfig) contextValidateRlimits(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Rlimits); i++ {

		if m.Rlimits[i] != nil {
			if err := m.Rlimits[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("r_limits" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("r_limits" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResourceConfig) contextValidateThrottleReadBpsDevice(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.ThrottleReadBpsDevice {

		if val, ok := m.ThrottleReadBpsDevice[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResourceConfig) contextValidateThrottleReadIOPSDevice(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.ThrottleReadIOPSDevice {

		if val, ok := m.ThrottleReadIOPSDevice[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResourceConfig) contextValidateThrottleWriteBpsDevice(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.ThrottleWriteBpsDevice {

		if val, ok := m.ThrottleWriteBpsDevice[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResourceConfig) contextValidateThrottleWriteIOPSDevice(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.ThrottleWriteIOPSDevice {

		if val, ok := m.ThrottleWriteIOPSDevice[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResourceConfig) contextValidateWeightDevice(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.WeightDevice {

		if val, ok := m.WeightDevice[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResourceConfig) contextValidateResourceLimits(ctx context.Context, formats strfmt.Registry) error {

	if m.ResourceLimits != nil {
		if err := m.ResourceLimits.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource_limits")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource_limits")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResourceConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResourceConfig) UnmarshalBinary(b []byte) error {
	var res ContainerResourceConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
