/*
Copyright 2021 The Skupper Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v2alpha1

import (
	v2alpha1 "github.com/skupperproject/skupper/pkg/apis/skupper/v2alpha1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// LinkLister helps list Links.
// All objects returned here must be treated as read-only.
type LinkLister interface {
	// List lists all Links in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.Link, err error)
	// Links returns an object that can list and get Links.
	Links(namespace string) LinkNamespaceLister
	LinkListerExpansion
}

// linkLister implements the LinkLister interface.
type linkLister struct {
	listers.ResourceIndexer[*v2alpha1.Link]
}

// NewLinkLister returns a new LinkLister.
func NewLinkLister(indexer cache.Indexer) LinkLister {
	return &linkLister{listers.New[*v2alpha1.Link](indexer, v2alpha1.Resource("link"))}
}

// Links returns an object that can list and get Links.
func (s *linkLister) Links(namespace string) LinkNamespaceLister {
	return linkNamespaceLister{listers.NewNamespaced[*v2alpha1.Link](s.ResourceIndexer, namespace)}
}

// LinkNamespaceLister helps list and get Links.
// All objects returned here must be treated as read-only.
type LinkNamespaceLister interface {
	// List lists all Links in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.Link, err error)
	// Get retrieves the Link from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v2alpha1.Link, error)
	LinkNamespaceListerExpansion
}

// linkNamespaceLister implements the LinkNamespaceLister
// interface.
type linkNamespaceLister struct {
	listers.ResourceIndexer[*v2alpha1.Link]
}
