/*
Copyright 2021 The Skupper Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v2alpha1

import (
	v2alpha1 "github.com/skupperproject/skupper/pkg/apis/skupper/v2alpha1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// RouterAccessLister helps list RouterAccesses.
// All objects returned here must be treated as read-only.
type RouterAccessLister interface {
	// List lists all RouterAccesses in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.RouterAccess, err error)
	// RouterAccesses returns an object that can list and get RouterAccesses.
	RouterAccesses(namespace string) RouterAccessNamespaceLister
	RouterAccessListerExpansion
}

// routerAccessLister implements the RouterAccessLister interface.
type routerAccessLister struct {
	listers.ResourceIndexer[*v2alpha1.RouterAccess]
}

// NewRouterAccessLister returns a new RouterAccessLister.
func NewRouterAccessLister(indexer cache.Indexer) RouterAccessLister {
	return &routerAccessLister{listers.New[*v2alpha1.RouterAccess](indexer, v2alpha1.Resource("routeraccess"))}
}

// RouterAccesses returns an object that can list and get RouterAccesses.
func (s *routerAccessLister) RouterAccesses(namespace string) RouterAccessNamespaceLister {
	return routerAccessNamespaceLister{listers.NewNamespaced[*v2alpha1.RouterAccess](s.ResourceIndexer, namespace)}
}

// RouterAccessNamespaceLister helps list and get RouterAccesses.
// All objects returned here must be treated as read-only.
type RouterAccessNamespaceLister interface {
	// List lists all RouterAccesses in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.RouterAccess, err error)
	// Get retrieves the RouterAccess from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v2alpha1.RouterAccess, error)
	RouterAccessNamespaceListerExpansion
}

// routerAccessNamespaceLister implements the RouterAccessNamespaceLister
// interface.
type routerAccessNamespaceLister struct {
	listers.ResourceIndexer[*v2alpha1.RouterAccess]
}
