// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewContainerArchiveParams creates a new ContainerArchiveParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerArchiveParams() *ContainerArchiveParams {
	return &ContainerArchiveParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerArchiveParamsWithTimeout creates a new ContainerArchiveParams object
// with the ability to set a timeout on a request.
func NewContainerArchiveParamsWithTimeout(timeout time.Duration) *ContainerArchiveParams {
	return &ContainerArchiveParams{
		timeout: timeout,
	}
}

// NewContainerArchiveParamsWithContext creates a new ContainerArchiveParams object
// with the ability to set a context for a request.
func NewContainerArchiveParamsWithContext(ctx context.Context) *ContainerArchiveParams {
	return &ContainerArchiveParams{
		Context: ctx,
	}
}

// NewContainerArchiveParamsWithHTTPClient creates a new ContainerArchiveParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerArchiveParamsWithHTTPClient(client *http.Client) *ContainerArchiveParams {
	return &ContainerArchiveParams{
		HTTPClient: client,
	}
}

/*
ContainerArchiveParams contains all the parameters to send to the API endpoint

	for the container archive operation.

	Typically these are written to a http.Request.
*/
type ContainerArchiveParams struct {

	/* Name.

	   container name or id
	*/
	Name string

	/* Path.

	   Path to a directory in the container to extract
	*/
	Path string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container archive params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerArchiveParams) WithDefaults() *ContainerArchiveParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container archive params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerArchiveParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the container archive params
func (o *ContainerArchiveParams) WithTimeout(timeout time.Duration) *ContainerArchiveParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container archive params
func (o *ContainerArchiveParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container archive params
func (o *ContainerArchiveParams) WithContext(ctx context.Context) *ContainerArchiveParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container archive params
func (o *ContainerArchiveParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container archive params
func (o *ContainerArchiveParams) WithHTTPClient(client *http.Client) *ContainerArchiveParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container archive params
func (o *ContainerArchiveParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the container archive params
func (o *ContainerArchiveParams) WithName(name string) *ContainerArchiveParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container archive params
func (o *ContainerArchiveParams) SetName(name string) {
	o.Name = name
}

// WithPath adds the path to the container archive params
func (o *ContainerArchiveParams) WithPath(path string) *ContainerArchiveParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the container archive params
func (o *ContainerArchiveParams) SetPath(path string) {
	o.Path = path
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerArchiveParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// query param path
	qrPath := o.Path
	qPath := qrPath
	if qPath != "" {

		if err := r.SetQueryParam("path", qPath); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
