// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerListReader is a Reader for the ContainerList structure.
type ContainerListReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerListReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewContainerListOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewContainerListBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerListInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerListOK creates a ContainerListOK with default headers values
func NewContainerListOK() *ContainerListOK {
	return &ContainerListOK{}
}

/*
ContainerListOK describes a response with status code 200, with default header values.

List Containers
*/
type ContainerListOK struct {
	Payload interface{}
}

// IsSuccess returns true when this container list o k response has a 2xx status code
func (o *ContainerListOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container list o k response has a 3xx status code
func (o *ContainerListOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container list o k response has a 4xx status code
func (o *ContainerListOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this container list o k response has a 5xx status code
func (o *ContainerListOK) IsServerError() bool {
	return false
}

// IsCode returns true when this container list o k response a status code equal to that given
func (o *ContainerListOK) IsCode(code int) bool {
	return code == 200
}

func (o *ContainerListOK) Error() string {
	return fmt.Sprintf("[GET /containers/json][%d] containerListOK  %+v", 200, o.Payload)
}

func (o *ContainerListOK) String() string {
	return fmt.Sprintf("[GET /containers/json][%d] containerListOK  %+v", 200, o.Payload)
}

func (o *ContainerListOK) GetPayload() interface{} {
	return o.Payload
}

func (o *ContainerListOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerListBadRequest creates a ContainerListBadRequest with default headers values
func NewContainerListBadRequest() *ContainerListBadRequest {
	return &ContainerListBadRequest{}
}

/*
ContainerListBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type ContainerListBadRequest struct {
	Payload *ContainerListBadRequestBody
}

// IsSuccess returns true when this container list bad request response has a 2xx status code
func (o *ContainerListBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container list bad request response has a 3xx status code
func (o *ContainerListBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container list bad request response has a 4xx status code
func (o *ContainerListBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this container list bad request response has a 5xx status code
func (o *ContainerListBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this container list bad request response a status code equal to that given
func (o *ContainerListBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *ContainerListBadRequest) Error() string {
	return fmt.Sprintf("[GET /containers/json][%d] containerListBadRequest  %+v", 400, o.Payload)
}

func (o *ContainerListBadRequest) String() string {
	return fmt.Sprintf("[GET /containers/json][%d] containerListBadRequest  %+v", 400, o.Payload)
}

func (o *ContainerListBadRequest) GetPayload() *ContainerListBadRequestBody {
	return o.Payload
}

func (o *ContainerListBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerListBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerListInternalServerError creates a ContainerListInternalServerError with default headers values
func NewContainerListInternalServerError() *ContainerListInternalServerError {
	return &ContainerListInternalServerError{}
}

/*
ContainerListInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerListInternalServerError struct {
	Payload *ContainerListInternalServerErrorBody
}

// IsSuccess returns true when this container list internal server error response has a 2xx status code
func (o *ContainerListInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container list internal server error response has a 3xx status code
func (o *ContainerListInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container list internal server error response has a 4xx status code
func (o *ContainerListInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container list internal server error response has a 5xx status code
func (o *ContainerListInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container list internal server error response a status code equal to that given
func (o *ContainerListInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerListInternalServerError) Error() string {
	return fmt.Sprintf("[GET /containers/json][%d] containerListInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerListInternalServerError) String() string {
	return fmt.Sprintf("[GET /containers/json][%d] containerListInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerListInternalServerError) GetPayload() *ContainerListInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerListInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerListInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerListBadRequestBody container list bad request body
swagger:model ContainerListBadRequestBody
*/
type ContainerListBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container list bad request body
func (o *ContainerListBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container list bad request body based on context it is used
func (o *ContainerListBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerListBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerListBadRequestBody) UnmarshalBinary(b []byte) error {
	var res ContainerListBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerListInternalServerErrorBody container list internal server error body
swagger:model ContainerListInternalServerErrorBody
*/
type ContainerListInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container list internal server error body
func (o *ContainerListInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container list internal server error body based on context it is used
func (o *ContainerListInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerListInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerListInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerListInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
