// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerAttachReader is a Reader for the ContainerAttach structure.
type ContainerAttachReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerAttachReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 101:
		result := NewContainerAttachSwitchingProtocols()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 400:
		result := NewContainerAttachBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewContainerAttachNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerAttachInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerAttachSwitchingProtocols creates a ContainerAttachSwitchingProtocols with default headers values
func NewContainerAttachSwitchingProtocols() *ContainerAttachSwitchingProtocols {
	return &ContainerAttachSwitchingProtocols{}
}

/*
ContainerAttachSwitchingProtocols describes a response with status code 101, with default header values.

No error, connection has been hijacked for transporting streams.
*/
type ContainerAttachSwitchingProtocols struct {
}

// IsSuccess returns true when this container attach switching protocols response has a 2xx status code
func (o *ContainerAttachSwitchingProtocols) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container attach switching protocols response has a 3xx status code
func (o *ContainerAttachSwitchingProtocols) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container attach switching protocols response has a 4xx status code
func (o *ContainerAttachSwitchingProtocols) IsClientError() bool {
	return false
}

// IsServerError returns true when this container attach switching protocols response has a 5xx status code
func (o *ContainerAttachSwitchingProtocols) IsServerError() bool {
	return false
}

// IsCode returns true when this container attach switching protocols response a status code equal to that given
func (o *ContainerAttachSwitchingProtocols) IsCode(code int) bool {
	return code == 101
}

func (o *ContainerAttachSwitchingProtocols) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/attach][%d] containerAttachSwitchingProtocols ", 101)
}

func (o *ContainerAttachSwitchingProtocols) String() string {
	return fmt.Sprintf("[POST /containers/{name}/attach][%d] containerAttachSwitchingProtocols ", 101)
}

func (o *ContainerAttachSwitchingProtocols) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerAttachBadRequest creates a ContainerAttachBadRequest with default headers values
func NewContainerAttachBadRequest() *ContainerAttachBadRequest {
	return &ContainerAttachBadRequest{}
}

/*
ContainerAttachBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type ContainerAttachBadRequest struct {
	Payload *ContainerAttachBadRequestBody
}

// IsSuccess returns true when this container attach bad request response has a 2xx status code
func (o *ContainerAttachBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container attach bad request response has a 3xx status code
func (o *ContainerAttachBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container attach bad request response has a 4xx status code
func (o *ContainerAttachBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this container attach bad request response has a 5xx status code
func (o *ContainerAttachBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this container attach bad request response a status code equal to that given
func (o *ContainerAttachBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *ContainerAttachBadRequest) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/attach][%d] containerAttachBadRequest  %+v", 400, o.Payload)
}

func (o *ContainerAttachBadRequest) String() string {
	return fmt.Sprintf("[POST /containers/{name}/attach][%d] containerAttachBadRequest  %+v", 400, o.Payload)
}

func (o *ContainerAttachBadRequest) GetPayload() *ContainerAttachBadRequestBody {
	return o.Payload
}

func (o *ContainerAttachBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerAttachBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerAttachNotFound creates a ContainerAttachNotFound with default headers values
func NewContainerAttachNotFound() *ContainerAttachNotFound {
	return &ContainerAttachNotFound{}
}

/*
ContainerAttachNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerAttachNotFound struct {
	Payload *ContainerAttachNotFoundBody
}

// IsSuccess returns true when this container attach not found response has a 2xx status code
func (o *ContainerAttachNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container attach not found response has a 3xx status code
func (o *ContainerAttachNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container attach not found response has a 4xx status code
func (o *ContainerAttachNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container attach not found response has a 5xx status code
func (o *ContainerAttachNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container attach not found response a status code equal to that given
func (o *ContainerAttachNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerAttachNotFound) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/attach][%d] containerAttachNotFound  %+v", 404, o.Payload)
}

func (o *ContainerAttachNotFound) String() string {
	return fmt.Sprintf("[POST /containers/{name}/attach][%d] containerAttachNotFound  %+v", 404, o.Payload)
}

func (o *ContainerAttachNotFound) GetPayload() *ContainerAttachNotFoundBody {
	return o.Payload
}

func (o *ContainerAttachNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerAttachNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerAttachInternalServerError creates a ContainerAttachInternalServerError with default headers values
func NewContainerAttachInternalServerError() *ContainerAttachInternalServerError {
	return &ContainerAttachInternalServerError{}
}

/*
ContainerAttachInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerAttachInternalServerError struct {
	Payload *ContainerAttachInternalServerErrorBody
}

// IsSuccess returns true when this container attach internal server error response has a 2xx status code
func (o *ContainerAttachInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container attach internal server error response has a 3xx status code
func (o *ContainerAttachInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container attach internal server error response has a 4xx status code
func (o *ContainerAttachInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container attach internal server error response has a 5xx status code
func (o *ContainerAttachInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container attach internal server error response a status code equal to that given
func (o *ContainerAttachInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerAttachInternalServerError) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/attach][%d] containerAttachInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerAttachInternalServerError) String() string {
	return fmt.Sprintf("[POST /containers/{name}/attach][%d] containerAttachInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerAttachInternalServerError) GetPayload() *ContainerAttachInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerAttachInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerAttachInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerAttachBadRequestBody container attach bad request body
swagger:model ContainerAttachBadRequestBody
*/
type ContainerAttachBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container attach bad request body
func (o *ContainerAttachBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container attach bad request body based on context it is used
func (o *ContainerAttachBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerAttachBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerAttachBadRequestBody) UnmarshalBinary(b []byte) error {
	var res ContainerAttachBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerAttachInternalServerErrorBody container attach internal server error body
swagger:model ContainerAttachInternalServerErrorBody
*/
type ContainerAttachInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container attach internal server error body
func (o *ContainerAttachInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container attach internal server error body based on context it is used
func (o *ContainerAttachInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerAttachInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerAttachInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerAttachInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerAttachNotFoundBody container attach not found body
swagger:model ContainerAttachNotFoundBody
*/
type ContainerAttachNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container attach not found body
func (o *ContainerAttachNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container attach not found body based on context it is used
func (o *ContainerAttachNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerAttachNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerAttachNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerAttachNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
