// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/skupperproject/skupper-libpod/v4/models"
)

// NewContainerCreateParams creates a new ContainerCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerCreateParams() *ContainerCreateParams {
	return &ContainerCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerCreateParamsWithTimeout creates a new ContainerCreateParams object
// with the ability to set a timeout on a request.
func NewContainerCreateParamsWithTimeout(timeout time.Duration) *ContainerCreateParams {
	return &ContainerCreateParams{
		timeout: timeout,
	}
}

// NewContainerCreateParamsWithContext creates a new ContainerCreateParams object
// with the ability to set a context for a request.
func NewContainerCreateParamsWithContext(ctx context.Context) *ContainerCreateParams {
	return &ContainerCreateParams{
		Context: ctx,
	}
}

// NewContainerCreateParamsWithHTTPClient creates a new ContainerCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerCreateParamsWithHTTPClient(client *http.Client) *ContainerCreateParams {
	return &ContainerCreateParams{
		HTTPClient: client,
	}
}

/*
ContainerCreateParams contains all the parameters to send to the API endpoint

	for the container create operation.

	Typically these are written to a http.Request.
*/
type ContainerCreateParams struct {

	/* Body.

	   Container to create
	*/
	Body *models.CreateContainerConfig

	/* Name.

	   container name
	*/
	Name *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerCreateParams) WithDefaults() *ContainerCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerCreateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the container create params
func (o *ContainerCreateParams) WithTimeout(timeout time.Duration) *ContainerCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container create params
func (o *ContainerCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container create params
func (o *ContainerCreateParams) WithContext(ctx context.Context) *ContainerCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container create params
func (o *ContainerCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container create params
func (o *ContainerCreateParams) WithHTTPClient(client *http.Client) *ContainerCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container create params
func (o *ContainerCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the container create params
func (o *ContainerCreateParams) WithBody(body *models.CreateContainerConfig) *ContainerCreateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the container create params
func (o *ContainerCreateParams) SetBody(body *models.CreateContainerConfig) {
	o.Body = body
}

// WithName adds the name to the container create params
func (o *ContainerCreateParams) WithName(name *string) *ContainerCreateParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container create params
func (o *ContainerCreateParams) SetName(name *string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
