// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContainerDeleteParams creates a new ContainerDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerDeleteParams() *ContainerDeleteParams {
	return &ContainerDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerDeleteParamsWithTimeout creates a new ContainerDeleteParams object
// with the ability to set a timeout on a request.
func NewContainerDeleteParamsWithTimeout(timeout time.Duration) *ContainerDeleteParams {
	return &ContainerDeleteParams{
		timeout: timeout,
	}
}

// NewContainerDeleteParamsWithContext creates a new ContainerDeleteParams object
// with the ability to set a context for a request.
func NewContainerDeleteParamsWithContext(ctx context.Context) *ContainerDeleteParams {
	return &ContainerDeleteParams{
		Context: ctx,
	}
}

// NewContainerDeleteParamsWithHTTPClient creates a new ContainerDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerDeleteParamsWithHTTPClient(client *http.Client) *ContainerDeleteParams {
	return &ContainerDeleteParams{
		HTTPClient: client,
	}
}

/*
ContainerDeleteParams contains all the parameters to send to the API endpoint

	for the container delete operation.

	Typically these are written to a http.Request.
*/
type ContainerDeleteParams struct {

	/* Force.

	   If the container is running, kill it before removing it.
	*/
	Force *bool

	/* Link.

	   not supported
	*/
	Link *bool

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* V.

	   Remove the volumes associated with the container.
	*/
	V *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerDeleteParams) WithDefaults() *ContainerDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerDeleteParams) SetDefaults() {
	var (
		forceDefault = bool(false)

		vDefault = bool(false)
	)

	val := ContainerDeleteParams{
		Force: &forceDefault,
		V:     &vDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the container delete params
func (o *ContainerDeleteParams) WithTimeout(timeout time.Duration) *ContainerDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container delete params
func (o *ContainerDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container delete params
func (o *ContainerDeleteParams) WithContext(ctx context.Context) *ContainerDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container delete params
func (o *ContainerDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container delete params
func (o *ContainerDeleteParams) WithHTTPClient(client *http.Client) *ContainerDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container delete params
func (o *ContainerDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithForce adds the force to the container delete params
func (o *ContainerDeleteParams) WithForce(force *bool) *ContainerDeleteParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the container delete params
func (o *ContainerDeleteParams) SetForce(force *bool) {
	o.Force = force
}

// WithLink adds the link to the container delete params
func (o *ContainerDeleteParams) WithLink(link *bool) *ContainerDeleteParams {
	o.SetLink(link)
	return o
}

// SetLink adds the link to the container delete params
func (o *ContainerDeleteParams) SetLink(link *bool) {
	o.Link = link
}

// WithName adds the name to the container delete params
func (o *ContainerDeleteParams) WithName(name string) *ContainerDeleteParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container delete params
func (o *ContainerDeleteParams) SetName(name string) {
	o.Name = name
}

// WithV adds the v to the container delete params
func (o *ContainerDeleteParams) WithV(v *bool) *ContainerDeleteParams {
	o.SetV(v)
	return o
}

// SetV adds the v to the container delete params
func (o *ContainerDeleteParams) SetV(v *bool) {
	o.V = v
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Force != nil {

		// query param force
		var qrForce bool

		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {

			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}
	}

	if o.Link != nil {

		// query param link
		var qrLink bool

		if o.Link != nil {
			qrLink = *o.Link
		}
		qLink := swag.FormatBool(qrLink)
		if qLink != "" {

			if err := r.SetQueryParam("link", qLink); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.V != nil {

		// query param v
		var qrV bool

		if o.V != nil {
			qrV = *o.V
		}
		qV := swag.FormatBool(qrV)
		if qV != "" {

			if err := r.SetQueryParam("v", qV); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
