// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContainerInspectParams creates a new ContainerInspectParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerInspectParams() *ContainerInspectParams {
	return &ContainerInspectParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerInspectParamsWithTimeout creates a new ContainerInspectParams object
// with the ability to set a timeout on a request.
func NewContainerInspectParamsWithTimeout(timeout time.Duration) *ContainerInspectParams {
	return &ContainerInspectParams{
		timeout: timeout,
	}
}

// NewContainerInspectParamsWithContext creates a new ContainerInspectParams object
// with the ability to set a context for a request.
func NewContainerInspectParamsWithContext(ctx context.Context) *ContainerInspectParams {
	return &ContainerInspectParams{
		Context: ctx,
	}
}

// NewContainerInspectParamsWithHTTPClient creates a new ContainerInspectParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerInspectParamsWithHTTPClient(client *http.Client) *ContainerInspectParams {
	return &ContainerInspectParams{
		HTTPClient: client,
	}
}

/*
ContainerInspectParams contains all the parameters to send to the API endpoint

	for the container inspect operation.

	Typically these are written to a http.Request.
*/
type ContainerInspectParams struct {

	/* Name.

	   the name or id of the container
	*/
	Name string

	/* Size.

	   include the size of the container
	*/
	Size *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container inspect params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerInspectParams) WithDefaults() *ContainerInspectParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container inspect params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerInspectParams) SetDefaults() {
	var (
		sizeDefault = bool(false)
	)

	val := ContainerInspectParams{
		Size: &sizeDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the container inspect params
func (o *ContainerInspectParams) WithTimeout(timeout time.Duration) *ContainerInspectParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container inspect params
func (o *ContainerInspectParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container inspect params
func (o *ContainerInspectParams) WithContext(ctx context.Context) *ContainerInspectParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container inspect params
func (o *ContainerInspectParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container inspect params
func (o *ContainerInspectParams) WithHTTPClient(client *http.Client) *ContainerInspectParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container inspect params
func (o *ContainerInspectParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the container inspect params
func (o *ContainerInspectParams) WithName(name string) *ContainerInspectParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container inspect params
func (o *ContainerInspectParams) SetName(name string) {
	o.Name = name
}

// WithSize adds the size to the container inspect params
func (o *ContainerInspectParams) WithSize(size *bool) *ContainerInspectParams {
	o.SetSize(size)
	return o
}

// SetSize adds the size to the container inspect params
func (o *ContainerInspectParams) SetSize(size *bool) {
	o.Size = size
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerInspectParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Size != nil {

		// query param size
		var qrSize bool

		if o.Size != nil {
			qrSize = *o.Size
		}
		qSize := swag.FormatBool(qrSize)
		if qSize != "" {

			if err := r.SetQueryParam("size", qSize); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
