// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerKillReader is a Reader for the ContainerKill structure.
type ContainerKillReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerKillReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewContainerKillNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerKillNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewContainerKillConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerKillInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerKillNoContent creates a ContainerKillNoContent with default headers values
func NewContainerKillNoContent() *ContainerKillNoContent {
	return &ContainerKillNoContent{}
}

/*
ContainerKillNoContent describes a response with status code 204, with default header values.

no error
*/
type ContainerKillNoContent struct {
}

// IsSuccess returns true when this container kill no content response has a 2xx status code
func (o *ContainerKillNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container kill no content response has a 3xx status code
func (o *ContainerKillNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container kill no content response has a 4xx status code
func (o *ContainerKillNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this container kill no content response has a 5xx status code
func (o *ContainerKillNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this container kill no content response a status code equal to that given
func (o *ContainerKillNoContent) IsCode(code int) bool {
	return code == 204
}

func (o *ContainerKillNoContent) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/kill][%d] containerKillNoContent ", 204)
}

func (o *ContainerKillNoContent) String() string {
	return fmt.Sprintf("[POST /containers/{name}/kill][%d] containerKillNoContent ", 204)
}

func (o *ContainerKillNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerKillNotFound creates a ContainerKillNotFound with default headers values
func NewContainerKillNotFound() *ContainerKillNotFound {
	return &ContainerKillNotFound{}
}

/*
ContainerKillNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerKillNotFound struct {
	Payload *ContainerKillNotFoundBody
}

// IsSuccess returns true when this container kill not found response has a 2xx status code
func (o *ContainerKillNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container kill not found response has a 3xx status code
func (o *ContainerKillNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container kill not found response has a 4xx status code
func (o *ContainerKillNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container kill not found response has a 5xx status code
func (o *ContainerKillNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container kill not found response a status code equal to that given
func (o *ContainerKillNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerKillNotFound) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/kill][%d] containerKillNotFound  %+v", 404, o.Payload)
}

func (o *ContainerKillNotFound) String() string {
	return fmt.Sprintf("[POST /containers/{name}/kill][%d] containerKillNotFound  %+v", 404, o.Payload)
}

func (o *ContainerKillNotFound) GetPayload() *ContainerKillNotFoundBody {
	return o.Payload
}

func (o *ContainerKillNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerKillNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerKillConflict creates a ContainerKillConflict with default headers values
func NewContainerKillConflict() *ContainerKillConflict {
	return &ContainerKillConflict{}
}

/*
ContainerKillConflict describes a response with status code 409, with default header values.

Conflict error in operation
*/
type ContainerKillConflict struct {
	Payload *ContainerKillConflictBody
}

// IsSuccess returns true when this container kill conflict response has a 2xx status code
func (o *ContainerKillConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container kill conflict response has a 3xx status code
func (o *ContainerKillConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container kill conflict response has a 4xx status code
func (o *ContainerKillConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this container kill conflict response has a 5xx status code
func (o *ContainerKillConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this container kill conflict response a status code equal to that given
func (o *ContainerKillConflict) IsCode(code int) bool {
	return code == 409
}

func (o *ContainerKillConflict) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/kill][%d] containerKillConflict  %+v", 409, o.Payload)
}

func (o *ContainerKillConflict) String() string {
	return fmt.Sprintf("[POST /containers/{name}/kill][%d] containerKillConflict  %+v", 409, o.Payload)
}

func (o *ContainerKillConflict) GetPayload() *ContainerKillConflictBody {
	return o.Payload
}

func (o *ContainerKillConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerKillConflictBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerKillInternalServerError creates a ContainerKillInternalServerError with default headers values
func NewContainerKillInternalServerError() *ContainerKillInternalServerError {
	return &ContainerKillInternalServerError{}
}

/*
ContainerKillInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerKillInternalServerError struct {
	Payload *ContainerKillInternalServerErrorBody
}

// IsSuccess returns true when this container kill internal server error response has a 2xx status code
func (o *ContainerKillInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container kill internal server error response has a 3xx status code
func (o *ContainerKillInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container kill internal server error response has a 4xx status code
func (o *ContainerKillInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container kill internal server error response has a 5xx status code
func (o *ContainerKillInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container kill internal server error response a status code equal to that given
func (o *ContainerKillInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerKillInternalServerError) Error() string {
	return fmt.Sprintf("[POST /containers/{name}/kill][%d] containerKillInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerKillInternalServerError) String() string {
	return fmt.Sprintf("[POST /containers/{name}/kill][%d] containerKillInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerKillInternalServerError) GetPayload() *ContainerKillInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerKillInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerKillInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerKillConflictBody container kill conflict body
swagger:model ContainerKillConflictBody
*/
type ContainerKillConflictBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container kill conflict body
func (o *ContainerKillConflictBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container kill conflict body based on context it is used
func (o *ContainerKillConflictBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerKillConflictBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerKillConflictBody) UnmarshalBinary(b []byte) error {
	var res ContainerKillConflictBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerKillInternalServerErrorBody container kill internal server error body
swagger:model ContainerKillInternalServerErrorBody
*/
type ContainerKillInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container kill internal server error body
func (o *ContainerKillInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container kill internal server error body based on context it is used
func (o *ContainerKillInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerKillInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerKillInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerKillInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerKillNotFoundBody container kill not found body
swagger:model ContainerKillNotFoundBody
*/
type ContainerKillNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container kill not found body
func (o *ContainerKillNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container kill not found body based on context it is used
func (o *ContainerKillNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerKillNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerKillNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerKillNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
