// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContainerResizeParams creates a new ContainerResizeParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerResizeParams() *ContainerResizeParams {
	return &ContainerResizeParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerResizeParamsWithTimeout creates a new ContainerResizeParams object
// with the ability to set a timeout on a request.
func NewContainerResizeParamsWithTimeout(timeout time.Duration) *ContainerResizeParams {
	return &ContainerResizeParams{
		timeout: timeout,
	}
}

// NewContainerResizeParamsWithContext creates a new ContainerResizeParams object
// with the ability to set a context for a request.
func NewContainerResizeParamsWithContext(ctx context.Context) *ContainerResizeParams {
	return &ContainerResizeParams{
		Context: ctx,
	}
}

// NewContainerResizeParamsWithHTTPClient creates a new ContainerResizeParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerResizeParamsWithHTTPClient(client *http.Client) *ContainerResizeParams {
	return &ContainerResizeParams{
		HTTPClient: client,
	}
}

/*
ContainerResizeParams contains all the parameters to send to the API endpoint

	for the container resize operation.

	Typically these are written to a http.Request.
*/
type ContainerResizeParams struct {

	/* H.

	   Height to set for the terminal, in characters
	*/
	H *int64

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* Running.

	   Ignore containers not running errors
	*/
	Running *bool

	/* W.

	   Width to set for the terminal, in characters
	*/
	W *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container resize params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerResizeParams) WithDefaults() *ContainerResizeParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container resize params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerResizeParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the container resize params
func (o *ContainerResizeParams) WithTimeout(timeout time.Duration) *ContainerResizeParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container resize params
func (o *ContainerResizeParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container resize params
func (o *ContainerResizeParams) WithContext(ctx context.Context) *ContainerResizeParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container resize params
func (o *ContainerResizeParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container resize params
func (o *ContainerResizeParams) WithHTTPClient(client *http.Client) *ContainerResizeParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container resize params
func (o *ContainerResizeParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithH adds the h to the container resize params
func (o *ContainerResizeParams) WithH(h *int64) *ContainerResizeParams {
	o.SetH(h)
	return o
}

// SetH adds the h to the container resize params
func (o *ContainerResizeParams) SetH(h *int64) {
	o.H = h
}

// WithName adds the name to the container resize params
func (o *ContainerResizeParams) WithName(name string) *ContainerResizeParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container resize params
func (o *ContainerResizeParams) SetName(name string) {
	o.Name = name
}

// WithRunning adds the running to the container resize params
func (o *ContainerResizeParams) WithRunning(running *bool) *ContainerResizeParams {
	o.SetRunning(running)
	return o
}

// SetRunning adds the running to the container resize params
func (o *ContainerResizeParams) SetRunning(running *bool) {
	o.Running = running
}

// WithW adds the w to the container resize params
func (o *ContainerResizeParams) WithW(w *int64) *ContainerResizeParams {
	o.SetW(w)
	return o
}

// SetW adds the w to the container resize params
func (o *ContainerResizeParams) SetW(w *int64) {
	o.W = w
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerResizeParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.H != nil {

		// query param h
		var qrH int64

		if o.H != nil {
			qrH = *o.H
		}
		qH := swag.FormatInt64(qrH)
		if qH != "" {

			if err := r.SetQueryParam("h", qH); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Running != nil {

		// query param running
		var qrRunning bool

		if o.Running != nil {
			qrRunning = *o.Running
		}
		qRunning := swag.FormatBool(qrRunning)
		if qRunning != "" {

			if err := r.SetQueryParam("running", qRunning); err != nil {
				return err
			}
		}
	}

	if o.W != nil {

		// query param w
		var qrW int64

		if o.W != nil {
			qrW = *o.W
		}
		qW := swag.FormatInt64(qrW)
		if qW != "" {

			if err := r.SetQueryParam("w", qW); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
