// Code generated by go-swagger; DO NOT EDIT.

package exec_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ExecResizeReader is a Reader for the ExecResize structure.
type ExecResizeReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ExecResizeReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewExecResizeCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewExecResizeNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewExecResizeInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewExecResizeCreated creates a ExecResizeCreated with default headers values
func NewExecResizeCreated() *ExecResizeCreated {
	return &ExecResizeCreated{}
}

/*
ExecResizeCreated describes a response with status code 201, with default header values.

no error
*/
type ExecResizeCreated struct {
}

// IsSuccess returns true when this exec resize created response has a 2xx status code
func (o *ExecResizeCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this exec resize created response has a 3xx status code
func (o *ExecResizeCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this exec resize created response has a 4xx status code
func (o *ExecResizeCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this exec resize created response has a 5xx status code
func (o *ExecResizeCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this exec resize created response a status code equal to that given
func (o *ExecResizeCreated) IsCode(code int) bool {
	return code == 201
}

func (o *ExecResizeCreated) Error() string {
	return fmt.Sprintf("[POST /exec/{id}/resize][%d] execResizeCreated ", 201)
}

func (o *ExecResizeCreated) String() string {
	return fmt.Sprintf("[POST /exec/{id}/resize][%d] execResizeCreated ", 201)
}

func (o *ExecResizeCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewExecResizeNotFound creates a ExecResizeNotFound with default headers values
func NewExecResizeNotFound() *ExecResizeNotFound {
	return &ExecResizeNotFound{}
}

/*
ExecResizeNotFound describes a response with status code 404, with default header values.

No such exec instance
*/
type ExecResizeNotFound struct {
	Payload *ExecResizeNotFoundBody
}

// IsSuccess returns true when this exec resize not found response has a 2xx status code
func (o *ExecResizeNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this exec resize not found response has a 3xx status code
func (o *ExecResizeNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this exec resize not found response has a 4xx status code
func (o *ExecResizeNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this exec resize not found response has a 5xx status code
func (o *ExecResizeNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this exec resize not found response a status code equal to that given
func (o *ExecResizeNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ExecResizeNotFound) Error() string {
	return fmt.Sprintf("[POST /exec/{id}/resize][%d] execResizeNotFound  %+v", 404, o.Payload)
}

func (o *ExecResizeNotFound) String() string {
	return fmt.Sprintf("[POST /exec/{id}/resize][%d] execResizeNotFound  %+v", 404, o.Payload)
}

func (o *ExecResizeNotFound) GetPayload() *ExecResizeNotFoundBody {
	return o.Payload
}

func (o *ExecResizeNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ExecResizeNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewExecResizeInternalServerError creates a ExecResizeInternalServerError with default headers values
func NewExecResizeInternalServerError() *ExecResizeInternalServerError {
	return &ExecResizeInternalServerError{}
}

/*
ExecResizeInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ExecResizeInternalServerError struct {
	Payload *ExecResizeInternalServerErrorBody
}

// IsSuccess returns true when this exec resize internal server error response has a 2xx status code
func (o *ExecResizeInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this exec resize internal server error response has a 3xx status code
func (o *ExecResizeInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this exec resize internal server error response has a 4xx status code
func (o *ExecResizeInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this exec resize internal server error response has a 5xx status code
func (o *ExecResizeInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this exec resize internal server error response a status code equal to that given
func (o *ExecResizeInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ExecResizeInternalServerError) Error() string {
	return fmt.Sprintf("[POST /exec/{id}/resize][%d] execResizeInternalServerError  %+v", 500, o.Payload)
}

func (o *ExecResizeInternalServerError) String() string {
	return fmt.Sprintf("[POST /exec/{id}/resize][%d] execResizeInternalServerError  %+v", 500, o.Payload)
}

func (o *ExecResizeInternalServerError) GetPayload() *ExecResizeInternalServerErrorBody {
	return o.Payload
}

func (o *ExecResizeInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ExecResizeInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ExecResizeInternalServerErrorBody exec resize internal server error body
swagger:model ExecResizeInternalServerErrorBody
*/
type ExecResizeInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this exec resize internal server error body
func (o *ExecResizeInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this exec resize internal server error body based on context it is used
func (o *ExecResizeInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ExecResizeInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ExecResizeInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ExecResizeInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ExecResizeNotFoundBody exec resize not found body
swagger:model ExecResizeNotFoundBody
*/
type ExecResizeNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this exec resize not found body
func (o *ExecResizeNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this exec resize not found body based on context it is used
func (o *ExecResizeNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ExecResizeNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ExecResizeNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ExecResizeNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
