// Code generated by go-swagger; DO NOT EDIT.

package networks_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNetworkInspectParams creates a new NetworkInspectParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetworkInspectParams() *NetworkInspectParams {
	return &NetworkInspectParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetworkInspectParamsWithTimeout creates a new NetworkInspectParams object
// with the ability to set a timeout on a request.
func NewNetworkInspectParamsWithTimeout(timeout time.Duration) *NetworkInspectParams {
	return &NetworkInspectParams{
		timeout: timeout,
	}
}

// NewNetworkInspectParamsWithContext creates a new NetworkInspectParams object
// with the ability to set a context for a request.
func NewNetworkInspectParamsWithContext(ctx context.Context) *NetworkInspectParams {
	return &NetworkInspectParams{
		Context: ctx,
	}
}

// NewNetworkInspectParamsWithHTTPClient creates a new NetworkInspectParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetworkInspectParamsWithHTTPClient(client *http.Client) *NetworkInspectParams {
	return &NetworkInspectParams{
		HTTPClient: client,
	}
}

/*
NetworkInspectParams contains all the parameters to send to the API endpoint

	for the network inspect operation.

	Typically these are written to a http.Request.
*/
type NetworkInspectParams struct {

	/* Name.

	   the name of the network
	*/
	Name string

	/* Scope.

	   Filter the network by scope (swarm, global, or local)
	*/
	Scope *string

	/* Verbose.

	   Detailed inspect output for troubleshooting
	*/
	Verbose *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the network inspect params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkInspectParams) WithDefaults() *NetworkInspectParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the network inspect params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkInspectParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the network inspect params
func (o *NetworkInspectParams) WithTimeout(timeout time.Duration) *NetworkInspectParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the network inspect params
func (o *NetworkInspectParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the network inspect params
func (o *NetworkInspectParams) WithContext(ctx context.Context) *NetworkInspectParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the network inspect params
func (o *NetworkInspectParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the network inspect params
func (o *NetworkInspectParams) WithHTTPClient(client *http.Client) *NetworkInspectParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the network inspect params
func (o *NetworkInspectParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the network inspect params
func (o *NetworkInspectParams) WithName(name string) *NetworkInspectParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the network inspect params
func (o *NetworkInspectParams) SetName(name string) {
	o.Name = name
}

// WithScope adds the scope to the network inspect params
func (o *NetworkInspectParams) WithScope(scope *string) *NetworkInspectParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the network inspect params
func (o *NetworkInspectParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithVerbose adds the verbose to the network inspect params
func (o *NetworkInspectParams) WithVerbose(verbose *bool) *NetworkInspectParams {
	o.SetVerbose(verbose)
	return o
}

// SetVerbose adds the verbose to the network inspect params
func (o *NetworkInspectParams) SetVerbose(verbose *bool) {
	o.Verbose = verbose
}

// WriteToRequest writes these params to a swagger request
func (o *NetworkInspectParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.Verbose != nil {

		// query param verbose
		var qrVerbose bool

		if o.Verbose != nil {
			qrVerbose = *o.Verbose
		}
		qVerbose := swag.FormatBool(qrVerbose)
		if qVerbose != "" {

			if err := r.SetQueryParam("verbose", qVerbose); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
