// Code generated by go-swagger; DO NOT EDIT.

package volumes_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewVolumeListParams creates a new VolumeListParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVolumeListParams() *VolumeListParams {
	return &VolumeListParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVolumeListParamsWithTimeout creates a new VolumeListParams object
// with the ability to set a timeout on a request.
func NewVolumeListParamsWithTimeout(timeout time.Duration) *VolumeListParams {
	return &VolumeListParams{
		timeout: timeout,
	}
}

// NewVolumeListParamsWithContext creates a new VolumeListParams object
// with the ability to set a context for a request.
func NewVolumeListParamsWithContext(ctx context.Context) *VolumeListParams {
	return &VolumeListParams{
		Context: ctx,
	}
}

// NewVolumeListParamsWithHTTPClient creates a new VolumeListParams object
// with the ability to set a custom HTTPClient for a request.
func NewVolumeListParamsWithHTTPClient(client *http.Client) *VolumeListParams {
	return &VolumeListParams{
		HTTPClient: client,
	}
}

/*
VolumeListParams contains all the parameters to send to the API endpoint

	for the volume list operation.

	Typically these are written to a http.Request.
*/
type VolumeListParams struct {

	/* Filters.

	     JSON encoded value of the filters (a map[string][]string) to process on the volumes list. Available filters:
	  - driver=<volume-driver-name> Matches volumes based on their driver.
	  - label=<key> or label=<key>:<value> Matches volumes based on the presence of a label alone or a label and a value.
	  - name=<volume-name> Matches all of volume name.
	  - `until=<timestamp>` List volumes created before this timestamp. The `<timestamp>` can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. `10m`, `1h30m`) computed relative to the daemon machine’s time.

	Note:
	  The boolean `dangling` filter is not yet implemented for this endpoint.

	*/
	Filters *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the volume list params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VolumeListParams) WithDefaults() *VolumeListParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the volume list params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VolumeListParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the volume list params
func (o *VolumeListParams) WithTimeout(timeout time.Duration) *VolumeListParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the volume list params
func (o *VolumeListParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the volume list params
func (o *VolumeListParams) WithContext(ctx context.Context) *VolumeListParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the volume list params
func (o *VolumeListParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the volume list params
func (o *VolumeListParams) WithHTTPClient(client *http.Client) *VolumeListParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the volume list params
func (o *VolumeListParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilters adds the filters to the volume list params
func (o *VolumeListParams) WithFilters(filters *string) *VolumeListParams {
	o.SetFilters(filters)
	return o
}

// SetFilters adds the filters to the volume list params
func (o *VolumeListParams) SetFilters(filters *string) {
	o.Filters = filters
}

// WriteToRequest writes these params to a swagger request
func (o *VolumeListParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filters != nil {

		// query param filters
		var qrFilters string

		if o.Filters != nil {
			qrFilters = *o.Filters
		}
		qFilters := qrFilters
		if qFilters != "" {

			if err := r.SetQueryParam("filters", qFilters); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
