// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HostConfig HostConfig the non-portable Config structure of a container.
//
// Here, "non-portable" means "dependent of the host we are running on".
// Portable information *should* appear in Config.
//
// swagger:model HostConfig
type HostConfig struct {

	// auto remove
	AutoRemove bool `json:"AutoRemove,omitempty"`

	// Applicable to all platforms
	Binds []string `json:"Binds"`

	// blkio device read bps
	BlkioDeviceReadBps []*ThrottleDevice `json:"BlkioDeviceReadBps"`

	// blkio device read i ops
	BlkioDeviceReadIOps []*ThrottleDevice `json:"BlkioDeviceReadIOps"`

	// blkio device write bps
	BlkioDeviceWriteBps []*ThrottleDevice `json:"BlkioDeviceWriteBps"`

	// blkio device write i ops
	BlkioDeviceWriteIOps []*ThrottleDevice `json:"BlkioDeviceWriteIOps"`

	// blkio weight
	BlkioWeight uint16 `json:"BlkioWeight,omitempty"`

	// blkio weight device
	BlkioWeightDevice []*WeightDevice `json:"BlkioWeightDevice"`

	// Applicable to Windows
	CPUCount int64 `json:"CpuCount,omitempty"`

	// CPU percent
	CPUPercent int64 `json:"CpuPercent,omitempty"`

	// CPU period
	CPUPeriod int64 `json:"CpuPeriod,omitempty"`

	// CPU quota
	CPUQuota int64 `json:"CpuQuota,omitempty"`

	// CPU realtime period
	CPURealtimePeriod int64 `json:"CpuRealtimePeriod,omitempty"`

	// CPU realtime runtime
	CPURealtimeRuntime int64 `json:"CpuRealtimeRuntime,omitempty"`

	// Applicable to all platforms
	CPUShares int64 `json:"CpuShares,omitempty"`

	// cap add
	CapAdd StrSlice `json:"CapAdd,omitempty"`

	// cap drop
	CapDrop StrSlice `json:"CapDrop,omitempty"`

	// cgroup
	Cgroup CgroupSpec `json:"Cgroup,omitempty"`

	// Applicable to UNIX platforms
	CgroupParent string `json:"CgroupParent,omitempty"`

	// cgroupns mode
	CgroupnsMode CgroupnsMode `json:"CgroupnsMode,omitempty"`

	// Applicable to Windows
	ConsoleSize []uint64 `json:"ConsoleSize"`

	// container ID file
	ContainerIDFile string `json:"ContainerIDFile,omitempty"`

	// cpuset cpus
	CpusetCpus string `json:"CpusetCpus,omitempty"`

	// cpuset mems
	CpusetMems string `json:"CpusetMems,omitempty"`

	// DNS
	DNS []string `json:"Dns"`

	// DNS options
	DNSOptions []string `json:"DnsOptions"`

	// DNS search
	DNSSearch []string `json:"DnsSearch"`

	// device cgroup rules
	DeviceCgroupRules []string `json:"DeviceCgroupRules"`

	// device requests
	DeviceRequests []*DeviceRequest `json:"DeviceRequests"`

	// devices
	Devices []*DeviceMapping `json:"Devices"`

	// extra hosts
	ExtraHosts []string `json:"ExtraHosts"`

	// group add
	GroupAdd []string `json:"GroupAdd"`

	// i o maximum bandwidth
	IOMaximumBandwidth uint64 `json:"IOMaximumBandwidth,omitempty"`

	// i o maximum i ops
	IOMaximumIOps uint64 `json:"IOMaximumIOps,omitempty"`

	// Run a custom init inside the container, if null, use the daemon's configured settings
	Init bool `json:"Init,omitempty"`

	// ipc mode
	IpcMode IpcMode `json:"IpcMode,omitempty"`

	// isolation
	Isolation Isolation `json:"Isolation,omitempty"`

	// kernel memory
	KernelMemory int64 `json:"KernelMemory,omitempty"`

	// kernel memory TCP
	KernelMemoryTCP int64 `json:"KernelMemoryTCP,omitempty"`

	// links
	Links []string `json:"Links"`

	// log config
	LogConfig *LogConfig `json:"LogConfig,omitempty"`

	// MaskedPaths is the list of paths to be masked inside the container (this overrides the default set of paths)
	MaskedPaths []string `json:"MaskedPaths"`

	// memory
	Memory int64 `json:"Memory,omitempty"`

	// memory reservation
	MemoryReservation int64 `json:"MemoryReservation,omitempty"`

	// memory swap
	MemorySwap int64 `json:"MemorySwap,omitempty"`

	// memory swappiness
	MemorySwappiness int64 `json:"MemorySwappiness,omitempty"`

	// Mounts specs used by the container
	Mounts []*Mount `json:"Mounts"`

	// nano c p us
	NanoCPUs int64 `json:"NanoCpus,omitempty"`

	// network mode
	NetworkMode NetworkMode `json:"NetworkMode,omitempty"`

	// oom kill disable
	OomKillDisable bool `json:"OomKillDisable,omitempty"`

	// oom score adj
	OomScoreAdj int64 `json:"OomScoreAdj,omitempty"`

	// pid mode
	PidMode PidMode `json:"PidMode,omitempty"`

	// pids limit
	PidsLimit int64 `json:"PidsLimit,omitempty"`

	// port bindings
	PortBindings PortMap `json:"PortBindings,omitempty"`

	// privileged
	Privileged bool `json:"Privileged,omitempty"`

	// publish all ports
	PublishAllPorts bool `json:"PublishAllPorts,omitempty"`

	// ReadonlyPaths is the list of paths to be set as read-only inside the container (this overrides the default set of paths)
	ReadonlyPaths []string `json:"ReadonlyPaths"`

	// readonly rootfs
	ReadonlyRootfs bool `json:"ReadonlyRootfs,omitempty"`

	// restart policy
	RestartPolicy *RestartPolicy `json:"RestartPolicy,omitempty"`

	// runtime
	Runtime string `json:"Runtime,omitempty"`

	// security opt
	SecurityOpt []string `json:"SecurityOpt"`

	// shm size
	ShmSize int64 `json:"ShmSize,omitempty"`

	// storage opt
	StorageOpt map[string]string `json:"StorageOpt,omitempty"`

	// sysctls
	Sysctls map[string]string `json:"Sysctls,omitempty"`

	// tmpfs
	Tmpfs map[string]string `json:"Tmpfs,omitempty"`

	// u t s mode
	UTSMode UTSMode `json:"UTSMode,omitempty"`

	// ulimits
	Ulimits []*Ulimit `json:"Ulimits"`

	// userns mode
	UsernsMode UsernsMode `json:"UsernsMode,omitempty"`

	// volume driver
	VolumeDriver string `json:"VolumeDriver,omitempty"`

	// volumes from
	VolumesFrom []string `json:"VolumesFrom"`
}

// Validate validates this host config
func (m *HostConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBlkioDeviceReadBps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBlkioDeviceReadIOps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBlkioDeviceWriteBps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBlkioDeviceWriteIOps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBlkioWeightDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCapAdd(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCapDrop(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCgroupnsMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeviceRequests(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDevices(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIpcMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIsolation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMounts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetworkMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePidMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePortBindings(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRestartPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUTSMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUlimits(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsernsMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HostConfig) validateBlkioDeviceReadBps(formats strfmt.Registry) error {
	if swag.IsZero(m.BlkioDeviceReadBps) { // not required
		return nil
	}

	for i := 0; i < len(m.BlkioDeviceReadBps); i++ {
		if swag.IsZero(m.BlkioDeviceReadBps[i]) { // not required
			continue
		}

		if m.BlkioDeviceReadBps[i] != nil {
			if err := m.BlkioDeviceReadBps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceReadBps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceReadBps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) validateBlkioDeviceReadIOps(formats strfmt.Registry) error {
	if swag.IsZero(m.BlkioDeviceReadIOps) { // not required
		return nil
	}

	for i := 0; i < len(m.BlkioDeviceReadIOps); i++ {
		if swag.IsZero(m.BlkioDeviceReadIOps[i]) { // not required
			continue
		}

		if m.BlkioDeviceReadIOps[i] != nil {
			if err := m.BlkioDeviceReadIOps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceReadIOps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceReadIOps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) validateBlkioDeviceWriteBps(formats strfmt.Registry) error {
	if swag.IsZero(m.BlkioDeviceWriteBps) { // not required
		return nil
	}

	for i := 0; i < len(m.BlkioDeviceWriteBps); i++ {
		if swag.IsZero(m.BlkioDeviceWriteBps[i]) { // not required
			continue
		}

		if m.BlkioDeviceWriteBps[i] != nil {
			if err := m.BlkioDeviceWriteBps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceWriteBps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceWriteBps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) validateBlkioDeviceWriteIOps(formats strfmt.Registry) error {
	if swag.IsZero(m.BlkioDeviceWriteIOps) { // not required
		return nil
	}

	for i := 0; i < len(m.BlkioDeviceWriteIOps); i++ {
		if swag.IsZero(m.BlkioDeviceWriteIOps[i]) { // not required
			continue
		}

		if m.BlkioDeviceWriteIOps[i] != nil {
			if err := m.BlkioDeviceWriteIOps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceWriteIOps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceWriteIOps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) validateBlkioWeightDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.BlkioWeightDevice) { // not required
		return nil
	}

	for i := 0; i < len(m.BlkioWeightDevice); i++ {
		if swag.IsZero(m.BlkioWeightDevice[i]) { // not required
			continue
		}

		if m.BlkioWeightDevice[i] != nil {
			if err := m.BlkioWeightDevice[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioWeightDevice" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioWeightDevice" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) validateCapAdd(formats strfmt.Registry) error {
	if swag.IsZero(m.CapAdd) { // not required
		return nil
	}

	if err := m.CapAdd.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("CapAdd")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("CapAdd")
		}
		return err
	}

	return nil
}

func (m *HostConfig) validateCapDrop(formats strfmt.Registry) error {
	if swag.IsZero(m.CapDrop) { // not required
		return nil
	}

	if err := m.CapDrop.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("CapDrop")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("CapDrop")
		}
		return err
	}

	return nil
}

func (m *HostConfig) validateCgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Cgroup) { // not required
		return nil
	}

	if err := m.Cgroup.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Cgroup")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Cgroup")
		}
		return err
	}

	return nil
}

func (m *HostConfig) validateCgroupnsMode(formats strfmt.Registry) error {
	if swag.IsZero(m.CgroupnsMode) { // not required
		return nil
	}

	if err := m.CgroupnsMode.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("CgroupnsMode")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("CgroupnsMode")
		}
		return err
	}

	return nil
}

func (m *HostConfig) validateDeviceRequests(formats strfmt.Registry) error {
	if swag.IsZero(m.DeviceRequests) { // not required
		return nil
	}

	for i := 0; i < len(m.DeviceRequests); i++ {
		if swag.IsZero(m.DeviceRequests[i]) { // not required
			continue
		}

		if m.DeviceRequests[i] != nil {
			if err := m.DeviceRequests[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("DeviceRequests" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("DeviceRequests" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) validateDevices(formats strfmt.Registry) error {
	if swag.IsZero(m.Devices) { // not required
		return nil
	}

	for i := 0; i < len(m.Devices); i++ {
		if swag.IsZero(m.Devices[i]) { // not required
			continue
		}

		if m.Devices[i] != nil {
			if err := m.Devices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Devices" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Devices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) validateIpcMode(formats strfmt.Registry) error {
	if swag.IsZero(m.IpcMode) { // not required
		return nil
	}

	if err := m.IpcMode.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("IpcMode")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("IpcMode")
		}
		return err
	}

	return nil
}

func (m *HostConfig) validateIsolation(formats strfmt.Registry) error {
	if swag.IsZero(m.Isolation) { // not required
		return nil
	}

	if err := m.Isolation.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Isolation")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Isolation")
		}
		return err
	}

	return nil
}

func (m *HostConfig) validateLogConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.LogConfig) { // not required
		return nil
	}

	if m.LogConfig != nil {
		if err := m.LogConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("LogConfig")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("LogConfig")
			}
			return err
		}
	}

	return nil
}

func (m *HostConfig) validateMounts(formats strfmt.Registry) error {
	if swag.IsZero(m.Mounts) { // not required
		return nil
	}

	for i := 0; i < len(m.Mounts); i++ {
		if swag.IsZero(m.Mounts[i]) { // not required
			continue
		}

		if m.Mounts[i] != nil {
			if err := m.Mounts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Mounts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Mounts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) validateNetworkMode(formats strfmt.Registry) error {
	if swag.IsZero(m.NetworkMode) { // not required
		return nil
	}

	if err := m.NetworkMode.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("NetworkMode")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("NetworkMode")
		}
		return err
	}

	return nil
}

func (m *HostConfig) validatePidMode(formats strfmt.Registry) error {
	if swag.IsZero(m.PidMode) { // not required
		return nil
	}

	if err := m.PidMode.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("PidMode")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("PidMode")
		}
		return err
	}

	return nil
}

func (m *HostConfig) validatePortBindings(formats strfmt.Registry) error {
	if swag.IsZero(m.PortBindings) { // not required
		return nil
	}

	if m.PortBindings != nil {
		if err := m.PortBindings.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("PortBindings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("PortBindings")
			}
			return err
		}
	}

	return nil
}

func (m *HostConfig) validateRestartPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.RestartPolicy) { // not required
		return nil
	}

	if m.RestartPolicy != nil {
		if err := m.RestartPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("RestartPolicy")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("RestartPolicy")
			}
			return err
		}
	}

	return nil
}

func (m *HostConfig) validateUTSMode(formats strfmt.Registry) error {
	if swag.IsZero(m.UTSMode) { // not required
		return nil
	}

	if err := m.UTSMode.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("UTSMode")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("UTSMode")
		}
		return err
	}

	return nil
}

func (m *HostConfig) validateUlimits(formats strfmt.Registry) error {
	if swag.IsZero(m.Ulimits) { // not required
		return nil
	}

	for i := 0; i < len(m.Ulimits); i++ {
		if swag.IsZero(m.Ulimits[i]) { // not required
			continue
		}

		if m.Ulimits[i] != nil {
			if err := m.Ulimits[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Ulimits" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Ulimits" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) validateUsernsMode(formats strfmt.Registry) error {
	if swag.IsZero(m.UsernsMode) { // not required
		return nil
	}

	if err := m.UsernsMode.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("UsernsMode")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("UsernsMode")
		}
		return err
	}

	return nil
}

// ContextValidate validate this host config based on the context it is used
func (m *HostConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBlkioDeviceReadBps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlkioDeviceReadIOps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlkioDeviceWriteBps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlkioDeviceWriteIOps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlkioWeightDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCapAdd(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCapDrop(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCgroupnsMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDeviceRequests(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDevices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIpcMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsolation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetworkMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePidMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePortBindings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRestartPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUTSMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUlimits(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsernsMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HostConfig) contextValidateBlkioDeviceReadBps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.BlkioDeviceReadBps); i++ {

		if m.BlkioDeviceReadBps[i] != nil {
			if err := m.BlkioDeviceReadBps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceReadBps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceReadBps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) contextValidateBlkioDeviceReadIOps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.BlkioDeviceReadIOps); i++ {

		if m.BlkioDeviceReadIOps[i] != nil {
			if err := m.BlkioDeviceReadIOps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceReadIOps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceReadIOps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) contextValidateBlkioDeviceWriteBps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.BlkioDeviceWriteBps); i++ {

		if m.BlkioDeviceWriteBps[i] != nil {
			if err := m.BlkioDeviceWriteBps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceWriteBps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceWriteBps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) contextValidateBlkioDeviceWriteIOps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.BlkioDeviceWriteIOps); i++ {

		if m.BlkioDeviceWriteIOps[i] != nil {
			if err := m.BlkioDeviceWriteIOps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioDeviceWriteIOps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioDeviceWriteIOps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) contextValidateBlkioWeightDevice(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.BlkioWeightDevice); i++ {

		if m.BlkioWeightDevice[i] != nil {
			if err := m.BlkioWeightDevice[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("BlkioWeightDevice" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("BlkioWeightDevice" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) contextValidateCapAdd(ctx context.Context, formats strfmt.Registry) error {

	if err := m.CapAdd.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("CapAdd")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("CapAdd")
		}
		return err
	}

	return nil
}

func (m *HostConfig) contextValidateCapDrop(ctx context.Context, formats strfmt.Registry) error {

	if err := m.CapDrop.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("CapDrop")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("CapDrop")
		}
		return err
	}

	return nil
}

func (m *HostConfig) contextValidateCgroup(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Cgroup.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Cgroup")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Cgroup")
		}
		return err
	}

	return nil
}

func (m *HostConfig) contextValidateCgroupnsMode(ctx context.Context, formats strfmt.Registry) error {

	if err := m.CgroupnsMode.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("CgroupnsMode")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("CgroupnsMode")
		}
		return err
	}

	return nil
}

func (m *HostConfig) contextValidateDeviceRequests(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DeviceRequests); i++ {

		if m.DeviceRequests[i] != nil {
			if err := m.DeviceRequests[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("DeviceRequests" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("DeviceRequests" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) contextValidateDevices(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Devices); i++ {

		if m.Devices[i] != nil {
			if err := m.Devices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Devices" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Devices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) contextValidateIpcMode(ctx context.Context, formats strfmt.Registry) error {

	if err := m.IpcMode.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("IpcMode")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("IpcMode")
		}
		return err
	}

	return nil
}

func (m *HostConfig) contextValidateIsolation(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Isolation.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Isolation")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Isolation")
		}
		return err
	}

	return nil
}

func (m *HostConfig) contextValidateLogConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.LogConfig != nil {
		if err := m.LogConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("LogConfig")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("LogConfig")
			}
			return err
		}
	}

	return nil
}

func (m *HostConfig) contextValidateMounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Mounts); i++ {

		if m.Mounts[i] != nil {
			if err := m.Mounts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Mounts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Mounts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) contextValidateNetworkMode(ctx context.Context, formats strfmt.Registry) error {

	if err := m.NetworkMode.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("NetworkMode")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("NetworkMode")
		}
		return err
	}

	return nil
}

func (m *HostConfig) contextValidatePidMode(ctx context.Context, formats strfmt.Registry) error {

	if err := m.PidMode.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("PidMode")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("PidMode")
		}
		return err
	}

	return nil
}

func (m *HostConfig) contextValidatePortBindings(ctx context.Context, formats strfmt.Registry) error {

	if err := m.PortBindings.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("PortBindings")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("PortBindings")
		}
		return err
	}

	return nil
}

func (m *HostConfig) contextValidateRestartPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.RestartPolicy != nil {
		if err := m.RestartPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("RestartPolicy")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("RestartPolicy")
			}
			return err
		}
	}

	return nil
}

func (m *HostConfig) contextValidateUTSMode(ctx context.Context, formats strfmt.Registry) error {

	if err := m.UTSMode.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("UTSMode")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("UTSMode")
		}
		return err
	}

	return nil
}

func (m *HostConfig) contextValidateUlimits(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Ulimits); i++ {

		if m.Ulimits[i] != nil {
			if err := m.Ulimits[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Ulimits" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Ulimits" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HostConfig) contextValidateUsernsMode(ctx context.Context, formats strfmt.Registry) error {

	if err := m.UsernsMode.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("UsernsMode")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("UsernsMode")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HostConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HostConfig) UnmarshalBinary(b []byte) error {
	var res HostConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
