// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// InspectContainerState InspectContainerState provides a detailed record of a container's current
// state. It is returned as part of InspectContainerData.
// As with InspectContainerData, many portions of this struct are matched to
// Docker, but here we see more fields that are unused (nonsensical in the
// context of Libpod).
//
// swagger:model InspectContainerState
type InspectContainerState struct {

	// cgroup path
	CgroupPath string `json:"CgroupPath,omitempty"`

	// checkpoint log
	CheckpointLog string `json:"CheckpointLog,omitempty"`

	// checkpoint path
	CheckpointPath string `json:"CheckpointPath,omitempty"`

	// checkpointed
	Checkpointed bool `json:"Checkpointed,omitempty"`

	// checkpointed at
	// Format: date-time
	CheckpointedAt strfmt.DateTime `json:"CheckpointedAt,omitempty"`

	// conmon pid
	ConmonPid int64 `json:"ConmonPid,omitempty"`

	// dead
	Dead bool `json:"Dead,omitempty"`

	// error
	Error string `json:"Error,omitempty"`

	// exit code
	ExitCode int32 `json:"ExitCode,omitempty"`

	// finished at
	// Format: date-time
	FinishedAt strfmt.DateTime `json:"FinishedAt,omitempty"`

	// health
	Health *HealthCheckResults `json:"Health,omitempty"`

	// o o m killed
	OOMKilled bool `json:"OOMKilled,omitempty"`

	// oci version
	OciVersion string `json:"OciVersion,omitempty"`

	// paused
	Paused bool `json:"Paused,omitempty"`

	// pid
	Pid int64 `json:"Pid,omitempty"`

	// restarting
	Restarting bool `json:"Restarting,omitempty"`

	// restore log
	RestoreLog string `json:"RestoreLog,omitempty"`

	// restored
	Restored bool `json:"Restored,omitempty"`

	// restored at
	// Format: date-time
	RestoredAt strfmt.DateTime `json:"RestoredAt,omitempty"`

	// running
	Running bool `json:"Running,omitempty"`

	// started at
	// Format: date-time
	StartedAt strfmt.DateTime `json:"StartedAt,omitempty"`

	// status
	Status string `json:"Status,omitempty"`
}

// Validate validates this inspect container state
func (m *InspectContainerState) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCheckpointedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFinishedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHealth(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRestoredAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *InspectContainerState) validateCheckpointedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CheckpointedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("CheckpointedAt", "body", "date-time", m.CheckpointedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *InspectContainerState) validateFinishedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.FinishedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("FinishedAt", "body", "date-time", m.FinishedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *InspectContainerState) validateHealth(formats strfmt.Registry) error {
	if swag.IsZero(m.Health) { // not required
		return nil
	}

	if m.Health != nil {
		if err := m.Health.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("Health")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("Health")
			}
			return err
		}
	}

	return nil
}

func (m *InspectContainerState) validateRestoredAt(formats strfmt.Registry) error {
	if swag.IsZero(m.RestoredAt) { // not required
		return nil
	}

	if err := validate.FormatOf("RestoredAt", "body", "date-time", m.RestoredAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *InspectContainerState) validateStartedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.StartedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("StartedAt", "body", "date-time", m.StartedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this inspect container state based on the context it is used
func (m *InspectContainerState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHealth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *InspectContainerState) contextValidateHealth(ctx context.Context, formats strfmt.Registry) error {

	if m.Health != nil {
		if err := m.Health.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("Health")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("Health")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *InspectContainerState) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *InspectContainerState) UnmarshalBinary(b []byte) error {
	var res InspectContainerState
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
