// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// PlayKubeReport PlayKubeReport contains the results of running play kube.
//
// swagger:model PlayKubeReport
type PlayKubeReport struct {

	// Pods - pods created by play kube.
	Pods []*PlayKubePod `json:"Pods"`

	// rm report
	RmReport []*PodRmReport `json:"RmReport"`

	// stop report
	StopReport []*PodStopReport `json:"StopReport"`

	// Volumes - volumes created by play kube.
	Volumes []*PlayKubeVolume `json:"Volumes"`
}

// Validate validates this play kube report
func (m *PlayKubeReport) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePods(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRmReport(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStopReport(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolumes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PlayKubeReport) validatePods(formats strfmt.Registry) error {
	if swag.IsZero(m.Pods) { // not required
		return nil
	}

	for i := 0; i < len(m.Pods); i++ {
		if swag.IsZero(m.Pods[i]) { // not required
			continue
		}

		if m.Pods[i] != nil {
			if err := m.Pods[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Pods" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Pods" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PlayKubeReport) validateRmReport(formats strfmt.Registry) error {
	if swag.IsZero(m.RmReport) { // not required
		return nil
	}

	for i := 0; i < len(m.RmReport); i++ {
		if swag.IsZero(m.RmReport[i]) { // not required
			continue
		}

		if m.RmReport[i] != nil {
			if err := m.RmReport[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("RmReport" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("RmReport" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PlayKubeReport) validateStopReport(formats strfmt.Registry) error {
	if swag.IsZero(m.StopReport) { // not required
		return nil
	}

	for i := 0; i < len(m.StopReport); i++ {
		if swag.IsZero(m.StopReport[i]) { // not required
			continue
		}

		if m.StopReport[i] != nil {
			if err := m.StopReport[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("StopReport" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("StopReport" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PlayKubeReport) validateVolumes(formats strfmt.Registry) error {
	if swag.IsZero(m.Volumes) { // not required
		return nil
	}

	for i := 0; i < len(m.Volumes); i++ {
		if swag.IsZero(m.Volumes[i]) { // not required
			continue
		}

		if m.Volumes[i] != nil {
			if err := m.Volumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Volumes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this play kube report based on the context it is used
func (m *PlayKubeReport) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePods(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRmReport(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStopReport(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PlayKubeReport) contextValidatePods(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Pods); i++ {

		if m.Pods[i] != nil {
			if err := m.Pods[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Pods" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Pods" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PlayKubeReport) contextValidateRmReport(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.RmReport); i++ {

		if m.RmReport[i] != nil {
			if err := m.RmReport[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("RmReport" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("RmReport" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PlayKubeReport) contextValidateStopReport(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.StopReport); i++ {

		if m.StopReport[i] != nil {
			if err := m.StopReport[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("StopReport" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("StopReport" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PlayKubeReport) contextValidateVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Volumes); i++ {

		if m.Volumes[i] != nil {
			if err := m.Volumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Volumes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *PlayKubeReport) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PlayKubeReport) UnmarshalBinary(b []byte) error {
	var res PlayKubeReport
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
