// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SpecGenerator SpecGenerator creates an OCI spec and Libpod configuration options to create
// a container based on the given configuration.
//
// swagger:model SpecGenerator
type SpecGenerator struct {

	// Annotations are key-value options passed into the container runtime
	// that can be used to trigger special behavior.
	// Optional.
	Annotations map[string]string `json:"annotations,omitempty"`

	// ApparmorProfile is the name of the Apparmor profile the container
	// will use.
	// Optional.
	ApparmorProfile string `json:"apparmor_profile,omitempty"`

	// CNINetworks is a list of CNI networks to join the container to.
	// If this list is empty, the default CNI network will be joined
	// instead. If at least one entry is present, we will not join the
	// default network (unless it is part of this list).
	// Only available if NetNS is set to bridge.
	// Optional.
	// Deprecated: as of podman 4.0 use "Networks" instead.
	CNINetworks []string `json:"cni_networks"`

	// CPU period of the cpuset, determined by --cpus
	CPUPeriod uint64 `json:"cpu_period,omitempty"`

	// CPU quota of the cpuset, determined by --cpus
	CPUQuota int64 `json:"cpu_quota,omitempty"`

	// CapAdd are capabilities which will be added to the container.
	// Conflicts with Privileged.
	// Optional.
	CapAdd []string `json:"cap_add"`

	// CapDrop are capabilities which will be removed from the container.
	// Conflicts with Privileged.
	// Optional.
	CapDrop []string `json:"cap_drop"`

	// CgroupConf are key-value options passed into the container runtime
	// that are used to configure cgroup v2.
	// Optional.
	CgroupConf map[string]string `json:"unified,omitempty"`

	// CgroupParent is the container's Cgroup parent.
	// If not set, the default for the current cgroup driver will be used.
	// Optional.
	CgroupParent string `json:"cgroup_parent,omitempty"`

	// CgroupsMode sets a policy for how cgroups will be created in the
	// container, including the ability to disable creation entirely.
	CgroupsMode string `json:"cgroups_mode,omitempty"`

	// Command is the container's command.
	// If not given and Image is specified, this will be populated by the
	// image's configuration.
	// Optional.
	Command []string `json:"command"`

	// ConmonPidFile is a path at which a PID file for Conmon will be
	// placed.
	// If not given, a default location will be used.
	// Optional.
	ConmonPidFile string `json:"conmon_pid_file,omitempty"`

	// ContainerCreateCommand is the command that was used to create this
	// container.
	// This will be shown in the output of Inspect() on the container, and
	// may also be used by some tools that wish to recreate the container
	// (e.g. `podman generate systemd --new`).
	// Optional.
	ContainerCreateCommand []string `json:"containerCreateCommand"`

	// Create the working directory if it doesn't exist.
	// If unset, it doesn't create it.
	// Optional.
	CreateWorkingDir bool `json:"create_working_dir,omitempty"`

	// DNSOptions is a set of DNS options that will be used in the
	// container's resolv.conf, replacing the host's DNS options which are
	// used by default.
	// Conflicts with UseImageResolvConf.
	// Optional.
	DNSOptions []string `json:"dns_option"`

	// DNSSearch is a set of DNS search domains that will be used in the
	// container's resolv.conf, replacing the host's DNS search domains
	// which are used by default.
	// Conflicts with UseImageResolvConf.
	// Optional.
	DNSSearch []string `json:"dns_search"`

	// DNSServers is a set of DNS servers that will be used in the
	// container's resolv.conf, replacing the host's DNS Servers which are
	// used by default.
	// Conflicts with UseImageResolvConf.
	// Optional.
	DNSServers []IP `json:"dns_server"`

	// DependencyContainers is an array of containers this container
	// depends on. Dependency containers must be started before this
	// container. Dependencies can be specified by name or full/partial ID.
	// Optional.
	DependencyContainers []string `json:"dependencyContainers"`

	// DeviceCgroupRule are device cgroup rules that allow containers
	// to use additional types of devices.
	DeviceCgroupRule []*LinuxDeviceCgroup `json:"device_cgroup_rule"`

	// Devices are devices that will be added to the container.
	// Optional.
	Devices []*LinuxDevice `json:"devices"`

	// DevicesFrom is a way to ensure your container inherits device specific information from another container
	DevicesFrom []string `json:"devices_from"`

	// Entrypoint is the container's entrypoint.
	// If not given and Image is specified, this will be populated by the
	// image's configuration.
	// Optional.
	Entrypoint []string `json:"entrypoint"`

	// Env is a set of environment variables that will be set in the
	// container.
	// Optional.
	Env map[string]string `json:"env,omitempty"`

	// EnvHost indicates that the host environment should be added to container
	// Optional.
	EnvHost bool `json:"env_host,omitempty"`

	// EnvSecrets are secrets that will be set as environment variables
	// Optional.
	EnvSecrets map[string]string `json:"secret_env,omitempty"`

	// Expose is a number of ports that will be forwarded to the container
	// if PublishExposedPorts is set.
	// Expose is a map of uint16 (port number) to a string representing
	// protocol i.e map[uint16]string. Allowed protocols are "tcp", "udp", and "sctp", or some
	// combination of the three separated by commas.
	// If protocol is set to "" we will assume TCP.
	// Only available if NetNS is set to Bridge or Slirp, and
	// PublishExposedPorts is set.
	// Optional.
	Expose interface{} `json:"expose,omitempty"`

	// Groups are a list of supplemental groups the container's user will
	// be granted access to.
	// Optional.
	Groups []string `json:"groups"`

	// EnvHTTPProxy indicates that the http host proxy environment variables
	// should be added to container
	// Optional.
	HTTPProxy bool `json:"httpproxy,omitempty"`

	// HostAdd is a set of hosts which will be added to the container's
	// etc/hosts file.
	// Conflicts with UseImageHosts.
	// Optional.
	HostAdd []string `json:"hostadd"`

	// HostDeviceList is used to recreate the mounted device on inherited containers
	HostDeviceList []*LinuxDevice `json:"host_device_list"`

	// HostUses is a list of host usernames or UIDs to add to the container
	// etc/passwd file
	HostUsers []string `json:"hostusers"`

	// Hostname is the container's hostname. If not set, the hostname will
	// not be modified (if UtsNS is not private) or will be set to the
	// container ID (if UtsNS is private).
	// Conflicts with UtsNS if UtsNS is not set to private.
	// Optional.
	Hostname string `json:"hostname,omitempty"`

	// Image is the image the container will be based on. The image will be
	// used as the container's root filesystem, and its environment vars,
	// volumes, and other configuration will be applied to the container.
	// Conflicts with Rootfs.
	// At least one of Image or Rootfs must be specified.
	Image string `json:"image,omitempty"`

	// ImageVolumeMode indicates how image volumes will be created.
	// Supported modes are "ignore" (do not create), "tmpfs" (create as
	// tmpfs), and "anonymous" (create as anonymous volumes).
	// The default if unset is anonymous.
	// Optional.
	ImageVolumeMode string `json:"image_volume_mode,omitempty"`

	// Image volumes bind-mount a container-image mount into the container.
	// Optional.
	ImageVolumes []*ImageVolume `json:"image_volumes"`

	// Init specifies that an init binary will be mounted into the
	// container, and will be used as PID1.
	Init bool `json:"init,omitempty"`

	// InitContainerType describes if this container is an init container
	// and if so, what type: always or once
	InitContainerType string `json:"init_container_type,omitempty"`

	// InitPath specifies the path to the init binary that will be added if
	// Init is specified above. If not specified, the default set in the
	// Libpod config will be used. Ignored if Init above is not set.
	// Optional.
	InitPath string `json:"init_path,omitempty"`

	// Labels are key-value pairs that are used to add metadata to
	// containers.
	// Optional.
	Labels map[string]string `json:"labels,omitempty"`

	// Mask is the path we want to mask in the container. This masks the paths
	// given in addition to the default list.
	// Optional
	Mask []string `json:"mask"`

	// Mounts are mounts that will be added to the container.
	// These will supersede Image Volumes and VolumesFrom volumes where
	// there are conflicts.
	// Optional.
	Mounts []*Mount `json:"mounts"`

	// Name is the name the container will be given.
	// If no name is provided, one will be randomly generated.
	// Optional.
	Name string `json:"name,omitempty"`

	// Namespace is the libpod namespace the container will be placed in.
	// Optional.
	Namespace string `json:"namespace,omitempty"`

	// NetworkOptions are additional options for each network
	// Optional.
	NetworkOptions map[string][]string `json:"network_options,omitempty"`

	// Map of networks names or ids that the container should join.
	// You can request additional settings for each network, you can
	// set network aliases, static ips, static mac address  and the
	// network interface name for this container on the specific network.
	// If the map is empty and the bridge network mode is set the container
	// will be joined to the default network.
	Networks map[string]PerNetworkOptions `json:"Networks,omitempty"`

	// NoNewPrivileges is whether the container will set the no new
	// privileges flag on create, which disables gaining additional
	// privileges (e.g. via setuid) in the container.
	NoNewPrivileges bool `json:"no_new_privileges,omitempty"`

	// OCIRuntime is the name of the OCI runtime that will be used to create
	// the container.
	// If not specified, the default will be used.
	// Optional.
	OCIRuntime string `json:"oci_runtime,omitempty"`

	// OOMScoreAdj adjusts the score used by the OOM killer to determine
	// processes to kill for the container's process.
	// Optional.
	OOMScoreAdj int64 `json:"oom_score_adj,omitempty"`

	// Overlay volumes are named volumes that will be added to the container.
	// Optional.
	OverlayVolumes []*OverlayVolume `json:"overlay_volumes"`

	// Passwd is a container run option that determines if we are validating users/groups before running the container
	Passwd bool `json:"manage_password,omitempty"`

	// Pod is the ID of the pod the container will join.
	// Optional.
	Pod string `json:"pod,omitempty"`

	// PortBindings is a set of ports to map into the container.
	// Only available if NetNS is set to bridge or slirp.
	// Optional.
	PortMappings []*PortMapping `json:"portmappings"`

	// Privileged is whether the container is privileged.
	// Privileged does the following:
	// Adds all devices on the system to the container.
	// Adds all capabilities to the container.
	// Disables Seccomp, SELinux, and Apparmor confinement.
	// (Though SELinux can be manually re-enabled).
	// TODO: this conflicts with things.
	// TODO: this does more.
	Privileged bool `json:"privileged,omitempty"`

	// ProcOpts are the options used for the proc mount.
	ProcOpts []string `json:"procfs_opts"`

	// PublishExposedPorts will publish ports specified in the image to
	// random unused ports (guaranteed to be above 1024) on the host.
	// This is based on ports set in Expose below, and any ports specified
	// by the Image (if one is given).
	// Only available if NetNS is set to Bridge or Slirp.
	PublishExposedPorts bool `json:"publish_image_ports,omitempty"`

	// RawImageName is the user-specified and unprocessed input referring
	// to a local or a remote image.
	RawImageName string `json:"raw_image_name,omitempty"`

	// ReadOnlyFilesystem indicates that everything will be mounted
	// as read-only
	ReadOnlyFilesystem bool `json:"read_only_filesystem,omitempty"`

	// Remove indicates if the container should be removed once it has been started
	// and exits
	Remove bool `json:"remove,omitempty"`

	// RestartPolicy is the container's restart policy - an action which
	// will be taken when the container exits.
	// If not given, the default policy, which does nothing, will be used.
	// Optional.
	RestartPolicy string `json:"restart_policy,omitempty"`

	// RestartRetries is the number of attempts that will be made to restart
	// the container.
	// Only available when RestartPolicy is set to "on-failure".
	// Optional.
	RestartRetries uint64 `json:"restart_tries,omitempty"`

	// Rlimits are POSIX rlimits to apply to the container.
	// Optional.
	Rlimits []*POSIXRlimit `json:"r_limits"`

	// Rootfs is the path to a directory that will be used as the
	// container's root filesystem. No modification will be made to the
	// directory, it will be directly mounted into the container as root.
	// Conflicts with Image.
	// At least one of Image or Rootfs must be specified.
	Rootfs string `json:"rootfs,omitempty"`

	// RootfsOverlay tells if rootfs is actually an overlay on top of base path
	RootfsOverlay bool `json:"rootfs_overlay,omitempty"`

	// RootfsPropagation is the rootfs propagation mode for the container.
	// If not set, the default of rslave will be used.
	// Optional.
	RootfsPropagation string `json:"rootfs_propagation,omitempty"`

	// Determine how to handle the NOTIFY_SOCKET - do we participate or pass it through
	// "container" - let the OCI runtime deal with it, advertise conmon's MAINPID
	// "conmon-only" - advertise conmon's MAINPID, send READY when started, don't pass to OCI
	// "ignore" - unset NOTIFY_SOCKET
	SdNotifyMode string `json:"sdnotifyMode,omitempty"`

	// SeccompPolicy determines which seccomp profile gets applied
	// the container. valid values: empty,default,image
	SeccompPolicy string `json:"seccomp_policy,omitempty"`

	// SeccompProfilePath is the path to a JSON file containing the
	// container's Seccomp profile.
	// If not specified, no Seccomp profile will be used.
	// Optional.
	SeccompProfilePath string `json:"seccomp_profile_path,omitempty"`

	// Secrets are the secrets that will be added to the container
	// Optional.
	Secrets []*Secret `json:"secrets"`

	// SelinuxProcessLabel is the process label the container will use.
	// If SELinux is enabled and this is not specified, a label will be
	// automatically generated if not specified.
	// Optional.
	SelinuxOpts []string `json:"selinux_opts"`

	// ShmSize is the size of the tmpfs to mount in at /dev/shm, in bytes.
	// Conflicts with ShmSize if IpcNS is not private.
	// Optional.
	ShmSize int64 `json:"shm_size,omitempty"`

	// Stdin is whether the container will keep its STDIN open.
	Stdin bool `json:"stdin,omitempty"`

	// StopTimeout is a timeout between the container's stop signal being
	// sent and SIGKILL being sent.
	// If not provided, the default will be used.
	// If 0 is used, stop signal will not be sent, and SIGKILL will be sent
	// instead.
	// Optional.
	StopTimeout uint64 `json:"stop_timeout,omitempty"`

	// StorageOpts is the container's storage options
	// Optional.
	StorageOpts map[string]string `json:"storage_opts,omitempty"`

	// Sysctl sets kernel parameters for the container
	Sysctl map[string]string `json:"sysctl,omitempty"`

	// Systemd is whether the container will be started in systemd mode.
	// Valid options are "true", "false", and "always".
	// "true" enables this mode only if the binary run in the container is
	// sbin/init or systemd. "always" unconditionally enables systemd mode.
	// "false" unconditionally disables systemd mode.
	// If enabled, mounts and stop signal will be modified.
	// If set to "always" or set to "true" and conditionally triggered,
	// conflicts with StopSignal.
	// If not specified, "false" will be assumed.
	// Optional.
	Systemd string `json:"systemd,omitempty"`

	// Terminal is whether the container will create a PTY.
	// Optional.
	Terminal bool `json:"terminal,omitempty"`

	// IO read rate limit per cgroup per device, bytes per second
	ThrottleReadBpsDevice map[string]LinuxThrottleDevice `json:"throttleReadBpsDevice,omitempty"`

	// IO read rate limit per cgroup per device, IO per second
	ThrottleReadIOPSDevice map[string]LinuxThrottleDevice `json:"throttleReadIOPSDevice,omitempty"`

	// IO write rate limit per cgroup per device, bytes per second
	ThrottleWriteBpsDevice map[string]LinuxThrottleDevice `json:"throttleWriteBpsDevice,omitempty"`

	// IO write rate limit per cgroup per device, IO per second
	ThrottleWriteIOPSDevice map[string]LinuxThrottleDevice `json:"throttleWriteIOPSDevice,omitempty"`

	// Timeout is a maximum time in seconds the container will run before
	// main process is sent SIGKILL.
	// If 0 is used, signal will not be sent. Container can run indefinitely
	// Optional.
	Timeout uint64 `json:"timeout,omitempty"`

	// Timezone is the timezone inside the container.
	// Local means it has the same timezone as the host machine
	// Optional.
	Timezone string `json:"timezone,omitempty"`

	// Umask is the umask the init process of the container will be run with.
	Umask string `json:"umask,omitempty"`

	// Unmask is the path we want to unmask in the container. To override
	// all the default paths that are masked, set unmask=ALL.
	Unmask []string `json:"unmask"`

	// UnsetEnv unsets the specified default environment variables from the image or from buildin or containers.conf
	// Optional.
	UnsetEnv []string `json:"unsetenv"`

	// UnsetEnvAll unsetall default environment variables from the image or from buildin or containers.conf
	// UnsetEnvAll unsets all default environment variables from the image or from buildin
	// Optional.
	UnsetEnvAll bool `json:"unsetenvall,omitempty"`

	// UseImageHosts indicates that /etc/hosts should not be managed by
	// Podman, and instead sourced from the image.
	// Conflicts with HostAdd.
	UseImageHosts bool `json:"use_image_hosts,omitempty"`

	// UseImageResolvConf indicates that resolv.conf should not be managed
	// by Podman, but instead sourced from the image.
	// Conflicts with DNSServer, DNSSearch, DNSOption.
	UseImageResolvConf bool `json:"use_image_resolve_conf,omitempty"`

	// User is the user the container will be run as.
	// Can be given as a UID or a username; if a username, it will be
	// resolved within the container, using the container's /etc/passwd.
	// If unset, the container will be run as root.
	// Optional.
	User string `json:"user,omitempty"`

	// Volatile specifies whether the container storage can be optimized
	// at the cost of not syncing all the dirty files in memory.
	Volatile bool `json:"volatile,omitempty"`

	// Volumes are named volumes that will be added to the container.
	// These will supersede Image Volumes and VolumesFrom volumes where
	// there are conflicts.
	// Optional.
	Volumes []*NamedVolume `json:"volumes"`

	// VolumesFrom is a set of containers whose volumes will be added to
	// this container. The name or ID of the container must be provided, and
	// may optionally be followed by a : and then one or more
	// comma-separated options. Valid options are 'ro', 'rw', and 'z'.
	// Options will be used for all volumes sourced from the container.
	VolumesFrom []string `json:"volumes_from"`

	// Weight per cgroup per device, can override BlkioWeight
	WeightDevice map[string]LinuxWeightDevice `json:"weightDevice,omitempty"`

	// WorkDir is the container's working directory.
	// If unset, the default, /, will be used.
	// Optional.
	WorkDir string `json:"work_dir,omitempty"`

	// cgroupns
	Cgroupns *Namespace `json:"cgroupns,omitempty"`

	// healthconfig
	Healthconfig *Schema2HealthConfig `json:"healthconfig,omitempty"`

	// idmappings
	Idmappings *IDMappingOptions `json:"idmappings,omitempty"`

	// ipcns
	Ipcns *Namespace `json:"ipcns,omitempty"`

	// log configuration
	LogConfiguration *LogConfig `json:"log_configuration,omitempty"`

	// netns
	Netns *Namespace `json:"netns,omitempty"`

	// personality
	Personality *LinuxPersonality `json:"personality,omitempty"`

	// pidns
	Pidns *Namespace `json:"pidns,omitempty"`

	// resource limits
	ResourceLimits *LinuxResources `json:"resource_limits,omitempty"`

	// stop signal
	StopSignal Signal `json:"stop_signal,omitempty"`

	// userns
	Userns *Namespace `json:"userns,omitempty"`

	// utsns
	Utsns *Namespace `json:"utsns,omitempty"`
}

// Validate validates this spec generator
func (m *SpecGenerator) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDNSServers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeviceCgroupRule(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDevices(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHostDeviceList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateImageVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMounts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetworks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOverlayVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePortMappings(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRlimits(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecrets(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThrottleReadBpsDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThrottleReadIOPSDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThrottleWriteBpsDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThrottleWriteIOPSDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWeightDevice(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCgroupns(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHealthconfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIdmappings(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIpcns(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogConfiguration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetns(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePersonality(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePidns(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResourceLimits(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStopSignal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserns(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUtsns(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SpecGenerator) validateDNSServers(formats strfmt.Registry) error {
	if swag.IsZero(m.DNSServers) { // not required
		return nil
	}

	for i := 0; i < len(m.DNSServers); i++ {

		if err := m.DNSServers[i].Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dns_server" + "." + strconv.Itoa(i))
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("dns_server" + "." + strconv.Itoa(i))
			}
			return err
		}

	}

	return nil
}

func (m *SpecGenerator) validateDeviceCgroupRule(formats strfmt.Registry) error {
	if swag.IsZero(m.DeviceCgroupRule) { // not required
		return nil
	}

	for i := 0; i < len(m.DeviceCgroupRule); i++ {
		if swag.IsZero(m.DeviceCgroupRule[i]) { // not required
			continue
		}

		if m.DeviceCgroupRule[i] != nil {
			if err := m.DeviceCgroupRule[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("device_cgroup_rule" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("device_cgroup_rule" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateDevices(formats strfmt.Registry) error {
	if swag.IsZero(m.Devices) { // not required
		return nil
	}

	for i := 0; i < len(m.Devices); i++ {
		if swag.IsZero(m.Devices[i]) { // not required
			continue
		}

		if m.Devices[i] != nil {
			if err := m.Devices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("devices" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("devices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateHostDeviceList(formats strfmt.Registry) error {
	if swag.IsZero(m.HostDeviceList) { // not required
		return nil
	}

	for i := 0; i < len(m.HostDeviceList); i++ {
		if swag.IsZero(m.HostDeviceList[i]) { // not required
			continue
		}

		if m.HostDeviceList[i] != nil {
			if err := m.HostDeviceList[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("host_device_list" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("host_device_list" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateImageVolumes(formats strfmt.Registry) error {
	if swag.IsZero(m.ImageVolumes) { // not required
		return nil
	}

	for i := 0; i < len(m.ImageVolumes); i++ {
		if swag.IsZero(m.ImageVolumes[i]) { // not required
			continue
		}

		if m.ImageVolumes[i] != nil {
			if err := m.ImageVolumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("image_volumes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("image_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateMounts(formats strfmt.Registry) error {
	if swag.IsZero(m.Mounts) { // not required
		return nil
	}

	for i := 0; i < len(m.Mounts); i++ {
		if swag.IsZero(m.Mounts[i]) { // not required
			continue
		}

		if m.Mounts[i] != nil {
			if err := m.Mounts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("mounts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("mounts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateNetworks(formats strfmt.Registry) error {
	if swag.IsZero(m.Networks) { // not required
		return nil
	}

	for k := range m.Networks {

		if err := validate.Required("Networks"+"."+k, "body", m.Networks[k]); err != nil {
			return err
		}
		if val, ok := m.Networks[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Networks" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Networks" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateOverlayVolumes(formats strfmt.Registry) error {
	if swag.IsZero(m.OverlayVolumes) { // not required
		return nil
	}

	for i := 0; i < len(m.OverlayVolumes); i++ {
		if swag.IsZero(m.OverlayVolumes[i]) { // not required
			continue
		}

		if m.OverlayVolumes[i] != nil {
			if err := m.OverlayVolumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("overlay_volumes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("overlay_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validatePortMappings(formats strfmt.Registry) error {
	if swag.IsZero(m.PortMappings) { // not required
		return nil
	}

	for i := 0; i < len(m.PortMappings); i++ {
		if swag.IsZero(m.PortMappings[i]) { // not required
			continue
		}

		if m.PortMappings[i] != nil {
			if err := m.PortMappings[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("portmappings" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("portmappings" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateRlimits(formats strfmt.Registry) error {
	if swag.IsZero(m.Rlimits) { // not required
		return nil
	}

	for i := 0; i < len(m.Rlimits); i++ {
		if swag.IsZero(m.Rlimits[i]) { // not required
			continue
		}

		if m.Rlimits[i] != nil {
			if err := m.Rlimits[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("r_limits" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("r_limits" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateSecrets(formats strfmt.Registry) error {
	if swag.IsZero(m.Secrets) { // not required
		return nil
	}

	for i := 0; i < len(m.Secrets); i++ {
		if swag.IsZero(m.Secrets[i]) { // not required
			continue
		}

		if m.Secrets[i] != nil {
			if err := m.Secrets[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("secrets" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("secrets" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateThrottleReadBpsDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.ThrottleReadBpsDevice) { // not required
		return nil
	}

	for k := range m.ThrottleReadBpsDevice {

		if err := validate.Required("throttleReadBpsDevice"+"."+k, "body", m.ThrottleReadBpsDevice[k]); err != nil {
			return err
		}
		if val, ok := m.ThrottleReadBpsDevice[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("throttleReadBpsDevice" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("throttleReadBpsDevice" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateThrottleReadIOPSDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.ThrottleReadIOPSDevice) { // not required
		return nil
	}

	for k := range m.ThrottleReadIOPSDevice {

		if err := validate.Required("throttleReadIOPSDevice"+"."+k, "body", m.ThrottleReadIOPSDevice[k]); err != nil {
			return err
		}
		if val, ok := m.ThrottleReadIOPSDevice[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("throttleReadIOPSDevice" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("throttleReadIOPSDevice" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateThrottleWriteBpsDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.ThrottleWriteBpsDevice) { // not required
		return nil
	}

	for k := range m.ThrottleWriteBpsDevice {

		if err := validate.Required("throttleWriteBpsDevice"+"."+k, "body", m.ThrottleWriteBpsDevice[k]); err != nil {
			return err
		}
		if val, ok := m.ThrottleWriteBpsDevice[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("throttleWriteBpsDevice" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("throttleWriteBpsDevice" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateThrottleWriteIOPSDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.ThrottleWriteIOPSDevice) { // not required
		return nil
	}

	for k := range m.ThrottleWriteIOPSDevice {

		if err := validate.Required("throttleWriteIOPSDevice"+"."+k, "body", m.ThrottleWriteIOPSDevice[k]); err != nil {
			return err
		}
		if val, ok := m.ThrottleWriteIOPSDevice[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("throttleWriteIOPSDevice" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("throttleWriteIOPSDevice" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateVolumes(formats strfmt.Registry) error {
	if swag.IsZero(m.Volumes) { // not required
		return nil
	}

	for i := 0; i < len(m.Volumes); i++ {
		if swag.IsZero(m.Volumes[i]) { // not required
			continue
		}

		if m.Volumes[i] != nil {
			if err := m.Volumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateWeightDevice(formats strfmt.Registry) error {
	if swag.IsZero(m.WeightDevice) { // not required
		return nil
	}

	for k := range m.WeightDevice {

		if err := validate.Required("weightDevice"+"."+k, "body", m.WeightDevice[k]); err != nil {
			return err
		}
		if val, ok := m.WeightDevice[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("weightDevice" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("weightDevice" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) validateCgroupns(formats strfmt.Registry) error {
	if swag.IsZero(m.Cgroupns) { // not required
		return nil
	}

	if m.Cgroupns != nil {
		if err := m.Cgroupns.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cgroupns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cgroupns")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) validateHealthconfig(formats strfmt.Registry) error {
	if swag.IsZero(m.Healthconfig) { // not required
		return nil
	}

	if m.Healthconfig != nil {
		if err := m.Healthconfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("healthconfig")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("healthconfig")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) validateIdmappings(formats strfmt.Registry) error {
	if swag.IsZero(m.Idmappings) { // not required
		return nil
	}

	if m.Idmappings != nil {
		if err := m.Idmappings.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("idmappings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("idmappings")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) validateIpcns(formats strfmt.Registry) error {
	if swag.IsZero(m.Ipcns) { // not required
		return nil
	}

	if m.Ipcns != nil {
		if err := m.Ipcns.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipcns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ipcns")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) validateLogConfiguration(formats strfmt.Registry) error {
	if swag.IsZero(m.LogConfiguration) { // not required
		return nil
	}

	if m.LogConfiguration != nil {
		if err := m.LogConfiguration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("log_configuration")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("log_configuration")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) validateNetns(formats strfmt.Registry) error {
	if swag.IsZero(m.Netns) { // not required
		return nil
	}

	if m.Netns != nil {
		if err := m.Netns.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("netns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("netns")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) validatePersonality(formats strfmt.Registry) error {
	if swag.IsZero(m.Personality) { // not required
		return nil
	}

	if m.Personality != nil {
		if err := m.Personality.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("personality")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("personality")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) validatePidns(formats strfmt.Registry) error {
	if swag.IsZero(m.Pidns) { // not required
		return nil
	}

	if m.Pidns != nil {
		if err := m.Pidns.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pidns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pidns")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) validateResourceLimits(formats strfmt.Registry) error {
	if swag.IsZero(m.ResourceLimits) { // not required
		return nil
	}

	if m.ResourceLimits != nil {
		if err := m.ResourceLimits.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource_limits")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource_limits")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) validateStopSignal(formats strfmt.Registry) error {
	if swag.IsZero(m.StopSignal) { // not required
		return nil
	}

	if err := m.StopSignal.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("stop_signal")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("stop_signal")
		}
		return err
	}

	return nil
}

func (m *SpecGenerator) validateUserns(formats strfmt.Registry) error {
	if swag.IsZero(m.Userns) { // not required
		return nil
	}

	if m.Userns != nil {
		if err := m.Userns.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("userns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("userns")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) validateUtsns(formats strfmt.Registry) error {
	if swag.IsZero(m.Utsns) { // not required
		return nil
	}

	if m.Utsns != nil {
		if err := m.Utsns.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("utsns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("utsns")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this spec generator based on the context it is used
func (m *SpecGenerator) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDNSServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDeviceCgroupRule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDevices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHostDeviceList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateImageVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetworks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOverlayVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePortMappings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRlimits(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecrets(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThrottleReadBpsDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThrottleReadIOPSDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThrottleWriteBpsDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThrottleWriteIOPSDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWeightDevice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCgroupns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHealthconfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIdmappings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIpcns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogConfiguration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePersonality(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePidns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResourceLimits(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStopSignal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUserns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUtsns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SpecGenerator) contextValidateDNSServers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DNSServers); i++ {

		if err := m.DNSServers[i].ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dns_server" + "." + strconv.Itoa(i))
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("dns_server" + "." + strconv.Itoa(i))
			}
			return err
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateDeviceCgroupRule(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DeviceCgroupRule); i++ {

		if m.DeviceCgroupRule[i] != nil {
			if err := m.DeviceCgroupRule[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("device_cgroup_rule" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("device_cgroup_rule" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateDevices(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Devices); i++ {

		if m.Devices[i] != nil {
			if err := m.Devices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("devices" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("devices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateHostDeviceList(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.HostDeviceList); i++ {

		if m.HostDeviceList[i] != nil {
			if err := m.HostDeviceList[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("host_device_list" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("host_device_list" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateImageVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ImageVolumes); i++ {

		if m.ImageVolumes[i] != nil {
			if err := m.ImageVolumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("image_volumes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("image_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateMounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Mounts); i++ {

		if m.Mounts[i] != nil {
			if err := m.Mounts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("mounts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("mounts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateNetworks(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.Networks {

		if val, ok := m.Networks[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateOverlayVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.OverlayVolumes); i++ {

		if m.OverlayVolumes[i] != nil {
			if err := m.OverlayVolumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("overlay_volumes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("overlay_volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidatePortMappings(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PortMappings); i++ {

		if m.PortMappings[i] != nil {
			if err := m.PortMappings[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("portmappings" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("portmappings" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateRlimits(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Rlimits); i++ {

		if m.Rlimits[i] != nil {
			if err := m.Rlimits[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("r_limits" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("r_limits" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateSecrets(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Secrets); i++ {

		if m.Secrets[i] != nil {
			if err := m.Secrets[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("secrets" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("secrets" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateThrottleReadBpsDevice(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.ThrottleReadBpsDevice {

		if val, ok := m.ThrottleReadBpsDevice[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateThrottleReadIOPSDevice(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.ThrottleReadIOPSDevice {

		if val, ok := m.ThrottleReadIOPSDevice[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateThrottleWriteBpsDevice(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.ThrottleWriteBpsDevice {

		if val, ok := m.ThrottleWriteBpsDevice[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateThrottleWriteIOPSDevice(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.ThrottleWriteIOPSDevice {

		if val, ok := m.ThrottleWriteIOPSDevice[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Volumes); i++ {

		if m.Volumes[i] != nil {
			if err := m.Volumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateWeightDevice(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.WeightDevice {

		if val, ok := m.WeightDevice[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *SpecGenerator) contextValidateCgroupns(ctx context.Context, formats strfmt.Registry) error {

	if m.Cgroupns != nil {
		if err := m.Cgroupns.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cgroupns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cgroupns")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) contextValidateHealthconfig(ctx context.Context, formats strfmt.Registry) error {

	if m.Healthconfig != nil {
		if err := m.Healthconfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("healthconfig")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("healthconfig")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) contextValidateIdmappings(ctx context.Context, formats strfmt.Registry) error {

	if m.Idmappings != nil {
		if err := m.Idmappings.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("idmappings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("idmappings")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) contextValidateIpcns(ctx context.Context, formats strfmt.Registry) error {

	if m.Ipcns != nil {
		if err := m.Ipcns.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipcns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ipcns")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) contextValidateLogConfiguration(ctx context.Context, formats strfmt.Registry) error {

	if m.LogConfiguration != nil {
		if err := m.LogConfiguration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("log_configuration")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("log_configuration")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) contextValidateNetns(ctx context.Context, formats strfmt.Registry) error {

	if m.Netns != nil {
		if err := m.Netns.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("netns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("netns")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) contextValidatePersonality(ctx context.Context, formats strfmt.Registry) error {

	if m.Personality != nil {
		if err := m.Personality.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("personality")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("personality")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) contextValidatePidns(ctx context.Context, formats strfmt.Registry) error {

	if m.Pidns != nil {
		if err := m.Pidns.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pidns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pidns")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) contextValidateResourceLimits(ctx context.Context, formats strfmt.Registry) error {

	if m.ResourceLimits != nil {
		if err := m.ResourceLimits.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource_limits")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource_limits")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) contextValidateStopSignal(ctx context.Context, formats strfmt.Registry) error {

	if err := m.StopSignal.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("stop_signal")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("stop_signal")
		}
		return err
	}

	return nil
}

func (m *SpecGenerator) contextValidateUserns(ctx context.Context, formats strfmt.Registry) error {

	if m.Userns != nil {
		if err := m.Userns.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("userns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("userns")
			}
			return err
		}
	}

	return nil
}

func (m *SpecGenerator) contextValidateUtsns(ctx context.Context, formats strfmt.Registry) error {

	if m.Utsns != nil {
		if err := m.Utsns.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("utsns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("utsns")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SpecGenerator) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SpecGenerator) UnmarshalBinary(b []byte) error {
	var res SpecGenerator
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
